package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CidrAuthorizationContext(message: String, signature: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CidrAuthorizationContext = {
    import CidrAuthorizationContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CidrAuthorizationContext
      .builder()
      .message(message: java.lang.String)
      .signature(signature: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CidrAuthorizationContext.ReadOnly =
    zio.aws.ec2.model.CidrAuthorizationContext.wrap(buildAwsValue())
}
object CidrAuthorizationContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CidrAuthorizationContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CidrAuthorizationContext =
      zio.aws.ec2.model.CidrAuthorizationContext(message, signature)
    def message: String
    def signature: String
    def getMessage: ZIO[Any, Nothing, String] = ZIO.succeed(message)
    def getSignature: ZIO[Any, Nothing, String] = ZIO.succeed(signature)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CidrAuthorizationContext
  ) extends zio.aws.ec2.model.CidrAuthorizationContext.ReadOnly {
    override val message: String = impl.message(): String
    override val signature: String = impl.signature(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CidrAuthorizationContext
  ): zio.aws.ec2.model.CidrAuthorizationContext.ReadOnly = new Wrapper(impl)
}
