package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcPeeringConnectionOptionsDescription(
    allowDnsResolutionFromRemoteVpc: Optional[Boolean] = Optional.Absent,
    allowEgressFromLocalClassicLinkToRemoteVpc: Optional[Boolean] =
      Optional.Absent,
    allowEgressFromLocalVpcToRemoteClassicLink: Optional[Boolean] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionOptionsDescription = {
    import VpcPeeringConnectionOptionsDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionOptionsDescription
      .builder()
      .optionallyWith(
        allowDnsResolutionFromRemoteVpc.map(value => value: java.lang.Boolean)
      )(_.allowDnsResolutionFromRemoteVpc)
      .optionallyWith(
        allowEgressFromLocalClassicLinkToRemoteVpc.map(value =>
          value: java.lang.Boolean
        )
      )(_.allowEgressFromLocalClassicLinkToRemoteVpc)
      .optionallyWith(
        allowEgressFromLocalVpcToRemoteClassicLink.map(value =>
          value: java.lang.Boolean
        )
      )(_.allowEgressFromLocalVpcToRemoteClassicLink)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription.ReadOnly =
    zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription
      .wrap(buildAwsValue())
}
object VpcPeeringConnectionOptionsDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionOptionsDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription =
      zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription(
        allowDnsResolutionFromRemoteVpc.map(value => value),
        allowEgressFromLocalClassicLinkToRemoteVpc.map(value => value),
        allowEgressFromLocalVpcToRemoteClassicLink.map(value => value)
      )
    def allowDnsResolutionFromRemoteVpc: Optional[Boolean]
    def allowEgressFromLocalClassicLinkToRemoteVpc: Optional[Boolean]
    def allowEgressFromLocalVpcToRemoteClassicLink: Optional[Boolean]
    def getAllowDnsResolutionFromRemoteVpc: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "allowDnsResolutionFromRemoteVpc",
        allowDnsResolutionFromRemoteVpc
      )
    def getAllowEgressFromLocalClassicLinkToRemoteVpc
        : ZIO[Any, AwsError, Boolean] = AwsError.unwrapOptionField(
      "allowEgressFromLocalClassicLinkToRemoteVpc",
      allowEgressFromLocalClassicLinkToRemoteVpc
    )
    def getAllowEgressFromLocalVpcToRemoteClassicLink
        : ZIO[Any, AwsError, Boolean] = AwsError.unwrapOptionField(
      "allowEgressFromLocalVpcToRemoteClassicLink",
      allowEgressFromLocalVpcToRemoteClassicLink
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionOptionsDescription
  ) extends zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription.ReadOnly {
    override val allowDnsResolutionFromRemoteVpc: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowDnsResolutionFromRemoteVpc())
        .map(value => value: Boolean)
    override val allowEgressFromLocalClassicLinkToRemoteVpc: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowEgressFromLocalClassicLinkToRemoteVpc())
        .map(value => value: Boolean)
    override val allowEgressFromLocalVpcToRemoteClassicLink: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowEgressFromLocalVpcToRemoteClassicLink())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionOptionsDescription
  ): zio.aws.ec2.model.VpcPeeringConnectionOptionsDescription.ReadOnly =
    new Wrapper(impl)
}
