package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayRouteTableRoute(
    destinationCidr: Optional[String] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    routeOrigin: Optional[String] = Optional.Absent,
    prefixListId: Optional[String] = Optional.Absent,
    attachmentId: Optional[String] = Optional.Absent,
    resourceId: Optional[String] = Optional.Absent,
    resourceType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableRoute = {
    import TransitGatewayRouteTableRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableRoute
      .builder()
      .optionallyWith(destinationCidr.map(value => value: java.lang.String))(
        _.destinationCidr
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(routeOrigin.map(value => value: java.lang.String))(
        _.routeOrigin
      )
      .optionallyWith(prefixListId.map(value => value: java.lang.String))(
        _.prefixListId
      )
      .optionallyWith(attachmentId.map(value => value: java.lang.String))(
        _.attachmentId
      )
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly =
    zio.aws.ec2.model.TransitGatewayRouteTableRoute.wrap(buildAwsValue())
}
object TransitGatewayRouteTableRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayRouteTableRoute =
      zio.aws.ec2.model.TransitGatewayRouteTableRoute(
        destinationCidr.map(value => value),
        state.map(value => value),
        routeOrigin.map(value => value),
        prefixListId.map(value => value),
        attachmentId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value)
      )
    def destinationCidr: Optional[String]
    def state: Optional[String]
    def routeOrigin: Optional[String]
    def prefixListId: Optional[String]
    def attachmentId: Optional[String]
    def resourceId: Optional[String]
    def resourceType: Optional[String]
    def getDestinationCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidr", destinationCidr)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getRouteOrigin: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("routeOrigin", routeOrigin)
    def getPrefixListId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attachmentId", attachmentId)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableRoute
  ) extends zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly {
    override val destinationCidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidr())
      .map(value => value: String)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val routeOrigin: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.routeOrigin())
      .map(value => value: String)
    override val prefixListId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefixListId())
      .map(value => value: String)
    override val attachmentId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentId())
      .map(value => value: String)
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val resourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableRoute
  ): zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly = new Wrapper(
    impl
  )
}
