package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayMulticastGroup(
    groupIpAddress: Optional[String] = Optional.Absent,
    transitGatewayAttachmentId: Optional[String] = Optional.Absent,
    subnetId: Optional[String] = Optional.Absent,
    resourceId: Optional[String] = Optional.Absent,
    resourceType: Optional[
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = Optional.Absent,
    resourceOwnerId: Optional[String] = Optional.Absent,
    networkInterfaceId: Optional[String] = Optional.Absent,
    groupMember: Optional[Boolean] = Optional.Absent,
    groupSource: Optional[Boolean] = Optional.Absent,
    memberType: Optional[zio.aws.ec2.model.MembershipType] = Optional.Absent,
    sourceType: Optional[zio.aws.ec2.model.MembershipType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastGroup = {
    import TransitGatewayMulticastGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastGroup
      .builder()
      .optionallyWith(groupIpAddress.map(value => value: java.lang.String))(
        _.groupIpAddress
      )
      .optionallyWith(
        transitGatewayAttachmentId.map(value => value: java.lang.String)
      )(_.transitGatewayAttachmentId)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(
        _.resourceOwnerId
      )
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(groupMember.map(value => value: java.lang.Boolean))(
        _.groupMember
      )
      .optionallyWith(groupSource.map(value => value: java.lang.Boolean))(
        _.groupSource
      )
      .optionallyWith(memberType.map(value => value.unwrap))(_.memberType)
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayMulticastGroup.ReadOnly =
    zio.aws.ec2.model.TransitGatewayMulticastGroup.wrap(buildAwsValue())
}
object TransitGatewayMulticastGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayMulticastGroup =
      zio.aws.ec2.model.TransitGatewayMulticastGroup(
        groupIpAddress.map(value => value),
        transitGatewayAttachmentId.map(value => value),
        subnetId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        resourceOwnerId.map(value => value),
        networkInterfaceId.map(value => value),
        groupMember.map(value => value),
        groupSource.map(value => value),
        memberType.map(value => value),
        sourceType.map(value => value)
      )
    def groupIpAddress: Optional[String]
    def transitGatewayAttachmentId: Optional[String]
    def subnetId: Optional[String]
    def resourceId: Optional[String]
    def resourceType
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentResourceType]
    def resourceOwnerId: Optional[String]
    def networkInterfaceId: Optional[String]
    def groupMember: Optional[Boolean]
    def groupSource: Optional[Boolean]
    def memberType: Optional[zio.aws.ec2.model.MembershipType]
    def sourceType: Optional[zio.aws.ec2.model.MembershipType]
    def getGroupIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupIpAddress", groupIpAddress)
    def getTransitGatewayAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getGroupMember: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("groupMember", groupMember)
    def getGroupSource: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("groupSource", groupSource)
    def getMemberType: ZIO[Any, AwsError, zio.aws.ec2.model.MembershipType] =
      AwsError.unwrapOptionField("memberType", memberType)
    def getSourceType: ZIO[Any, AwsError, zio.aws.ec2.model.MembershipType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastGroup
  ) extends zio.aws.ec2.model.TransitGatewayMulticastGroup.ReadOnly {
    override val groupIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupIpAddress())
      .map(value => value: String)
    override val transitGatewayAttachmentId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayAttachmentId())
        .map(value => value: String)
    override val subnetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => value: String)
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val resourceType
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayAttachmentResourceType.wrap(value)
        )
    override val resourceOwnerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceOwnerId())
      .map(value => value: String)
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
    override val groupMember: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.groupMember())
      .map(value => value: Boolean)
    override val groupSource: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.groupSource())
      .map(value => value: Boolean)
    override val memberType: Optional[zio.aws.ec2.model.MembershipType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memberType())
        .map(value => zio.aws.ec2.model.MembershipType.wrap(value))
    override val sourceType: Optional[zio.aws.ec2.model.MembershipType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.ec2.model.MembershipType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastGroup
  ): zio.aws.ec2.model.TransitGatewayMulticastGroup.ReadOnly = new Wrapper(impl)
}
