package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RouteTable(
    associations: Optional[Iterable[zio.aws.ec2.model.RouteTableAssociation]] =
      Optional.Absent,
    propagatingVgws: Optional[Iterable[zio.aws.ec2.model.PropagatingVgw]] =
      Optional.Absent,
    routeTableId: Optional[String] = Optional.Absent,
    routes: Optional[Iterable[zio.aws.ec2.model.Route]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.RouteTable = {
    import RouteTable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RouteTable
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(
        propagatingVgws.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.propagatingVgws)
      .optionallyWith(routeTableId.map(value => value: java.lang.String))(
        _.routeTableId
      )
      .optionallyWith(
        routes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routes)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RouteTable.ReadOnly =
    zio.aws.ec2.model.RouteTable.wrap(buildAwsValue())
}
object RouteTable {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.RouteTable] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RouteTable = zio.aws.ec2.model.RouteTable(
      associations.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      propagatingVgws.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      routeTableId.map(value => value),
      routes.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      vpcId.map(value => value),
      ownerId.map(value => value)
    )
    def associations
        : Optional[List[zio.aws.ec2.model.RouteTableAssociation.ReadOnly]]
    def propagatingVgws
        : Optional[List[zio.aws.ec2.model.PropagatingVgw.ReadOnly]]
    def routeTableId: Optional[String]
    def routes: Optional[List[zio.aws.ec2.model.Route.ReadOnly]]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def vpcId: Optional[String]
    def ownerId: Optional[String]
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.RouteTableAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getPropagatingVgws
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PropagatingVgw.ReadOnly]] =
      AwsError.unwrapOptionField("propagatingVgws", propagatingVgws)
    def getRouteTableId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getRoutes: ZIO[Any, AwsError, List[zio.aws.ec2.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField("routes", routes)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RouteTable
  ) extends zio.aws.ec2.model.RouteTable.ReadOnly {
    override val associations
        : Optional[List[zio.aws.ec2.model.RouteTableAssociation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RouteTableAssociation.wrap(item)
          }.toList
        )
    override val propagatingVgws
        : Optional[List[zio.aws.ec2.model.PropagatingVgw.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propagatingVgws())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PropagatingVgw.wrap(item)
          }.toList
        )
    override val routeTableId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.routeTableId())
      .map(value => value: String)
    override val routes: Optional[List[zio.aws.ec2.model.Route.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Route.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RouteTable
  ): zio.aws.ec2.model.RouteTable.ReadOnly = new Wrapper(impl)
}
