package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReservationValue(
    hourlyPrice: Optional[String] = Optional.Absent,
    remainingTotalValue: Optional[String] = Optional.Absent,
    remainingUpfrontValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservationValue = {
    import ReservationValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservationValue
      .builder()
      .optionallyWith(hourlyPrice.map(value => value: java.lang.String))(
        _.hourlyPrice
      )
      .optionallyWith(
        remainingTotalValue.map(value => value: java.lang.String)
      )(_.remainingTotalValue)
      .optionallyWith(
        remainingUpfrontValue.map(value => value: java.lang.String)
      )(_.remainingUpfrontValue)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReservationValue.ReadOnly =
    zio.aws.ec2.model.ReservationValue.wrap(buildAwsValue())
}
object ReservationValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservationValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservationValue =
      zio.aws.ec2.model.ReservationValue(
        hourlyPrice.map(value => value),
        remainingTotalValue.map(value => value),
        remainingUpfrontValue.map(value => value)
      )
    def hourlyPrice: Optional[String]
    def remainingTotalValue: Optional[String]
    def remainingUpfrontValue: Optional[String]
    def getHourlyPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hourlyPrice", hourlyPrice)
    def getRemainingTotalValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("remainingTotalValue", remainingTotalValue)
    def getRemainingUpfrontValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("remainingUpfrontValue", remainingUpfrontValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservationValue
  ) extends zio.aws.ec2.model.ReservationValue.ReadOnly {
    override val hourlyPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hourlyPrice())
      .map(value => value: String)
    override val remainingTotalValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.remainingTotalValue())
      .map(value => value: String)
    override val remainingUpfrontValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.remainingUpfrontValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservationValue
  ): zio.aws.ec2.model.ReservationValue.ReadOnly = new Wrapper(impl)
}
