package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait NetworkInterfacePermissionStateCode {
  def unwrap: software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode
}
object NetworkInterfacePermissionStateCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode
  ): zio.aws.ec2.model.NetworkInterfacePermissionStateCode = value match {
    case software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode.GRANTED =>
      val r = granted
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode.REVOKING =>
      val r = revoking
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode.REVOKED =>
      val r = revoked
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.NetworkInterfacePermissionStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode =
      software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode.UNKNOWN_TO_SDK_VERSION
  }
  case object pending
      extends zio.aws.ec2.model.NetworkInterfacePermissionStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode =
      software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode.PENDING
  }
  case object granted
      extends zio.aws.ec2.model.NetworkInterfacePermissionStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode =
      software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode.GRANTED
  }
  case object revoking
      extends zio.aws.ec2.model.NetworkInterfacePermissionStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode =
      software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode.REVOKING
  }
  case object revoked
      extends zio.aws.ec2.model.NetworkInterfacePermissionStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode =
      software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode.REVOKED
  }
}
