package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  LocalGatewayVirtualInterfaceId,
  LocalGatewayVirtualInterfaceGroupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LocalGatewayVirtualInterfaceGroup(
    localGatewayVirtualInterfaceGroupId: Optional[
      LocalGatewayVirtualInterfaceGroupId
    ] = Optional.Absent,
    localGatewayVirtualInterfaceIds: Optional[
      Iterable[LocalGatewayVirtualInterfaceId]
    ] = Optional.Absent,
    localGatewayId: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterfaceGroup = {
    import LocalGatewayVirtualInterfaceGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterfaceGroup
      .builder()
      .optionallyWith(
        localGatewayVirtualInterfaceGroupId.map(value =>
          LocalGatewayVirtualInterfaceGroupId.unwrap(value): java.lang.String
        )
      )(_.localGatewayVirtualInterfaceGroupId)
      .optionallyWith(
        localGatewayVirtualInterfaceIds.map(value =>
          value.map { item =>
            LocalGatewayVirtualInterfaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.localGatewayVirtualInterfaceIds)
      .optionallyWith(localGatewayId.map(value => value: java.lang.String))(
        _.localGatewayId
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup.ReadOnly =
    zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup.wrap(buildAwsValue())
}
object LocalGatewayVirtualInterfaceGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterfaceGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup =
      zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup(
        localGatewayVirtualInterfaceGroupId.map(value => value),
        localGatewayVirtualInterfaceIds.map(value => value),
        localGatewayId.map(value => value),
        ownerId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def localGatewayVirtualInterfaceGroupId
        : Optional[LocalGatewayVirtualInterfaceGroupId]
    def localGatewayVirtualInterfaceIds
        : Optional[List[LocalGatewayVirtualInterfaceId]]
    def localGatewayId: Optional[String]
    def ownerId: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getLocalGatewayVirtualInterfaceGroupId
        : ZIO[Any, AwsError, LocalGatewayVirtualInterfaceGroupId] =
      AwsError.unwrapOptionField(
        "localGatewayVirtualInterfaceGroupId",
        localGatewayVirtualInterfaceGroupId
      )
    def getLocalGatewayVirtualInterfaceIds
        : ZIO[Any, AwsError, List[LocalGatewayVirtualInterfaceId]] =
      AwsError.unwrapOptionField(
        "localGatewayVirtualInterfaceIds",
        localGatewayVirtualInterfaceIds
      )
    def getLocalGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("localGatewayId", localGatewayId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterfaceGroup
  ) extends zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup.ReadOnly {
    override val localGatewayVirtualInterfaceGroupId
        : Optional[LocalGatewayVirtualInterfaceGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.localGatewayVirtualInterfaceGroupId())
      .map(value =>
        zio.aws.ec2.model.primitives.LocalGatewayVirtualInterfaceGroupId(value)
      )
    override val localGatewayVirtualInterfaceIds
        : Optional[List[LocalGatewayVirtualInterfaceId]] = zio.aws.core.internal
      .optionalFromNullable(impl.localGatewayVirtualInterfaceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.LocalGatewayVirtualInterfaceId(item)
        }.toList
      )
    override val localGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.localGatewayId())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterfaceGroup
  ): zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup.ReadOnly = new Wrapper(
    impl
  )
}
