package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceLifecycleType {
  def unwrap: software.amazon.awssdk.services.ec2.model.InstanceLifecycleType
}
object InstanceLifecycleType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceLifecycleType
  ): zio.aws.ec2.model.InstanceLifecycleType = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceLifecycleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceLifecycleType.SPOT =>
      val r = spot
      r
    case software.amazon.awssdk.services.ec2.model.InstanceLifecycleType.SCHEDULED =>
      val r = scheduled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InstanceLifecycleType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceLifecycleType =
      software.amazon.awssdk.services.ec2.model.InstanceLifecycleType.UNKNOWN_TO_SDK_VERSION
  }
  case object spot extends zio.aws.ec2.model.InstanceLifecycleType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceLifecycleType =
      software.amazon.awssdk.services.ec2.model.InstanceLifecycleType.SPOT
  }
  case object scheduled extends zio.aws.ec2.model.InstanceLifecycleType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceLifecycleType =
      software.amazon.awssdk.services.ec2.model.InstanceLifecycleType.SCHEDULED
  }
}
