package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FindingsFound {
  def unwrap: software.amazon.awssdk.services.ec2.model.FindingsFound
}
object FindingsFound {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FindingsFound
  ): zio.aws.ec2.model.FindingsFound = value match {
    case software.amazon.awssdk.services.ec2.model.FindingsFound.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FindingsFound.TRUE =>
      val r = `true`
      r
    case software.amazon.awssdk.services.ec2.model.FindingsFound.FALSE =>
      val r = `false`
      r
    case software.amazon.awssdk.services.ec2.model.FindingsFound.UNKNOWN =>
      val r = unknown
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.FindingsFound {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FindingsFound =
      software.amazon.awssdk.services.ec2.model.FindingsFound.UNKNOWN_TO_SDK_VERSION
  }
  case object `true` extends zio.aws.ec2.model.FindingsFound {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FindingsFound =
      software.amazon.awssdk.services.ec2.model.FindingsFound.TRUE
  }
  case object `false` extends zio.aws.ec2.model.FindingsFound {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FindingsFound =
      software.amazon.awssdk.services.ec2.model.FindingsFound.FALSE
  }
  case object unknown extends zio.aws.ec2.model.FindingsFound {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FindingsFound =
      software.amazon.awssdk.services.ec2.model.FindingsFound.UNKNOWN
  }
}
