package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait EbsOptimizedSupport {
  def unwrap: software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport
}
object EbsOptimizedSupport {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport
  ): zio.aws.ec2.model.EbsOptimizedSupport = value match {
    case software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport.UNSUPPORTED =>
      val r = unsupported
      r
    case software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport.SUPPORTED =>
      val r = supported
      r
    case software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport.DEFAULT =>
      val r = default
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.EbsOptimizedSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport =
      software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport.UNKNOWN_TO_SDK_VERSION
  }
  case object unsupported extends zio.aws.ec2.model.EbsOptimizedSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport =
      software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport.UNSUPPORTED
  }
  case object supported extends zio.aws.ec2.model.EbsOptimizedSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport =
      software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport.SUPPORTED
  }
  case object default extends zio.aws.ec2.model.EbsOptimizedSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport =
      software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport.DEFAULT
  }
}
