package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVolumesResponse(
    volumes: Optional[Iterable[zio.aws.ec2.model.Volume]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse = {
    import DescribeVolumesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse
      .builder()
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVolumesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVolumesResponse.wrap(buildAwsValue())
}
object DescribeVolumesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVolumesResponse =
      zio.aws.ec2.model.DescribeVolumesResponse(
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def volumes: Optional[List[zio.aws.ec2.model.Volume.ReadOnly]]
    def nextToken: Optional[String]
    def getVolumes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Volume.ReadOnly]] =
      AwsError.unwrapOptionField("volumes", volumes)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse
  ) extends zio.aws.ec2.model.DescribeVolumesResponse.ReadOnly {
    override val volumes: Optional[List[zio.aws.ec2.model.Volume.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Volume.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse
  ): zio.aws.ec2.model.DescribeVolumesResponse.ReadOnly = new Wrapper(impl)
}
