package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NatGatewayId,
  DescribeNatGatewaysMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeNatGatewaysRequest(
    filter: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[DescribeNatGatewaysMaxResults] = Optional.Absent,
    natGatewayIds: Optional[Iterable[NatGatewayId]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest = {
    import DescribeNatGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest
      .builder()
      .optionallyWith(
        filter.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filter)
      .optionallyWith(
        maxResults.map(value =>
          DescribeNatGatewaysMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        natGatewayIds.map(value =>
          value.map { item =>
            NatGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.natGatewayIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeNatGatewaysRequest.ReadOnly =
    zio.aws.ec2.model.DescribeNatGatewaysRequest.wrap(buildAwsValue())
}
object DescribeNatGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeNatGatewaysRequest =
      zio.aws.ec2.model.DescribeNatGatewaysRequest(
        filter.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        natGatewayIds.map(value => value),
        nextToken.map(value => value)
      )
    def filter: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[DescribeNatGatewaysMaxResults]
    def natGatewayIds: Optional[List[NatGatewayId]]
    def nextToken: Optional[String]
    def getFilter: ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, DescribeNatGatewaysMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNatGatewayIds: ZIO[Any, AwsError, List[NatGatewayId]] =
      AwsError.unwrapOptionField("natGatewayIds", natGatewayIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest
  ) extends zio.aws.ec2.model.DescribeNatGatewaysRequest.ReadOnly {
    override val filter: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[DescribeNatGatewaysMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.DescribeNatGatewaysMaxResults(value)
        )
    override val natGatewayIds: Optional[List[NatGatewayId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.natGatewayIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.NatGatewayId(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest
  ): zio.aws.ec2.model.DescribeNatGatewaysRequest.ReadOnly = new Wrapper(impl)
}
