package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  LocalGatewayMaxResults,
  LocalGatewayRouteTableVirtualInterfaceGroupAssociationId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(
    localGatewayRouteTableVirtualInterfaceGroupAssociationIds: Optional[
      Iterable[LocalGatewayRouteTableVirtualInterfaceGroupAssociationId]
    ] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[LocalGatewayMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest = {
    import DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
      .builder()
      .optionallyWith(
        localGatewayRouteTableVirtualInterfaceGroupAssociationIds.map(value =>
          value.map { item =>
            LocalGatewayRouteTableVirtualInterfaceGroupAssociationId.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.localGatewayRouteTableVirtualInterfaceGroupAssociationIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => LocalGatewayMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest =
      zio.aws.ec2.model
        .DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(
          localGatewayRouteTableVirtualInterfaceGroupAssociationIds.map(value =>
            value
          ),
          filters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          maxResults.map(value => value),
          nextToken.map(value => value)
        )
    def localGatewayRouteTableVirtualInterfaceGroupAssociationIds: Optional[
      List[LocalGatewayRouteTableVirtualInterfaceGroupAssociationId]
    ]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[LocalGatewayMaxResults]
    def nextToken: Optional[String]
    def getLocalGatewayRouteTableVirtualInterfaceGroupAssociationIds
        : ZIO[Any, AwsError, List[
          LocalGatewayRouteTableVirtualInterfaceGroupAssociationId
        ]] = AwsError.unwrapOptionField(
      "localGatewayRouteTableVirtualInterfaceGroupAssociationIds",
      localGatewayRouteTableVirtualInterfaceGroupAssociationIds
    )
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, LocalGatewayMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
  ) extends zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest.ReadOnly {
    override val localGatewayRouteTableVirtualInterfaceGroupAssociationIds
        : Optional[
          List[LocalGatewayRouteTableVirtualInterfaceGroupAssociationId]
        ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.localGatewayRouteTableVirtualInterfaceGroupAssociationIds()
      )
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives
            .LocalGatewayRouteTableVirtualInterfaceGroupAssociationId(item)
        }.toList
      )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[LocalGatewayMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.LocalGatewayMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
  ): zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
