package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{CoipPoolMaxResults, Ipv4PoolCoipId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeCoipPoolsRequest(
    poolIds: Optional[Iterable[Ipv4PoolCoipId]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[CoipPoolMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest = {
    import DescribeCoipPoolsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest
      .builder()
      .optionallyWith(
        poolIds.map(value =>
          value.map { item =>
            Ipv4PoolCoipId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.poolIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => CoipPoolMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeCoipPoolsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeCoipPoolsRequest.wrap(buildAwsValue())
}
object DescribeCoipPoolsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCoipPoolsRequest =
      zio.aws.ec2.model.DescribeCoipPoolsRequest(
        poolIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def poolIds: Optional[List[Ipv4PoolCoipId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[CoipPoolMaxResults]
    def nextToken: Optional[String]
    def getPoolIds: ZIO[Any, AwsError, List[Ipv4PoolCoipId]] =
      AwsError.unwrapOptionField("poolIds", poolIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, CoipPoolMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest
  ) extends zio.aws.ec2.model.DescribeCoipPoolsRequest.ReadOnly {
    override val poolIds: Optional[List[Ipv4PoolCoipId]] = zio.aws.core.internal
      .optionalFromNullable(impl.poolIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.Ipv4PoolCoipId(item)
        }.toList
      )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[CoipPoolMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.ec2.model.primitives.CoipPoolMaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest
  ): zio.aws.ec2.model.DescribeCoipPoolsRequest.ReadOnly = new Wrapper(impl)
}
