package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAvailabilityZonesRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    zoneNames: Optional[Iterable[String]] = Optional.Absent,
    zoneIds: Optional[Iterable[String]] = Optional.Absent,
    allAvailabilityZones: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest = {
    import DescribeAvailabilityZonesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        zoneNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.zoneNames)
      .optionallyWith(
        zoneIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.zoneIds)
      .optionallyWith(
        allAvailabilityZones.map(value => value: java.lang.Boolean)
      )(_.allAvailabilityZones)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeAvailabilityZonesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeAvailabilityZonesRequest.wrap(buildAwsValue())
}
object DescribeAvailabilityZonesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAvailabilityZonesRequest =
      zio.aws.ec2.model.DescribeAvailabilityZonesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        zoneNames.map(value => value),
        zoneIds.map(value => value),
        allAvailabilityZones.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def zoneNames: Optional[List[String]]
    def zoneIds: Optional[List[String]]
    def allAvailabilityZones: Optional[Boolean]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getZoneNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("zoneNames", zoneNames)
    def getZoneIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("zoneIds", zoneIds)
    def getAllAvailabilityZones: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allAvailabilityZones", allAvailabilityZones)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest
  ) extends zio.aws.ec2.model.DescribeAvailabilityZonesRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val zoneNames: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.zoneNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val zoneIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.zoneIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val allAvailabilityZones: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allAvailabilityZones())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest
  ): zio.aws.ec2.model.DescribeAvailabilityZonesRequest.ReadOnly = new Wrapper(
    impl
  )
}
