package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteQueuedReservedInstancesError(
    code: Optional[zio.aws.ec2.model.DeleteQueuedReservedInstancesErrorCode] =
      Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesError = {
    import DeleteQueuedReservedInstancesError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesError
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteQueuedReservedInstancesError.ReadOnly =
    zio.aws.ec2.model.DeleteQueuedReservedInstancesError.wrap(buildAwsValue())
}
object DeleteQueuedReservedInstancesError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteQueuedReservedInstancesError =
      zio.aws.ec2.model.DeleteQueuedReservedInstancesError(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[zio.aws.ec2.model.DeleteQueuedReservedInstancesErrorCode]
    def message: Optional[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DeleteQueuedReservedInstancesErrorCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesError
  ) extends zio.aws.ec2.model.DeleteQueuedReservedInstancesError.ReadOnly {
    override val code
        : Optional[zio.aws.ec2.model.DeleteQueuedReservedInstancesErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value =>
          zio.aws.ec2.model.DeleteQueuedReservedInstancesErrorCode.wrap(value)
        )
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesError
  ): zio.aws.ec2.model.DeleteQueuedReservedInstancesError.ReadOnly =
    new Wrapper(impl)
}
