package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AutoAcceptSharedAssociationsValue {
  def unwrap: software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAssociationsValue
}
object AutoAcceptSharedAssociationsValue {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAssociationsValue
  ): zio.aws.ec2.model.AutoAcceptSharedAssociationsValue = value match {
    case software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAssociationsValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAssociationsValue.ENABLE =>
      val r = enable
      r
    case software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAssociationsValue.DISABLE =>
      val r = disable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.AutoAcceptSharedAssociationsValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAssociationsValue =
      software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAssociationsValue.UNKNOWN_TO_SDK_VERSION
  }
  case object enable
      extends zio.aws.ec2.model.AutoAcceptSharedAssociationsValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAssociationsValue =
      software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAssociationsValue.ENABLE
  }
  case object disable
      extends zio.aws.ec2.model.AutoAcceptSharedAssociationsValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAssociationsValue =
      software.amazon.awssdk.services.ec2.model.AutoAcceptSharedAssociationsValue.DISABLE
  }
}
