package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AllowedPrincipal(
    principalType: Optional[zio.aws.ec2.model.PrincipalType] = Optional.Absent,
    principal: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AllowedPrincipal = {
    import AllowedPrincipal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AllowedPrincipal
      .builder()
      .optionallyWith(principalType.map(value => value.unwrap))(_.principalType)
      .optionallyWith(principal.map(value => value: java.lang.String))(
        _.principal
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AllowedPrincipal.ReadOnly =
    zio.aws.ec2.model.AllowedPrincipal.wrap(buildAwsValue())
}
object AllowedPrincipal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AllowedPrincipal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AllowedPrincipal =
      zio.aws.ec2.model.AllowedPrincipal(
        principalType.map(value => value),
        principal.map(value => value)
      )
    def principalType: Optional[zio.aws.ec2.model.PrincipalType]
    def principal: Optional[String]
    def getPrincipalType: ZIO[Any, AwsError, zio.aws.ec2.model.PrincipalType] =
      AwsError.unwrapOptionField("principalType", principalType)
    def getPrincipal: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principal", principal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AllowedPrincipal
  ) extends zio.aws.ec2.model.AllowedPrincipal.ReadOnly {
    override val principalType: Optional[zio.aws.ec2.model.PrincipalType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principalType())
        .map(value => zio.aws.ec2.model.PrincipalType.wrap(value))
    override val principal: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principal())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AllowedPrincipal
  ): zio.aws.ec2.model.AllowedPrincipal.ReadOnly = new Wrapper(impl)
}
