package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VpcTenancy {
  def unwrap: software.amazon.awssdk.services.ec2.model.VpcTenancy
}
object VpcTenancy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VpcTenancy
  ): zio.aws.ec2.model.VpcTenancy = value match {
    case software.amazon.awssdk.services.ec2.model.VpcTenancy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VpcTenancy.DEFAULT =>
      val r = default
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.VpcTenancy {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VpcTenancy =
      software.amazon.awssdk.services.ec2.model.VpcTenancy.UNKNOWN_TO_SDK_VERSION
  }
  case object default extends zio.aws.ec2.model.VpcTenancy {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VpcTenancy =
      software.amazon.awssdk.services.ec2.model.VpcTenancy.DEFAULT
  }
}
