package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{DateTime, Integer}
import scala.jdk.CollectionConverters._
final case class VgwTelemetry(
    acceptedRouteCount: Optional[Integer] = Optional.Absent,
    lastStatusChange: Optional[DateTime] = Optional.Absent,
    outsideIpAddress: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.TelemetryStatus] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    certificateArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VgwTelemetry = {
    import VgwTelemetry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VgwTelemetry
      .builder()
      .optionallyWith(
        acceptedRouteCount.map(value => value: java.lang.Integer)
      )(_.acceptedRouteCount)
      .optionallyWith(
        lastStatusChange.map(value => DateTime.unwrap(value): Instant)
      )(_.lastStatusChange)
      .optionallyWith(outsideIpAddress.map(value => value: java.lang.String))(
        _.outsideIpAddress
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VgwTelemetry.ReadOnly =
    zio.aws.ec2.model.VgwTelemetry.wrap(buildAwsValue())
}
object VgwTelemetry {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.VgwTelemetry] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VgwTelemetry =
      zio.aws.ec2.model.VgwTelemetry(
        acceptedRouteCount.map(value => value),
        lastStatusChange.map(value => value),
        outsideIpAddress.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        certificateArn.map(value => value)
      )
    def acceptedRouteCount: Optional[Integer]
    def lastStatusChange: Optional[DateTime]
    def outsideIpAddress: Optional[String]
    def status: Optional[zio.aws.ec2.model.TelemetryStatus]
    def statusMessage: Optional[String]
    def certificateArn: Optional[String]
    def getAcceptedRouteCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("acceptedRouteCount", acceptedRouteCount)
    def getLastStatusChange: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastStatusChange", lastStatusChange)
    def getOutsideIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outsideIpAddress", outsideIpAddress)
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.TelemetryStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VgwTelemetry
  ) extends zio.aws.ec2.model.VgwTelemetry.ReadOnly {
    override val acceptedRouteCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptedRouteCount())
      .map(value => value: Integer)
    override val lastStatusChange: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStatusChange())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val outsideIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outsideIpAddress())
      .map(value => value: String)
    override val status: Optional[zio.aws.ec2.model.TelemetryStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.TelemetryStatus.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val certificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VgwTelemetry
  ): zio.aws.ec2.model.VgwTelemetry.ReadOnly = new Wrapper(impl)
}
