package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class TransitGatewayPeeringAttachment(
    transitGatewayAttachmentId: Optional[String] = Optional.Absent,
    requesterTgwInfo: Optional[zio.aws.ec2.model.PeeringTgwInfo] =
      Optional.Absent,
    accepterTgwInfo: Optional[zio.aws.ec2.model.PeeringTgwInfo] =
      Optional.Absent,
    status: Optional[zio.aws.ec2.model.PeeringAttachmentStatus] =
      Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayAttachmentState] =
      Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachment = {
    import TransitGatewayPeeringAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachment
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value => value: java.lang.String)
      )(_.transitGatewayAttachmentId)
      .optionallyWith(requesterTgwInfo.map(value => value.buildAwsValue()))(
        _.requesterTgwInfo
      )
      .optionallyWith(accepterTgwInfo.map(value => value.buildAwsValue()))(
        _.accepterTgwInfo
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly =
    zio.aws.ec2.model.TransitGatewayPeeringAttachment.wrap(buildAwsValue())
}
object TransitGatewayPeeringAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayPeeringAttachment =
      zio.aws.ec2.model.TransitGatewayPeeringAttachment(
        transitGatewayAttachmentId.map(value => value),
        requesterTgwInfo.map(value => value.asEditable),
        accepterTgwInfo.map(value => value.asEditable),
        status.map(value => value.asEditable),
        state.map(value => value),
        creationTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayAttachmentId: Optional[String]
    def requesterTgwInfo: Optional[zio.aws.ec2.model.PeeringTgwInfo.ReadOnly]
    def accepterTgwInfo: Optional[zio.aws.ec2.model.PeeringTgwInfo.ReadOnly]
    def status: Optional[zio.aws.ec2.model.PeeringAttachmentStatus.ReadOnly]
    def state: Optional[zio.aws.ec2.model.TransitGatewayAttachmentState]
    def creationTime: Optional[DateTime]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getRequesterTgwInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.PeeringTgwInfo.ReadOnly] =
      AwsError.unwrapOptionField("requesterTgwInfo", requesterTgwInfo)
    def getAccepterTgwInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.PeeringTgwInfo.ReadOnly] =
      AwsError.unwrapOptionField("accepterTgwInfo", accepterTgwInfo)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PeeringAttachmentStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayAttachmentState] =
      AwsError.unwrapOptionField("state", state)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachment
  ) extends zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly {
    override val transitGatewayAttachmentId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayAttachmentId())
        .map(value => value: String)
    override val requesterTgwInfo
        : Optional[zio.aws.ec2.model.PeeringTgwInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requesterTgwInfo())
        .map(value => zio.aws.ec2.model.PeeringTgwInfo.wrap(value))
    override val accepterTgwInfo
        : Optional[zio.aws.ec2.model.PeeringTgwInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accepterTgwInfo())
        .map(value => zio.aws.ec2.model.PeeringTgwInfo.wrap(value))
    override val status
        : Optional[zio.aws.ec2.model.PeeringAttachmentStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.PeeringAttachmentStatus.wrap(value))
    override val state
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayAttachmentState.wrap(value)
        )
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachment
  ): zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly = new Wrapper(
    impl
  )
}
