package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TrafficMirrorSessionField {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField
}
object TrafficMirrorSessionField {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField
  ): zio.aws.ec2.model.TrafficMirrorSessionField = value match {
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField.PACKET_LENGTH =>
      val r = `packet-length`
      r
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField.DESCRIPTION =>
      val r = description
      r
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField.VIRTUAL_NETWORK_ID =>
      val r = `virtual-network-id`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TrafficMirrorSessionField {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField.UNKNOWN_TO_SDK_VERSION
  }
  case object `packet-length`
      extends zio.aws.ec2.model.TrafficMirrorSessionField {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField.PACKET_LENGTH
  }
  case object description extends zio.aws.ec2.model.TrafficMirrorSessionField {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField.DESCRIPTION
  }
  case object `virtual-network-id`
      extends zio.aws.ec2.model.TrafficMirrorSessionField {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField.VIRTUAL_NETWORK_ID
  }
}
