package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{InstanceId, DateTime, Integer}
import scala.jdk.CollectionConverters._
final case class SpotInstanceRequest(
    actualBlockHourlyPrice: Optional[String] = Optional.Absent,
    availabilityZoneGroup: Optional[String] = Optional.Absent,
    blockDurationMinutes: Optional[Integer] = Optional.Absent,
    createTime: Optional[DateTime] = Optional.Absent,
    fault: Optional[zio.aws.ec2.model.SpotInstanceStateFault] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    launchGroup: Optional[String] = Optional.Absent,
    launchSpecification: Optional[zio.aws.ec2.model.LaunchSpecification] =
      Optional.Absent,
    launchedAvailabilityZone: Optional[String] = Optional.Absent,
    productDescription: Optional[zio.aws.ec2.model.RIProductDescription] =
      Optional.Absent,
    spotInstanceRequestId: Optional[String] = Optional.Absent,
    spotPrice: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.SpotInstanceState] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.SpotInstanceStatus] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    `type`: Optional[zio.aws.ec2.model.SpotInstanceType] = Optional.Absent,
    validFrom: Optional[DateTime] = Optional.Absent,
    validUntil: Optional[DateTime] = Optional.Absent,
    instanceInterruptionBehavior: Optional[
      zio.aws.ec2.model.InstanceInterruptionBehavior
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotInstanceRequest = {
    import SpotInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotInstanceRequest
      .builder()
      .optionallyWith(
        actualBlockHourlyPrice.map(value => value: java.lang.String)
      )(_.actualBlockHourlyPrice)
      .optionallyWith(
        availabilityZoneGroup.map(value => value: java.lang.String)
      )(_.availabilityZoneGroup)
      .optionallyWith(
        blockDurationMinutes.map(value => value: java.lang.Integer)
      )(_.blockDurationMinutes)
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(fault.map(value => value.buildAwsValue()))(_.fault)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(launchGroup.map(value => value: java.lang.String))(
        _.launchGroup
      )
      .optionallyWith(launchSpecification.map(value => value.buildAwsValue()))(
        _.launchSpecification
      )
      .optionallyWith(
        launchedAvailabilityZone.map(value => value: java.lang.String)
      )(_.launchedAvailabilityZone)
      .optionallyWith(productDescription.map(value => value.unwrap))(
        _.productDescription
      )
      .optionallyWith(
        spotInstanceRequestId.map(value => value: java.lang.String)
      )(_.spotInstanceRequestId)
      .optionallyWith(spotPrice.map(value => value: java.lang.String))(
        _.spotPrice
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(validFrom.map(value => DateTime.unwrap(value): Instant))(
        _.validFrom
      )
      .optionallyWith(validUntil.map(value => DateTime.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(instanceInterruptionBehavior.map(value => value.unwrap))(
        _.instanceInterruptionBehavior
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotInstanceRequest.ReadOnly =
    zio.aws.ec2.model.SpotInstanceRequest.wrap(buildAwsValue())
}
object SpotInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotInstanceRequest =
      zio.aws.ec2.model.SpotInstanceRequest(
        actualBlockHourlyPrice.map(value => value),
        availabilityZoneGroup.map(value => value),
        blockDurationMinutes.map(value => value),
        createTime.map(value => value),
        fault.map(value => value.asEditable),
        instanceId.map(value => value),
        launchGroup.map(value => value),
        launchSpecification.map(value => value.asEditable),
        launchedAvailabilityZone.map(value => value),
        productDescription.map(value => value),
        spotInstanceRequestId.map(value => value),
        spotPrice.map(value => value),
        state.map(value => value),
        status.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`.map(value => value),
        validFrom.map(value => value),
        validUntil.map(value => value),
        instanceInterruptionBehavior.map(value => value)
      )
    def actualBlockHourlyPrice: Optional[String]
    def availabilityZoneGroup: Optional[String]
    def blockDurationMinutes: Optional[Integer]
    def createTime: Optional[DateTime]
    def fault: Optional[zio.aws.ec2.model.SpotInstanceStateFault.ReadOnly]
    def instanceId: Optional[InstanceId]
    def launchGroup: Optional[String]
    def launchSpecification
        : Optional[zio.aws.ec2.model.LaunchSpecification.ReadOnly]
    def launchedAvailabilityZone: Optional[String]
    def productDescription: Optional[zio.aws.ec2.model.RIProductDescription]
    def spotInstanceRequestId: Optional[String]
    def spotPrice: Optional[String]
    def state: Optional[zio.aws.ec2.model.SpotInstanceState]
    def status: Optional[zio.aws.ec2.model.SpotInstanceStatus.ReadOnly]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def `type`: Optional[zio.aws.ec2.model.SpotInstanceType]
    def validFrom: Optional[DateTime]
    def validUntil: Optional[DateTime]
    def instanceInterruptionBehavior
        : Optional[zio.aws.ec2.model.InstanceInterruptionBehavior]
    def getActualBlockHourlyPrice: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("actualBlockHourlyPrice", actualBlockHourlyPrice)
    def getAvailabilityZoneGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneGroup", availabilityZoneGroup)
    def getBlockDurationMinutes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("blockDurationMinutes", blockDurationMinutes)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getFault: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SpotInstanceStateFault.ReadOnly
    ] = AwsError.unwrapOptionField("fault", fault)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getLaunchGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchGroup", launchGroup)
    def getLaunchSpecification
        : ZIO[Any, AwsError, zio.aws.ec2.model.LaunchSpecification.ReadOnly] =
      AwsError.unwrapOptionField("launchSpecification", launchSpecification)
    def getLaunchedAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("launchedAvailabilityZone", launchedAvailabilityZone)
    def getProductDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.RIProductDescription] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getSpotInstanceRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotInstanceRequestId", spotInstanceRequestId)
    def getSpotPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotPrice", spotPrice)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.SpotInstanceState] =
      AwsError.unwrapOptionField("state", state)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotInstanceStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.SpotInstanceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValidFrom: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validFrom", validFrom)
    def getValidUntil: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getInstanceInterruptionBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceInterruptionBehavior] =
      AwsError.unwrapOptionField(
        "instanceInterruptionBehavior",
        instanceInterruptionBehavior
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotInstanceRequest
  ) extends zio.aws.ec2.model.SpotInstanceRequest.ReadOnly {
    override val actualBlockHourlyPrice: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actualBlockHourlyPrice())
        .map(value => value: String)
    override val availabilityZoneGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZoneGroup())
      .map(value => value: String)
    override val blockDurationMinutes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.blockDurationMinutes())
      .map(value => value: Integer)
    override val createTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val fault
        : Optional[zio.aws.ec2.model.SpotInstanceStateFault.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fault())
        .map(value => zio.aws.ec2.model.SpotInstanceStateFault.wrap(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ec2.model.primitives.InstanceId(value))
    override val launchGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchGroup())
      .map(value => value: String)
    override val launchSpecification
        : Optional[zio.aws.ec2.model.LaunchSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchSpecification())
        .map(value => zio.aws.ec2.model.LaunchSpecification.wrap(value))
    override val launchedAvailabilityZone: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchedAvailabilityZone())
        .map(value => value: String)
    override val productDescription
        : Optional[zio.aws.ec2.model.RIProductDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productDescription())
        .map(value => zio.aws.ec2.model.RIProductDescription.wrap(value))
    override val spotInstanceRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotInstanceRequestId())
      .map(value => value: String)
    override val spotPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotPrice())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.SpotInstanceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.SpotInstanceState.wrap(value))
    override val status
        : Optional[zio.aws.ec2.model.SpotInstanceStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.SpotInstanceStatus.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val `type`: Optional[zio.aws.ec2.model.SpotInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ec2.model.SpotInstanceType.wrap(value))
    override val validFrom: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.validFrom())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val validUntil: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.validUntil())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val instanceInterruptionBehavior
        : Optional[zio.aws.ec2.model.InstanceInterruptionBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceInterruptionBehavior())
        .map(value =>
          zio.aws.ec2.model.InstanceInterruptionBehavior.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotInstanceRequest
  ): zio.aws.ec2.model.SpotInstanceRequest.ReadOnly = new Wrapper(impl)
}
