package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{Integer, DateTime}
import scala.jdk.CollectionConverters._
final case class ScheduledInstance(
    availabilityZone: Optional[String] = Optional.Absent,
    createDate: Optional[DateTime] = Optional.Absent,
    hourlyPrice: Optional[String] = Optional.Absent,
    instanceCount: Optional[Integer] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    networkPlatform: Optional[String] = Optional.Absent,
    nextSlotStartTime: Optional[DateTime] = Optional.Absent,
    platform: Optional[String] = Optional.Absent,
    previousSlotEndTime: Optional[DateTime] = Optional.Absent,
    recurrence: Optional[zio.aws.ec2.model.ScheduledInstanceRecurrence] =
      Optional.Absent,
    scheduledInstanceId: Optional[String] = Optional.Absent,
    slotDurationInHours: Optional[Integer] = Optional.Absent,
    termEndDate: Optional[DateTime] = Optional.Absent,
    termStartDate: Optional[DateTime] = Optional.Absent,
    totalScheduledInstanceHours: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstance = {
    import ScheduledInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstance
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(createDate.map(value => DateTime.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(hourlyPrice.map(value => value: java.lang.String))(
        _.hourlyPrice
      )
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(networkPlatform.map(value => value: java.lang.String))(
        _.networkPlatform
      )
      .optionallyWith(
        nextSlotStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.nextSlotStartTime)
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(
        previousSlotEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.previousSlotEndTime)
      .optionallyWith(recurrence.map(value => value.buildAwsValue()))(
        _.recurrence
      )
      .optionallyWith(
        scheduledInstanceId.map(value => value: java.lang.String)
      )(_.scheduledInstanceId)
      .optionallyWith(
        slotDurationInHours.map(value => value: java.lang.Integer)
      )(_.slotDurationInHours)
      .optionallyWith(
        termEndDate.map(value => DateTime.unwrap(value): Instant)
      )(_.termEndDate)
      .optionallyWith(
        termStartDate.map(value => DateTime.unwrap(value): Instant)
      )(_.termStartDate)
      .optionallyWith(
        totalScheduledInstanceHours.map(value => value: java.lang.Integer)
      )(_.totalScheduledInstanceHours)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ScheduledInstance.ReadOnly =
    zio.aws.ec2.model.ScheduledInstance.wrap(buildAwsValue())
}
object ScheduledInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstance =
      zio.aws.ec2.model.ScheduledInstance(
        availabilityZone.map(value => value),
        createDate.map(value => value),
        hourlyPrice.map(value => value),
        instanceCount.map(value => value),
        instanceType.map(value => value),
        networkPlatform.map(value => value),
        nextSlotStartTime.map(value => value),
        platform.map(value => value),
        previousSlotEndTime.map(value => value),
        recurrence.map(value => value.asEditable),
        scheduledInstanceId.map(value => value),
        slotDurationInHours.map(value => value),
        termEndDate.map(value => value),
        termStartDate.map(value => value),
        totalScheduledInstanceHours.map(value => value)
      )
    def availabilityZone: Optional[String]
    def createDate: Optional[DateTime]
    def hourlyPrice: Optional[String]
    def instanceCount: Optional[Integer]
    def instanceType: Optional[String]
    def networkPlatform: Optional[String]
    def nextSlotStartTime: Optional[DateTime]
    def platform: Optional[String]
    def previousSlotEndTime: Optional[DateTime]
    def recurrence
        : Optional[zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly]
    def scheduledInstanceId: Optional[String]
    def slotDurationInHours: Optional[Integer]
    def termEndDate: Optional[DateTime]
    def termStartDate: Optional[DateTime]
    def totalScheduledInstanceHours: Optional[Integer]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getCreateDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getHourlyPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hourlyPrice", hourlyPrice)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getNetworkPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkPlatform", networkPlatform)
    def getNextSlotStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("nextSlotStartTime", nextSlotStartTime)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getPreviousSlotEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("previousSlotEndTime", previousSlotEndTime)
    def getRecurrence: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly
    ] = AwsError.unwrapOptionField("recurrence", recurrence)
    def getScheduledInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduledInstanceId", scheduledInstanceId)
    def getSlotDurationInHours: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("slotDurationInHours", slotDurationInHours)
    def getTermEndDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("termEndDate", termEndDate)
    def getTermStartDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("termStartDate", termStartDate)
    def getTotalScheduledInstanceHours: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "totalScheduledInstanceHours",
        totalScheduledInstanceHours
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstance
  ) extends zio.aws.ec2.model.ScheduledInstance.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val createDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val hourlyPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hourlyPrice())
      .map(value => value: String)
    override val instanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: Integer)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val networkPlatform: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkPlatform())
      .map(value => value: String)
    override val nextSlotStartTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.nextSlotStartTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val platform: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => value: String)
    override val previousSlotEndTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.previousSlotEndTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val recurrence
        : Optional[zio.aws.ec2.model.ScheduledInstanceRecurrence.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurrence())
        .map(value => zio.aws.ec2.model.ScheduledInstanceRecurrence.wrap(value))
    override val scheduledInstanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledInstanceId())
      .map(value => value: String)
    override val slotDurationInHours: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.slotDurationInHours())
      .map(value => value: Integer)
    override val termEndDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.termEndDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val termStartDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.termStartDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val totalScheduledInstanceHours: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalScheduledInstanceHours())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstance
  ): zio.aws.ec2.model.ScheduledInstance.ReadOnly = new Wrapper(impl)
}
