package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{CoreNetworkArn, CarrierGatewayId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Route(
    destinationCidrBlock: Optional[String] = Optional.Absent,
    destinationIpv6CidrBlock: Optional[String] = Optional.Absent,
    destinationPrefixListId: Optional[String] = Optional.Absent,
    egressOnlyInternetGatewayId: Optional[String] = Optional.Absent,
    gatewayId: Optional[String] = Optional.Absent,
    instanceId: Optional[String] = Optional.Absent,
    instanceOwnerId: Optional[String] = Optional.Absent,
    natGatewayId: Optional[String] = Optional.Absent,
    transitGatewayId: Optional[String] = Optional.Absent,
    localGatewayId: Optional[String] = Optional.Absent,
    carrierGatewayId: Optional[CarrierGatewayId] = Optional.Absent,
    networkInterfaceId: Optional[String] = Optional.Absent,
    origin: Optional[zio.aws.ec2.model.RouteOrigin] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.RouteState] = Optional.Absent,
    vpcPeeringConnectionId: Optional[String] = Optional.Absent,
    coreNetworkArn: Optional[CoreNetworkArn] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Route = {
    import Route.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Route
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(
        destinationIpv6CidrBlock.map(value => value: java.lang.String)
      )(_.destinationIpv6CidrBlock)
      .optionallyWith(
        destinationPrefixListId.map(value => value: java.lang.String)
      )(_.destinationPrefixListId)
      .optionallyWith(
        egressOnlyInternetGatewayId.map(value => value: java.lang.String)
      )(_.egressOnlyInternetGatewayId)
      .optionallyWith(gatewayId.map(value => value: java.lang.String))(
        _.gatewayId
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(instanceOwnerId.map(value => value: java.lang.String))(
        _.instanceOwnerId
      )
      .optionallyWith(natGatewayId.map(value => value: java.lang.String))(
        _.natGatewayId
      )
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(localGatewayId.map(value => value: java.lang.String))(
        _.localGatewayId
      )
      .optionallyWith(
        carrierGatewayId.map(value =>
          CarrierGatewayId.unwrap(value): java.lang.String
        )
      )(_.carrierGatewayId)
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(origin.map(value => value.unwrap))(_.origin)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        vpcPeeringConnectionId.map(value => value: java.lang.String)
      )(_.vpcPeeringConnectionId)
      .optionallyWith(
        coreNetworkArn.map(value =>
          CoreNetworkArn.unwrap(value): java.lang.String
        )
      )(_.coreNetworkArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Route.ReadOnly =
    zio.aws.ec2.model.Route.wrap(buildAwsValue())
}
object Route {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Route] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Route = zio.aws.ec2.model.Route(
      destinationCidrBlock.map(value => value),
      destinationIpv6CidrBlock.map(value => value),
      destinationPrefixListId.map(value => value),
      egressOnlyInternetGatewayId.map(value => value),
      gatewayId.map(value => value),
      instanceId.map(value => value),
      instanceOwnerId.map(value => value),
      natGatewayId.map(value => value),
      transitGatewayId.map(value => value),
      localGatewayId.map(value => value),
      carrierGatewayId.map(value => value),
      networkInterfaceId.map(value => value),
      origin.map(value => value),
      state.map(value => value),
      vpcPeeringConnectionId.map(value => value),
      coreNetworkArn.map(value => value)
    )
    def destinationCidrBlock: Optional[String]
    def destinationIpv6CidrBlock: Optional[String]
    def destinationPrefixListId: Optional[String]
    def egressOnlyInternetGatewayId: Optional[String]
    def gatewayId: Optional[String]
    def instanceId: Optional[String]
    def instanceOwnerId: Optional[String]
    def natGatewayId: Optional[String]
    def transitGatewayId: Optional[String]
    def localGatewayId: Optional[String]
    def carrierGatewayId: Optional[CarrierGatewayId]
    def networkInterfaceId: Optional[String]
    def origin: Optional[zio.aws.ec2.model.RouteOrigin]
    def state: Optional[zio.aws.ec2.model.RouteState]
    def vpcPeeringConnectionId: Optional[String]
    def coreNetworkArn: Optional[CoreNetworkArn]
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getDestinationIpv6CidrBlock: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("destinationIpv6CidrBlock", destinationIpv6CidrBlock)
    def getDestinationPrefixListId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("destinationPrefixListId", destinationPrefixListId)
    def getEgressOnlyInternetGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "egressOnlyInternetGatewayId",
        egressOnlyInternetGatewayId
      )
    def getGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceOwnerId", instanceOwnerId)
    def getNatGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("natGatewayId", natGatewayId)
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getLocalGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("localGatewayId", localGatewayId)
    def getCarrierGatewayId: ZIO[Any, AwsError, CarrierGatewayId] =
      AwsError.unwrapOptionField("carrierGatewayId", carrierGatewayId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getOrigin: ZIO[Any, AwsError, zio.aws.ec2.model.RouteOrigin] =
      AwsError.unwrapOptionField("origin", origin)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.RouteState] =
      AwsError.unwrapOptionField("state", state)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("vpcPeeringConnectionId", vpcPeeringConnectionId)
    def getCoreNetworkArn: ZIO[Any, AwsError, CoreNetworkArn] =
      AwsError.unwrapOptionField("coreNetworkArn", coreNetworkArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Route
  ) extends zio.aws.ec2.model.Route.ReadOnly {
    override val destinationCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidrBlock())
      .map(value => value: String)
    override val destinationIpv6CidrBlock: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationIpv6CidrBlock())
        .map(value => value: String)
    override val destinationPrefixListId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPrefixListId())
        .map(value => value: String)
    override val egressOnlyInternetGatewayId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.egressOnlyInternetGatewayId())
        .map(value => value: String)
    override val gatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayId())
      .map(value => value: String)
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val instanceOwnerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceOwnerId())
      .map(value => value: String)
    override val natGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.natGatewayId())
      .map(value => value: String)
    override val transitGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayId())
      .map(value => value: String)
    override val localGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.localGatewayId())
      .map(value => value: String)
    override val carrierGatewayId: Optional[CarrierGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.carrierGatewayId())
        .map(value => zio.aws.ec2.model.primitives.CarrierGatewayId(value))
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
    override val origin: Optional[zio.aws.ec2.model.RouteOrigin] =
      zio.aws.core.internal
        .optionalFromNullable(impl.origin())
        .map(value => zio.aws.ec2.model.RouteOrigin.wrap(value))
    override val state: Optional[zio.aws.ec2.model.RouteState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.RouteState.wrap(value))
    override val vpcPeeringConnectionId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcPeeringConnectionId())
        .map(value => value: String)
    override val coreNetworkArn: Optional[CoreNetworkArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coreNetworkArn())
        .map(value => zio.aws.ec2.model.primitives.CoreNetworkArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Route
  ): zio.aws.ec2.model.Route.ReadOnly = new Wrapper(impl)
}
