package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class ReservedInstancesModification(
    clientToken: Optional[String] = Optional.Absent,
    createDate: Optional[DateTime] = Optional.Absent,
    effectiveDate: Optional[DateTime] = Optional.Absent,
    modificationResults: Optional[
      Iterable[zio.aws.ec2.model.ReservedInstancesModificationResult]
    ] = Optional.Absent,
    reservedInstancesIds: Optional[
      Iterable[zio.aws.ec2.model.ReservedInstancesId]
    ] = Optional.Absent,
    reservedInstancesModificationId: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    updateDate: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservedInstancesModification = {
    import ReservedInstancesModification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservedInstancesModification
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(createDate.map(value => DateTime.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        effectiveDate.map(value => DateTime.unwrap(value): Instant)
      )(_.effectiveDate)
      .optionallyWith(
        modificationResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modificationResults)
      .optionallyWith(
        reservedInstancesIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedInstancesIds)
      .optionallyWith(
        reservedInstancesModificationId.map(value => value: java.lang.String)
      )(_.reservedInstancesModificationId)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(updateDate.map(value => DateTime.unwrap(value): Instant))(
        _.updateDate
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReservedInstancesModification.ReadOnly =
    zio.aws.ec2.model.ReservedInstancesModification.wrap(buildAwsValue())
}
object ReservedInstancesModification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservedInstancesModification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservedInstancesModification =
      zio.aws.ec2.model.ReservedInstancesModification(
        clientToken.map(value => value),
        createDate.map(value => value),
        effectiveDate.map(value => value),
        modificationResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reservedInstancesIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reservedInstancesModificationId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        updateDate.map(value => value)
      )
    def clientToken: Optional[String]
    def createDate: Optional[DateTime]
    def effectiveDate: Optional[DateTime]
    def modificationResults: Optional[
      List[zio.aws.ec2.model.ReservedInstancesModificationResult.ReadOnly]
    ]
    def reservedInstancesIds
        : Optional[List[zio.aws.ec2.model.ReservedInstancesId.ReadOnly]]
    def reservedInstancesModificationId: Optional[String]
    def status: Optional[String]
    def statusMessage: Optional[String]
    def updateDate: Optional[DateTime]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCreateDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getEffectiveDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("effectiveDate", effectiveDate)
    def getModificationResults: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ReservedInstancesModificationResult.ReadOnly
    ]] = AwsError.unwrapOptionField("modificationResults", modificationResults)
    def getReservedInstancesIds: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ReservedInstancesId.ReadOnly
    ]] =
      AwsError.unwrapOptionField("reservedInstancesIds", reservedInstancesIds)
    def getReservedInstancesModificationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedInstancesModificationId",
        reservedInstancesModificationId
      )
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getUpdateDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("updateDate", updateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesModification
  ) extends zio.aws.ec2.model.ReservedInstancesModification.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val createDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val effectiveDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.effectiveDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val modificationResults: Optional[
      List[zio.aws.ec2.model.ReservedInstancesModificationResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.modificationResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ReservedInstancesModificationResult.wrap(item)
        }.toList
      )
    override val reservedInstancesIds
        : Optional[List[zio.aws.ec2.model.ReservedInstancesId.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedInstancesIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ReservedInstancesId.wrap(item)
          }.toList
        )
    override val reservedInstancesModificationId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedInstancesModificationId())
        .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val updateDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.updateDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesModification
  ): zio.aws.ec2.model.ReservedInstancesModification.ReadOnly = new Wrapper(
    impl
  )
}
