package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait RIProductDescription {
  def unwrap: software.amazon.awssdk.services.ec2.model.RIProductDescription
}
object RIProductDescription {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.RIProductDescription
  ): zio.aws.ec2.model.RIProductDescription = value match {
    case software.amazon.awssdk.services.ec2.model.RIProductDescription.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.RIProductDescription.LINUX_UNIX =>
      val r = `Linux/UNIX`
      r
    case software.amazon.awssdk.services.ec2.model.RIProductDescription.LINUX_UNIX_AMAZON_VPC =>
      val r = `Linux/UNIX (Amazon VPC)`
      r
    case software.amazon.awssdk.services.ec2.model.RIProductDescription.WINDOWS =>
      val r = Windows
      r
    case software.amazon.awssdk.services.ec2.model.RIProductDescription.WINDOWS_AMAZON_VPC =>
      val r = `Windows (Amazon VPC)`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.RIProductDescription {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RIProductDescription =
      software.amazon.awssdk.services.ec2.model.RIProductDescription.UNKNOWN_TO_SDK_VERSION
  }
  case object `Linux/UNIX` extends zio.aws.ec2.model.RIProductDescription {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RIProductDescription =
      software.amazon.awssdk.services.ec2.model.RIProductDescription.LINUX_UNIX
  }
  case object `Linux/UNIX (Amazon VPC)`
      extends zio.aws.ec2.model.RIProductDescription {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RIProductDescription =
      software.amazon.awssdk.services.ec2.model.RIProductDescription.LINUX_UNIX_AMAZON_VPC
  }
  case object Windows extends zio.aws.ec2.model.RIProductDescription {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RIProductDescription =
      software.amazon.awssdk.services.ec2.model.RIProductDescription.WINDOWS
  }
  case object `Windows (Amazon VPC)`
      extends zio.aws.ec2.model.RIProductDescription {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RIProductDescription =
      software.amazon.awssdk.services.ec2.model.RIProductDescription.WINDOWS_AMAZON_VPC
  }
}
