package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcPeeringConnectionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVpcPeeringConnectionOptionsRequest(
    accepterPeeringConnectionOptions: Optional[
      zio.aws.ec2.model.PeeringConnectionOptionsRequest
    ] = Optional.Absent,
    requesterPeeringConnectionOptions: Optional[
      zio.aws.ec2.model.PeeringConnectionOptionsRequest
    ] = Optional.Absent,
    vpcPeeringConnectionId: VpcPeeringConnectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest = {
    import ModifyVpcPeeringConnectionOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest
      .builder()
      .optionallyWith(
        accepterPeeringConnectionOptions.map(value => value.buildAwsValue())
      )(_.accepterPeeringConnectionOptions)
      .optionallyWith(
        requesterPeeringConnectionOptions.map(value => value.buildAwsValue())
      )(_.requesterPeeringConnectionOptions)
      .vpcPeeringConnectionId(
        VpcPeeringConnectionId.unwrap(vpcPeeringConnectionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsRequest
      .wrap(buildAwsValue())
}
object ModifyVpcPeeringConnectionOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsRequest =
      zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsRequest(
        accepterPeeringConnectionOptions.map(value => value.asEditable),
        requesterPeeringConnectionOptions.map(value => value.asEditable),
        vpcPeeringConnectionId
      )
    def accepterPeeringConnectionOptions
        : Optional[zio.aws.ec2.model.PeeringConnectionOptionsRequest.ReadOnly]
    def requesterPeeringConnectionOptions
        : Optional[zio.aws.ec2.model.PeeringConnectionOptionsRequest.ReadOnly]
    def vpcPeeringConnectionId: VpcPeeringConnectionId
    def getAccepterPeeringConnectionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PeeringConnectionOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accepterPeeringConnectionOptions",
      accepterPeeringConnectionOptions
    )
    def getRequesterPeeringConnectionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PeeringConnectionOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "requesterPeeringConnectionOptions",
      requesterPeeringConnectionOptions
    )
    def getVpcPeeringConnectionId: ZIO[Any, Nothing, VpcPeeringConnectionId] =
      ZIO.succeed(vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest
  ) extends zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsRequest.ReadOnly {
    override val accepterPeeringConnectionOptions
        : Optional[zio.aws.ec2.model.PeeringConnectionOptionsRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accepterPeeringConnectionOptions())
        .map(value =>
          zio.aws.ec2.model.PeeringConnectionOptionsRequest.wrap(value)
        )
    override val requesterPeeringConnectionOptions
        : Optional[zio.aws.ec2.model.PeeringConnectionOptionsRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requesterPeeringConnectionOptions())
        .map(value =>
          zio.aws.ec2.model.PeeringConnectionOptionsRequest.wrap(value)
        )
    override val vpcPeeringConnectionId: VpcPeeringConnectionId =
      zio.aws.ec2.model.primitives
        .VpcPeeringConnectionId(impl.vpcPeeringConnectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest
  ): zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
