package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  ResourceArn,
  LocalGatewayRoutetableId,
  LocalGatewayVirtualInterfaceGroupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LocalGatewayRoute(
    destinationCidrBlock: Optional[String] = Optional.Absent,
    localGatewayVirtualInterfaceGroupId: Optional[
      LocalGatewayVirtualInterfaceGroupId
    ] = Optional.Absent,
    `type`: Optional[zio.aws.ec2.model.LocalGatewayRouteType] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.LocalGatewayRouteState] = Optional.Absent,
    localGatewayRouteTableId: Optional[LocalGatewayRoutetableId] =
      Optional.Absent,
    localGatewayRouteTableArn: Optional[ResourceArn] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LocalGatewayRoute = {
    import LocalGatewayRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LocalGatewayRoute
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(
        localGatewayVirtualInterfaceGroupId.map(value =>
          LocalGatewayVirtualInterfaceGroupId.unwrap(value): java.lang.String
        )
      )(_.localGatewayVirtualInterfaceGroupId)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        localGatewayRouteTableId.map(value =>
          LocalGatewayRoutetableId.unwrap(value): java.lang.String
        )
      )(_.localGatewayRouteTableId)
      .optionallyWith(
        localGatewayRouteTableArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.localGatewayRouteTableArn)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LocalGatewayRoute.ReadOnly =
    zio.aws.ec2.model.LocalGatewayRoute.wrap(buildAwsValue())
}
object LocalGatewayRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LocalGatewayRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LocalGatewayRoute =
      zio.aws.ec2.model.LocalGatewayRoute(
        destinationCidrBlock.map(value => value),
        localGatewayVirtualInterfaceGroupId.map(value => value),
        `type`.map(value => value),
        state.map(value => value),
        localGatewayRouteTableId.map(value => value),
        localGatewayRouteTableArn.map(value => value),
        ownerId.map(value => value)
      )
    def destinationCidrBlock: Optional[String]
    def localGatewayVirtualInterfaceGroupId
        : Optional[LocalGatewayVirtualInterfaceGroupId]
    def `type`: Optional[zio.aws.ec2.model.LocalGatewayRouteType]
    def state: Optional[zio.aws.ec2.model.LocalGatewayRouteState]
    def localGatewayRouteTableId: Optional[LocalGatewayRoutetableId]
    def localGatewayRouteTableArn: Optional[ResourceArn]
    def ownerId: Optional[String]
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getLocalGatewayVirtualInterfaceGroupId
        : ZIO[Any, AwsError, LocalGatewayVirtualInterfaceGroupId] =
      AwsError.unwrapOptionField(
        "localGatewayVirtualInterfaceGroupId",
        localGatewayVirtualInterfaceGroupId
      )
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.LocalGatewayRouteType] =
      AwsError.unwrapOptionField("type", `type`)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.LocalGatewayRouteState] =
      AwsError.unwrapOptionField("state", state)
    def getLocalGatewayRouteTableId
        : ZIO[Any, AwsError, LocalGatewayRoutetableId] = AwsError
      .unwrapOptionField("localGatewayRouteTableId", localGatewayRouteTableId)
    def getLocalGatewayRouteTableArn: ZIO[Any, AwsError, ResourceArn] = AwsError
      .unwrapOptionField("localGatewayRouteTableArn", localGatewayRouteTableArn)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayRoute
  ) extends zio.aws.ec2.model.LocalGatewayRoute.ReadOnly {
    override val destinationCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidrBlock())
      .map(value => value: String)
    override val localGatewayVirtualInterfaceGroupId
        : Optional[LocalGatewayVirtualInterfaceGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.localGatewayVirtualInterfaceGroupId())
      .map(value =>
        zio.aws.ec2.model.primitives.LocalGatewayVirtualInterfaceGroupId(value)
      )
    override val `type`: Optional[zio.aws.ec2.model.LocalGatewayRouteType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ec2.model.LocalGatewayRouteType.wrap(value))
    override val state: Optional[zio.aws.ec2.model.LocalGatewayRouteState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.LocalGatewayRouteState.wrap(value))
    override val localGatewayRouteTableId: Optional[LocalGatewayRoutetableId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayRouteTableId())
        .map(value =>
          zio.aws.ec2.model.primitives.LocalGatewayRoutetableId(value)
        )
    override val localGatewayRouteTableArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayRouteTableArn())
        .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayRoute
  ): zio.aws.ec2.model.LocalGatewayRoute.ReadOnly = new Wrapper(impl)
}
