package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Ipv4PrefixSpecification(
    ipv4Prefix: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecification = {
    import Ipv4PrefixSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecification
      .builder()
      .optionallyWith(ipv4Prefix.map(value => value: java.lang.String))(
        _.ipv4Prefix
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Ipv4PrefixSpecification.ReadOnly =
    zio.aws.ec2.model.Ipv4PrefixSpecification.wrap(buildAwsValue())
}
object Ipv4PrefixSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Ipv4PrefixSpecification =
      zio.aws.ec2.model.Ipv4PrefixSpecification(ipv4Prefix.map(value => value))
    def ipv4Prefix: Optional[String]
    def getIpv4Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv4Prefix", ipv4Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecification
  ) extends zio.aws.ec2.model.Ipv4PrefixSpecification.ReadOnly {
    override val ipv4Prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv4Prefix())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecification
  ): zio.aws.ec2.model.Ipv4PrefixSpecification.ReadOnly = new Wrapper(impl)
}
