package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FailedQueuedPurchaseDeletion(
    error: Optional[zio.aws.ec2.model.DeleteQueuedReservedInstancesError] =
      Optional.Absent,
    reservedInstancesId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FailedQueuedPurchaseDeletion = {
    import FailedQueuedPurchaseDeletion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FailedQueuedPurchaseDeletion
      .builder()
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(
        reservedInstancesId.map(value => value: java.lang.String)
      )(_.reservedInstancesId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FailedQueuedPurchaseDeletion.ReadOnly =
    zio.aws.ec2.model.FailedQueuedPurchaseDeletion.wrap(buildAwsValue())
}
object FailedQueuedPurchaseDeletion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FailedQueuedPurchaseDeletion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FailedQueuedPurchaseDeletion =
      zio.aws.ec2.model.FailedQueuedPurchaseDeletion(
        error.map(value => value.asEditable),
        reservedInstancesId.map(value => value)
      )
    def error: Optional[
      zio.aws.ec2.model.DeleteQueuedReservedInstancesError.ReadOnly
    ]
    def reservedInstancesId: Optional[String]
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DeleteQueuedReservedInstancesError.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
    def getReservedInstancesId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedInstancesId", reservedInstancesId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FailedQueuedPurchaseDeletion
  ) extends zio.aws.ec2.model.FailedQueuedPurchaseDeletion.ReadOnly {
    override val error: Optional[
      zio.aws.ec2.model.DeleteQueuedReservedInstancesError.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value =>
        zio.aws.ec2.model.DeleteQueuedReservedInstancesError.wrap(value)
      )
    override val reservedInstancesId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedInstancesId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FailedQueuedPurchaseDeletion
  ): zio.aws.ec2.model.FailedQueuedPurchaseDeletion.ReadOnly = new Wrapper(impl)
}
