package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DiskImageDescription(
    checksum: Optional[String] = Optional.Absent,
    format: Optional[zio.aws.ec2.model.DiskImageFormat] = Optional.Absent,
    importManifestUrl: Optional[String] = Optional.Absent,
    size: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DiskImageDescription = {
    import DiskImageDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DiskImageDescription
      .builder()
      .optionallyWith(checksum.map(value => value: java.lang.String))(
        _.checksum
      )
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(importManifestUrl.map(value => value: java.lang.String))(
        _.importManifestUrl
      )
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DiskImageDescription.ReadOnly =
    zio.aws.ec2.model.DiskImageDescription.wrap(buildAwsValue())
}
object DiskImageDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DiskImageDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DiskImageDescription =
      zio.aws.ec2.model.DiskImageDescription(
        checksum.map(value => value),
        format.map(value => value),
        importManifestUrl.map(value => value),
        size.map(value => value)
      )
    def checksum: Optional[String]
    def format: Optional[zio.aws.ec2.model.DiskImageFormat]
    def importManifestUrl: Optional[String]
    def size: Optional[Long]
    def getChecksum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("checksum", checksum)
    def getFormat: ZIO[Any, AwsError, zio.aws.ec2.model.DiskImageFormat] =
      AwsError.unwrapOptionField("format", format)
    def getImportManifestUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("importManifestUrl", importManifestUrl)
    def getSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DiskImageDescription
  ) extends zio.aws.ec2.model.DiskImageDescription.ReadOnly {
    override val checksum: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.checksum())
      .map(value => value: String)
    override val format: Optional[zio.aws.ec2.model.DiskImageFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.ec2.model.DiskImageFormat.wrap(value))
    override val importManifestUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.importManifestUrl())
      .map(value => value: String)
    override val size: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DiskImageDescription
  ): zio.aws.ec2.model.DiskImageDescription.ReadOnly = new Wrapper(impl)
}
