package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeClientVpnConnectionsResponse(
    connections: Optional[Iterable[zio.aws.ec2.model.ClientVpnConnection]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsResponse = {
    import DescribeClientVpnConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsResponse
      .builder()
      .optionallyWith(
        connections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connections)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeClientVpnConnectionsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeClientVpnConnectionsResponse.wrap(buildAwsValue())
}
object DescribeClientVpnConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeClientVpnConnectionsResponse =
      zio.aws.ec2.model.DescribeClientVpnConnectionsResponse(
        connections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connections
        : Optional[List[zio.aws.ec2.model.ClientVpnConnection.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getConnections: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ClientVpnConnection.ReadOnly
    ]] = AwsError.unwrapOptionField("connections", connections)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsResponse
  ) extends zio.aws.ec2.model.DescribeClientVpnConnectionsResponse.ReadOnly {
    override val connections
        : Optional[List[zio.aws.ec2.model.ClientVpnConnection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ClientVpnConnection.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsResponse
  ): zio.aws.ec2.model.DescribeClientVpnConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
