package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait BundleTaskState {
  def unwrap: software.amazon.awssdk.services.ec2.model.BundleTaskState
}
object BundleTaskState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.BundleTaskState
  ): zio.aws.ec2.model.BundleTaskState = value match {
    case software.amazon.awssdk.services.ec2.model.BundleTaskState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.BundleTaskState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.BundleTaskState.WAITING_FOR_SHUTDOWN =>
      val r = `waiting-for-shutdown`
      r
    case software.amazon.awssdk.services.ec2.model.BundleTaskState.BUNDLING =>
      val r = bundling
      r
    case software.amazon.awssdk.services.ec2.model.BundleTaskState.STORING =>
      val r = storing
      r
    case software.amazon.awssdk.services.ec2.model.BundleTaskState.CANCELLING =>
      val r = cancelling
      r
    case software.amazon.awssdk.services.ec2.model.BundleTaskState.COMPLETE =>
      val r = complete
      r
    case software.amazon.awssdk.services.ec2.model.BundleTaskState.FAILED =>
      val r = failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.BundleTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BundleTaskState =
      software.amazon.awssdk.services.ec2.model.BundleTaskState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.BundleTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BundleTaskState =
      software.amazon.awssdk.services.ec2.model.BundleTaskState.PENDING
  }
  case object `waiting-for-shutdown` extends zio.aws.ec2.model.BundleTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BundleTaskState =
      software.amazon.awssdk.services.ec2.model.BundleTaskState.WAITING_FOR_SHUTDOWN
  }
  case object bundling extends zio.aws.ec2.model.BundleTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BundleTaskState =
      software.amazon.awssdk.services.ec2.model.BundleTaskState.BUNDLING
  }
  case object storing extends zio.aws.ec2.model.BundleTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BundleTaskState =
      software.amazon.awssdk.services.ec2.model.BundleTaskState.STORING
  }
  case object cancelling extends zio.aws.ec2.model.BundleTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BundleTaskState =
      software.amazon.awssdk.services.ec2.model.BundleTaskState.CANCELLING
  }
  case object complete extends zio.aws.ec2.model.BundleTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BundleTaskState =
      software.amazon.awssdk.services.ec2.model.BundleTaskState.COMPLETE
  }
  case object failed extends zio.aws.ec2.model.BundleTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BundleTaskState =
      software.amazon.awssdk.services.ec2.model.BundleTaskState.FAILED
  }
}
