package zio.aws.ec2
import zio.aws.ec2.model.SecurityGroupRule.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.aws.ec2.model.{
  DeleteNetworkInsightsPathRequest,
  RejectTransitGatewayMulticastDomainAssociationsRequest,
  ReleaseAddressRequest,
  CreateNetworkInterfacePermissionRequest,
  ListSnapshotsInRecycleBinRequest,
  ModifyVpcTenancyRequest,
  ApplySecurityGroupsToClientVpnTargetNetworkRequest,
  PurchaseHostReservationRequest,
  DisableIpamOrganizationAdminAccountRequest,
  ModifyVpcAttributeRequest,
  ModifyVpcEndpointServicePermissionsRequest,
  DescribeTrafficMirrorFiltersRequest,
  ImportClientVpnClientCertificateRevocationListRequest,
  DescribeTrafficMirrorSessionsRequest,
  DescribeFastLaunchImagesRequest,
  AttachNetworkInterfaceRequest,
  DescribeVpcEndpointsRequest,
  DeleteTransitGatewayPrefixListReferenceRequest,
  DescribeExportTasksRequest,
  CancelCapacityReservationFleetsRequest,
  DetachVpnGatewayRequest,
  CreateVpcEndpointConnectionNotificationRequest,
  DescribeLaunchTemplatesRequest,
  GetPasswordDataRequest,
  DescribeSubnetsRequest,
  DeregisterImageRequest,
  ResetNetworkInterfaceAttributeRequest,
  CreateVpnGatewayRequest,
  DeleteTrafficMirrorFilterRequest,
  CreateTransitGatewayConnectRequest,
  ModifyFleetRequest,
  SearchLocalGatewayRoutesRequest,
  EnableImageDeprecationRequest,
  DescribeLocalGatewayRouteTableVpcAssociationsRequest,
  CreateIpamPoolRequest,
  ReleaseHostsRequest,
  DescribeIpamsRequest,
  DescribeKeyPairsRequest,
  DescribeMovingAddressesRequest,
  DeleteRouteRequest,
  CancelSpotInstanceRequestsRequest,
  DescribeHostReservationOfferingsRequest,
  DeleteSpotDatafeedSubscriptionRequest,
  EnableIpamOrganizationAdminAccountRequest,
  ExportClientVpnClientCertificateRevocationListRequest,
  DeleteNetworkInsightsAnalysisRequest,
  DeleteTransitGatewayVpcAttachmentRequest,
  DescribeTrunkInterfaceAssociationsRequest,
  ExportClientVpnClientConfigurationRequest,
  DeleteVpcEndpointsRequest,
  DeleteFlowLogsRequest,
  AssociateVpcCidrBlockRequest,
  ModifyTrafficMirrorSessionRequest,
  DescribeIpamPoolsRequest,
  DisableImageDeprecationRequest,
  CancelImportTaskRequest,
  DescribeIdFormatRequest,
  RevokeClientVpnIngressRequest,
  DeleteNatGatewayRequest,
  AttachClassicLinkVpcRequest,
  DescribeNetworkInsightsPathsRequest,
  ReplaceNetworkAclEntryRequest,
  DeleteInternetGatewayRequest,
  DescribePrefixListsRequest,
  RunScheduledInstancesRequest,
  AssociateTrunkInterfaceRequest,
  DescribeAvailabilityZonesRequest,
  AcceptVpcPeeringConnectionRequest,
  AssociateTransitGatewayRouteTableRequest,
  AllocateAddressRequest,
  CopyImageRequest,
  DeleteSecurityGroupRequest,
  ResetSnapshotAttributeRequest,
  RestoreAddressToClassicRequest,
  DescribeVpcEndpointConnectionsRequest,
  DescribeNetworkInterfacePermissionsRequest,
  SearchTransitGatewayMulticastGroupsRequest,
  DescribeExportImageTasksRequest,
  DescribeVolumeAttributeRequest,
  ModifyPrivateDnsNameOptionsRequest,
  ProvisionPublicIpv4PoolCidrRequest,
  GetIpamAddressHistoryRequest,
  GetIpamPoolCidrsRequest,
  DescribeSnapshotsRequest,
  RestoreSnapshotTierRequest,
  DeleteVolumeRequest,
  GetSubnetCidrReservationsRequest,
  DeleteTransitGatewayPeeringAttachmentRequest,
  DeleteSnapshotRequest,
  AuthorizeClientVpnIngressRequest,
  DescribeLocalGatewayVirtualInterfaceGroupsRequest,
  DeleteSubnetCidrReservationRequest,
  GetGroupsForCapacityReservationRequest,
  DeleteKeyPairRequest,
  ModifyReservedInstancesRequest,
  DescribeReservedInstancesModificationsRequest,
  DescribeTransitGatewayMulticastDomainsRequest,
  ModifyInstanceMaintenanceOptionsRequest,
  DeletePublicIpv4PoolRequest,
  ReplaceRouteRequest,
  DescribeInstanceTypesRequest,
  CreateClientVpnRouteRequest,
  ReplaceTransitGatewayRouteRequest,
  EnableVpcClassicLinkDnsSupportRequest,
  DescribeNetworkInsightsAnalysesRequest,
  ModifyEbsDefaultKmsKeyIdRequest,
  DescribeTransitGatewayVpcAttachmentsRequest,
  DescribePlacementGroupsRequest,
  DescribeNatGatewaysRequest,
  DeleteTagsRequest,
  DescribeSnapshotTierStatusRequest,
  CreateDhcpOptionsRequest,
  ModifySecurityGroupRulesRequest,
  CreateLocalGatewayRouteTableVpcAssociationRequest,
  DeleteDhcpOptionsRequest,
  EnableEbsEncryptionByDefaultRequest,
  CreateReservedInstancesListingRequest,
  AllocateIpamPoolCidrRequest,
  ReportInstanceStatusRequest,
  ModifyIpamScopeRequest,
  GetTransitGatewayPrefixListReferencesRequest,
  AllocateHostsRequest,
  DeleteNetworkInterfaceRequest,
  DescribeFpgaImageAttributeRequest,
  DescribeFleetsRequest,
  DescribeInstanceAttributeRequest,
  DescribeTransitGatewayConnectPeersRequest,
  GetManagedPrefixListEntriesRequest,
  DeprovisionPublicIpv4PoolCidrRequest,
  ReplaceIamInstanceProfileAssociationRequest,
  DescribeImportSnapshotTasksRequest,
  ModifyCapacityReservationFleetRequest,
  CreateIpamRequest,
  ResetImageAttributeRequest,
  AssignPrivateIpAddressesRequest,
  ConfirmProductInstanceRequest,
  DescribeInstanceEventWindowsRequest,
  GetTransitGatewayMulticastDomainAssociationsRequest,
  DeleteCustomerGatewayRequest,
  ListImagesInRecycleBinRequest,
  DeleteLocalGatewayRouteRequest,
  DescribeCapacityReservationFleetsRequest,
  RevokeSecurityGroupEgressRequest,
  DescribeVpcEndpointConnectionNotificationsRequest,
  ModifyVpcEndpointRequest,
  DescribeCapacityReservationsRequest,
  GetHostReservationPurchasePreviewRequest,
  CreateFpgaImageRequest,
  ModifySpotFleetRequestRequest,
  DescribeSpotFleetRequestsRequest,
  ModifyTrafficMirrorFilterNetworkServicesRequest,
  DescribeSecurityGroupReferencesRequest,
  DeleteFleetsRequest,
  DisassociateIamInstanceProfileRequest,
  DescribeLocalGatewayRouteTablesRequest,
  DisableVpcClassicLinkDnsSupportRequest,
  TerminateInstancesRequest,
  DescribeTransitGatewayAttachmentsRequest,
  PurchaseScheduledInstancesRequest,
  DisassociateRouteTableRequest,
  CreateLocalGatewayRouteRequest,
  DisableVpcClassicLinkRequest,
  DescribeTransitGatewayRouteTablesRequest,
  ModifyVpcEndpointServicePayerResponsibilityRequest,
  DeleteVpnConnectionRequest,
  DescribeFpgaImagesRequest,
  DetachNetworkInterfaceRequest,
  CreateInstanceExportTaskRequest,
  DeleteIpamPoolRequest,
  DisassociateEnclaveCertificateIamRoleRequest,
  RunInstancesRequest,
  CreateTransitGatewayRequest,
  ModifyVpcEndpointServiceConfigurationRequest,
  DeleteRouteTableRequest,
  ModifyIpamResourceCidrRequest,
  CreateNetworkAclEntryRequest,
  DescribeInstanceEventNotificationAttributesRequest,
  CreateTagsRequest,
  CancelCapacityReservationRequest,
  CreateSpotDatafeedSubscriptionRequest,
  DisassociateTransitGatewayRouteTableRequest,
  DisassociateClientVpnTargetNetworkRequest,
  DescribeReplaceRootVolumeTasksRequest,
  ModifySubnetAttributeRequest,
  DetachVolumeRequest,
  DescribeIdentityIdFormatRequest,
  ModifyTrafficMirrorFilterRuleRequest,
  DescribeImportImageTasksRequest,
  CreateRouteRequest,
  GetCapacityReservationUsageRequest,
  CopySnapshotRequest,
  ModifyInstanceEventWindowRequest,
  ModifyVpcEndpointConnectionNotificationRequest,
  DescribeStoreImageTasksRequest,
  ModifySnapshotAttributeRequest,
  MoveByoipCidrToIpamRequest,
  DisassociateAddressRequest,
  CreateStoreImageTaskRequest,
  DescribeEgressOnlyInternetGatewaysRequest,
  DescribeTransitGatewaysRequest,
  ModifyCapacityReservationRequest,
  GetConsoleScreenshotRequest,
  CreateVpnConnectionRequest,
  DeleteTrafficMirrorSessionRequest,
  GetCoipPoolUsageRequest,
  ModifyDefaultCreditSpecificationRequest,
  ModifyAvailabilityZoneGroupRequest,
  EnableFastLaunchRequest,
  RejectTransitGatewayPeeringAttachmentRequest,
  ModifyVpnConnectionOptionsRequest,
  DeleteNetworkInsightsAccessScopeAnalysisRequest,
  DescribeReservedInstancesOfferingsRequest,
  CreateRouteTableRequest,
  StartNetworkInsightsAnalysisRequest,
  CreateDefaultVpcRequest,
  EnableFastSnapshotRestoresRequest,
  CreateCapacityReservationFleetRequest,
  ExportImageRequest,
  ImportVolumeRequest,
  DescribeCarrierGatewaysRequest,
  CreateNetworkInsightsAccessScopeRequest,
  BundleInstanceRequest,
  DisassociateTransitGatewayMulticastDomainRequest,
  DescribeAddressesRequest,
  RestoreManagedPrefixListVersionRequest,
  DeregisterTransitGatewayMulticastGroupSourcesRequest,
  DescribeClientVpnTargetNetworksRequest,
  DescribeFleetHistoryRequest,
  CreateTransitGatewayMulticastDomainRequest,
  EnableVpcClassicLinkRequest,
  DescribeTransitGatewayConnectsRequest,
  CreateFlowLogsRequest,
  GetInstanceUefiDataRequest,
  CreateTrafficMirrorFilterRequest,
  DescribeVolumesRequest,
  DescribePrincipalIdFormatRequest,
  AssociateDhcpOptionsRequest,
  CancelBundleTaskRequest,
  DeleteTransitGatewayMulticastDomainRequest,
  RejectTransitGatewayVpcAttachmentRequest,
  CreateTransitGatewayConnectPeerRequest,
  DescribeFleetInstancesRequest,
  DeleteFpgaImageRequest,
  ModifyTransitGatewayPrefixListReferenceRequest,
  CreateNetworkInsightsPathRequest,
  AssociateClientVpnTargetNetworkRequest,
  ModifyImageAttributeRequest,
  DeregisterInstanceEventNotificationAttributesRequest,
  DeletePlacementGroupRequest,
  DetachClassicLinkVpcRequest,
  UpdateSecurityGroupRuleDescriptionsEgressRequest,
  AuthorizeSecurityGroupEgressRequest,
  ModifyInstanceCapacityReservationAttributesRequest,
  DescribeLocalGatewaysRequest,
  AssociateRouteTableRequest,
  DisassociateTrunkInterfaceRequest,
  DescribeVpcEndpointServiceConfigurationsRequest,
  DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest,
  ModifyIpamRequest,
  DescribeSpotInstanceRequestsRequest,
  CreateIpamScopeRequest,
  ReplaceNetworkAclAssociationRequest,
  GetEbsEncryptionByDefaultRequest,
  DescribeDhcpOptionsRequest,
  RegisterTransitGatewayMulticastGroupSourcesRequest,
  CreateClientVpnEndpointRequest,
  CreateTransitGatewayRouteRequest,
  ModifyInstanceAttributeRequest,
  RejectVpcPeeringConnectionRequest,
  AcceptTransitGatewayVpcAttachmentRequest,
  ExportTransitGatewayRoutesRequest,
  DescribeInstanceTypeOfferingsRequest,
  DescribeClientVpnEndpointsRequest,
  UpdateSecurityGroupRuleDescriptionsIngressRequest,
  CancelSpotFleetRequestsRequest,
  ModifyVpnTunnelCertificateRequest,
  CreateSubnetCidrReservationRequest,
  GetFlowLogsIntegrationTemplateRequest,
  DescribeVpcEndpointServicesRequest,
  DescribeNetworkAclsRequest,
  DescribeSecurityGroupRulesRequest,
  DescribeClientVpnConnectionsRequest,
  DescribeCustomerGatewaysRequest,
  ModifyFpgaImageAttributeRequest,
  DescribeTransitGatewayPeeringAttachmentsRequest,
  GetAssociatedEnclaveCertificateIamRolesRequest,
  DescribeNetworkInsightsAccessScopesRequest,
  DeleteIpamRequest,
  CreatePublicIpv4PoolRequest,
  DescribeVpcPeeringConnectionsRequest,
  DeleteTransitGatewayConnectRequest,
  DescribeFastSnapshotRestoresRequest,
  DeleteTransitGatewayRequest,
  DeleteVpcRequest,
  CancelConversionTaskRequest,
  CreateNetworkAclRequest,
  DescribeIamInstanceProfileAssociationsRequest,
  CreateTrafficMirrorSessionRequest,
  CreateVpcPeeringConnectionRequest,
  CreateTrafficMirrorFilterRuleRequest,
  DescribeInternetGatewaysRequest,
  DescribePublicIpv4PoolsRequest,
  DeregisterTransitGatewayMulticastGroupMembersRequest,
  CreateKeyPairRequest,
  ModifyHostsRequest,
  SearchTransitGatewayRoutesRequest,
  GetConsoleOutputRequest,
  ProvisionByoipCidrRequest,
  StartInstancesRequest,
  DescribeVpcAttributeRequest,
  ReplaceRouteTableAssociationRequest,
  UnassignPrivateIpAddressesRequest,
  DeleteCarrierGatewayRequest,
  DeleteQueuedReservedInstancesRequest,
  DescribeNetworkInsightsAccessScopeAnalysesRequest,
  DescribeAggregateIdFormatRequest,
  AssociateAddressRequest,
  AssociateTransitGatewayMulticastDomainRequest,
  CreateReplaceRootVolumeTaskRequest,
  AdvertiseByoipCidrRequest,
  DeprovisionByoipCidrRequest,
  RequestSpotFleetRequest,
  DeleteNetworkInsightsAccessScopeRequest,
  CreateCustomerGatewayRequest,
  DescribeVolumeStatusRequest,
  GetAssociatedIpv6PoolCidrsRequest,
  AuthorizeSecurityGroupIngressRequest,
  CreateFleetRequest,
  DisableTransitGatewayRouteTablePropagationRequest,
  TerminateClientVpnConnectionsRequest,
  DeleteVpcEndpointServiceConfigurationsRequest,
  DeleteNetworkAclEntryRequest,
  CreateEgressOnlyInternetGatewayRequest,
  GetTransitGatewayAttachmentPropagationsRequest,
  CreateVpcEndpointRequest,
  CreateInstanceEventWindowRequest,
  DeleteIpamScopeRequest,
  CreateVpnConnectionRouteRequest,
  DescribeTagsRequest,
  DescribeVpcClassicLinkRequest,
  ModifyVpnTunnelOptionsRequest,
  DescribeSpotPriceHistoryRequest,
  CreateSecurityGroupRequest,
  CopyFpgaImageRequest,
  ModifyTransitGatewayVpcAttachmentRequest,
  CreateVolumeRequest,
  CreateManagedPrefixListRequest,
  ModifyInstancePlacementRequest,
  DescribeReservedInstancesRequest,
  DescribeConversionTasksRequest,
  GetTransitGatewayRouteTableAssociationsRequest,
  DescribeStaleSecurityGroupsRequest,
  RegisterTransitGatewayMulticastGroupMembersRequest,
  ReleaseIpamPoolAllocationRequest,
  DetachInternetGatewayRequest,
  DeleteTrafficMirrorFilterRuleRequest,
  CreateVpcRequest,
  StopInstancesRequest,
  GetManagedPrefixListAssociationsRequest,
  GetVpnConnectionDeviceTypesRequest,
  DescribeImageAttributeRequest,
  DescribeClientVpnAuthorizationRulesRequest,
  CreateRestoreImageTaskRequest,
  ImportInstanceRequest,
  DisassociateInstanceEventWindowRequest,
  DeleteClientVpnEndpointRequest,
  ModifyInstanceEventStartTimeRequest,
  DeleteManagedPrefixListRequest,
  GetSpotPlacementScoresRequest,
  DeleteVpnConnectionRouteRequest,
  DisableFastLaunchRequest,
  ResetFpgaImageAttributeRequest,
  DescribeSpotDatafeedSubscriptionRequest,
  DisableEbsEncryptionByDefaultRequest,
  DescribeTrafficMirrorTargetsRequest,
  CreateTrafficMirrorTargetRequest,
  ModifyIdentityIdFormatRequest,
  DeprovisionIpamPoolCidrRequest,
  CreateCarrierGatewayRequest,
  DescribeVolumesModificationsRequest,
  DescribeIpv6PoolsRequest,
  ModifyInstanceCreditSpecificationRequest,
  DescribeAccountAttributesRequest,
  MoveAddressToVpcRequest,
  DescribeHostsRequest,
  ImportSnapshotRequest,
  DescribeVpnConnectionsRequest,
  DeleteLocalGatewayRouteTableVpcAssociationRequest,
  DeleteTrafficMirrorTargetRequest,
  GetNetworkInsightsAccessScopeContentRequest,
  AssociateInstanceEventWindowRequest,
  DescribeSecurityGroupsRequest,
  CreateLaunchTemplateVersionRequest,
  DeleteInstanceEventWindowRequest,
  DescribeInstancesRequest,
  ModifyVpcPeeringConnectionOptionsRequest,
  RegisterImageRequest,
  ModifyLaunchTemplateRequest,
  RequestSpotInstancesRequest,
  AcceptTransitGatewayMulticastDomainAssociationsRequest,
  StartVpcEndpointServicePrivateDnsVerificationRequest,
  CreatePlacementGroupRequest,
  ModifyVpnConnectionRequest,
  ResetEbsDefaultKmsKeyIdRequest,
  CreateSnapshotRequest,
  DeleteVpnGatewayRequest,
  CreateImageRequest,
  CancelExportTaskRequest,
  DeleteSubnetRequest,
  ModifyManagedPrefixListRequest,
  DescribeImagesRequest,
  ModifyIdFormatRequest,
  AttachVpnGatewayRequest,
  DescribeSpotFleetInstancesRequest,
  ProvisionIpamPoolCidrRequest,
  ModifyTransitGatewayRequest,
  GetNetworkInsightsAccessScopeAnalysisFindingsRequest,
  RestoreSnapshotFromRecycleBinRequest,
  DescribeSnapshotAttributeRequest,
  DeleteTransitGatewayConnectPeerRequest,
  DescribeLocalGatewayVirtualInterfacesRequest,
  GetSerialConsoleAccessStatusRequest,
  CreateCapacityReservationRequest,
  UnassignIpv6AddressesRequest,
  DisableVgwRoutePropagationRequest,
  CreateNatGatewayRequest,
  CreateSnapshotsRequest,
  CreateDefaultSubnetRequest,
  ImportImageRequest,
  DeleteNetworkAclRequest,
  ModifyClientVpnEndpointRequest,
  RestoreImageFromRecycleBinRequest,
  DescribeScheduledInstanceAvailabilityRequest,
  DescribeVpcEndpointServicePermissionsRequest,
  DescribeSpotFleetRequestHistoryRequest,
  ModifySnapshotTierRequest,
  StartNetworkInsightsAccessScopeAnalysisRequest,
  DescribeClientVpnRoutesRequest,
  AttachInternetGatewayRequest,
  DescribeAddressesAttributeRequest,
  DescribeReservedInstancesListingsRequest,
  DescribeElasticGpusRequest,
  CreateTransitGatewayPrefixListReferenceRequest,
  CreateInternetGatewayRequest,
  DescribeVpcClassicLinkDnsSupportRequest,
  GetDefaultCreditSpecificationRequest,
  DeleteClientVpnRouteRequest,
  DeleteEgressOnlyInternetGatewayRequest,
  GetEbsDefaultKmsKeyIdRequest,
  ModifyVolumeRequest,
  DeleteTransitGatewayRouteRequest,
  DescribeInstanceStatusRequest,
  DescribeNetworkInterfacesRequest,
  DeleteLaunchTemplateRequest,
  DescribeVpcsRequest,
  RebootInstancesRequest,
  DisassociateSubnetCidrBlockRequest,
  DescribeScheduledInstancesRequest,
  DescribeHostReservationsRequest,
  AssignIpv6AddressesRequest,
  DeleteVpcEndpointConnectionNotificationsRequest,
  AcceptTransitGatewayPeeringAttachmentRequest,
  DeleteLaunchTemplateVersionsRequest,
  MonitorInstancesRequest,
  CancelReservedInstancesListingRequest,
  DescribeBundleTasksRequest,
  PurchaseReservedInstancesOfferingRequest,
  GetReservedInstancesExchangeQuoteRequest,
  CreateVpcEndpointServiceConfigurationRequest,
  RegisterInstanceEventNotificationAttributesRequest,
  ModifyInstanceMetadataOptionsRequest,
  DeleteVpcPeeringConnectionRequest,
  EnableVolumeIoRequest,
  EnableVgwRoutePropagationRequest,
  CreateTransitGatewayRouteTableRequest,
  DescribeRouteTablesRequest,
  ImportKeyPairRequest,
  CreateSubnetRequest,
  SendDiagnosticInterruptRequest,
  DescribeManagedPrefixListsRequest,
  DescribeByoipCidrsRequest,
  EnableTransitGatewayRouteTablePropagationRequest,
  DescribeLaunchTemplateVersionsRequest,
  AcceptReservedInstancesExchangeQuoteRequest,
  ResetInstanceAttributeRequest,
  GetLaunchTemplateDataRequest,
  DescribeIpamScopesRequest,
  AssociateEnclaveCertificateIamRoleRequest,
  GetVpnConnectionDeviceSampleConfigurationRequest,
  ModifyAddressAttributeRequest,
  EnableSerialConsoleAccessRequest,
  AssociateIamInstanceProfileRequest,
  UnmonitorInstancesRequest,
  DisableSerialConsoleAccessRequest,
  DisassociateVpcCidrBlockRequest,
  CreateTransitGatewayPeeringAttachmentRequest,
  DescribeClassicLinkInstancesRequest,
  RevokeSecurityGroupIngressRequest,
  DeleteNetworkInterfacePermissionRequest,
  DescribeFlowLogsRequest,
  DescribeNetworkInterfaceAttributeRequest,
  ModifyVolumeAttributeRequest,
  DeleteTransitGatewayRouteTableRequest,
  ModifyIpamPoolRequest,
  RejectVpcEndpointConnectionsRequest,
  CreateLaunchTemplateRequest,
  GetInstanceTypesFromInstanceRequirementsRequest,
  DisableFastSnapshotRestoresRequest,
  CreateNetworkInterfaceRequest,
  DescribeRegionsRequest,
  DescribeCoipPoolsRequest,
  GetIpamPoolAllocationsRequest,
  DescribeInstanceCreditSpecificationsRequest,
  AttachVolumeRequest,
  AssociateSubnetCidrBlockRequest,
  AcceptVpcEndpointConnectionsRequest,
  GetIpamResourceCidrsRequest,
  WithdrawByoipCidrRequest,
  GetTransitGatewayRouteTablePropagationsRequest,
  ResetAddressAttributeRequest,
  ModifyNetworkInterfaceAttributeRequest,
  DescribeVpnGatewaysRequest,
  CreateTransitGatewayVpcAttachmentRequest
}
import software.amazon.awssdk.services.ec2.Ec2AsyncClient
import zio.stream.ZStream
object Ec2Mock extends Mock[Ec2] {
  object DescribeVolumesModifications
      extends Stream[
        DescribeVolumesModificationsRequest,
        AwsError,
        zio.aws.ec2.model.VolumeModification.ReadOnly
      ]
  object DescribeVolumesModificationsPaginated
      extends Effect[
        DescribeVolumesModificationsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVolumesModificationsResponse.ReadOnly
      ]
  object DeleteSpotDatafeedSubscription
      extends Effect[DeleteSpotDatafeedSubscriptionRequest, AwsError, Unit]
  object DeleteVpcEndpointConnectionNotifications
      extends Effect[
        DeleteVpcEndpointConnectionNotificationsRequest,
        AwsError,
        zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsResponse.ReadOnly
      ]
  object CreateNetworkInterface
      extends Effect[
        CreateNetworkInterfaceRequest,
        AwsError,
        zio.aws.ec2.model.CreateNetworkInterfaceResponse.ReadOnly
      ]
  object EnableVpcClassicLink
      extends Effect[
        EnableVpcClassicLinkRequest,
        AwsError,
        zio.aws.ec2.model.EnableVpcClassicLinkResponse.ReadOnly
      ]
  object RejectTransitGatewayPeeringAttachment
      extends Effect[
        RejectTransitGatewayPeeringAttachmentRequest,
        AwsError,
        zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentResponse.ReadOnly
      ]
  object CreateVpnConnection
      extends Effect[
        CreateVpnConnectionRequest,
        AwsError,
        zio.aws.ec2.model.CreateVpnConnectionResponse.ReadOnly
      ]
  object DescribeDhcpOptions
      extends Stream[
        DescribeDhcpOptionsRequest,
        AwsError,
        zio.aws.ec2.model.DhcpOptions.ReadOnly
      ]
  object DescribeDhcpOptionsPaginated
      extends Effect[
        DescribeDhcpOptionsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeDhcpOptionsResponse.ReadOnly
      ]
  object ModifyVpnTunnelOptions
      extends Effect[
        ModifyVpnTunnelOptionsRequest,
        AwsError,
        zio.aws.ec2.model.ModifyVpnTunnelOptionsResponse.ReadOnly
      ]
  object ModifyCapacityReservation
      extends Effect[
        ModifyCapacityReservationRequest,
        AwsError,
        zio.aws.ec2.model.ModifyCapacityReservationResponse.ReadOnly
      ]
  object DescribeVpcs
      extends Stream[
        DescribeVpcsRequest,
        AwsError,
        zio.aws.ec2.model.Vpc.ReadOnly
      ]
  object DescribeVpcsPaginated
      extends Effect[
        DescribeVpcsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVpcsResponse.ReadOnly
      ]
  object DeleteNetworkInsightsAnalysis
      extends Effect[
        DeleteNetworkInsightsAnalysisRequest,
        AwsError,
        zio.aws.ec2.model.DeleteNetworkInsightsAnalysisResponse.ReadOnly
      ]
  object DescribeIdentityIdFormat
      extends Effect[
        DescribeIdentityIdFormatRequest,
        AwsError,
        zio.aws.ec2.model.DescribeIdentityIdFormatResponse.ReadOnly
      ]
  object DescribeTags
      extends Stream[
        DescribeTagsRequest,
        AwsError,
        zio.aws.ec2.model.TagDescription.ReadOnly
      ]
  object DescribeTagsPaginated
      extends Effect[
        DescribeTagsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeTagsResponse.ReadOnly
      ]
  object MonitorInstances
      extends Effect[
        MonitorInstancesRequest,
        AwsError,
        zio.aws.ec2.model.MonitorInstancesResponse.ReadOnly
      ]
  object AllocateIpamPoolCidr
      extends Effect[
        AllocateIpamPoolCidrRequest,
        AwsError,
        zio.aws.ec2.model.AllocateIpamPoolCidrResponse.ReadOnly
      ]
  object GetManagedPrefixListEntries
      extends Stream[
        GetManagedPrefixListEntriesRequest,
        AwsError,
        zio.aws.ec2.model.PrefixListEntry.ReadOnly
      ]
  object GetManagedPrefixListEntriesPaginated
      extends Effect[
        GetManagedPrefixListEntriesRequest,
        AwsError,
        zio.aws.ec2.model.GetManagedPrefixListEntriesResponse.ReadOnly
      ]
  object DeleteTransitGatewayPeeringAttachment
      extends Effect[
        DeleteTransitGatewayPeeringAttachmentRequest,
        AwsError,
        zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse.ReadOnly
      ]
  object GetTransitGatewayMulticastDomainAssociations
      extends Stream[
        GetTransitGatewayMulticastDomainAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation.ReadOnly
      ]
  object GetTransitGatewayMulticastDomainAssociationsPaginated
      extends Effect[
        GetTransitGatewayMulticastDomainAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
      ]
  object ModifyIpamResourceCidr
      extends Effect[
        ModifyIpamResourceCidrRequest,
        AwsError,
        zio.aws.ec2.model.ModifyIpamResourceCidrResponse.ReadOnly
      ]
  object CreateTransitGatewayVpcAttachment
      extends Effect[
        CreateTransitGatewayVpcAttachmentRequest,
        AwsError,
        zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentResponse.ReadOnly
      ]
  object ReplaceNetworkAclEntry
      extends Effect[ReplaceNetworkAclEntryRequest, AwsError, Unit]
  object DescribeVpcPeeringConnections
      extends Stream[
        DescribeVpcPeeringConnectionsRequest,
        AwsError,
        zio.aws.ec2.model.VpcPeeringConnection.ReadOnly
      ]
  object DescribeVpcPeeringConnectionsPaginated
      extends Effect[
        DescribeVpcPeeringConnectionsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVpcPeeringConnectionsResponse.ReadOnly
      ]
  object DescribeFleetHistory
      extends Effect[
        DescribeFleetHistoryRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.ec2.model.DescribeFleetHistoryResponse.ReadOnly,
          zio.aws.ec2.model.HistoryRecordEntry.ReadOnly
        ]
      ]
  object DescribeFleetHistoryPaginated
      extends Effect[
        DescribeFleetHistoryRequest,
        AwsError,
        zio.aws.ec2.model.DescribeFleetHistoryResponse.ReadOnly
      ]
  object CancelSpotFleetRequests
      extends Effect[
        CancelSpotFleetRequestsRequest,
        AwsError,
        zio.aws.ec2.model.CancelSpotFleetRequestsResponse.ReadOnly
      ]
  object BundleInstance
      extends Effect[
        BundleInstanceRequest,
        AwsError,
        zio.aws.ec2.model.BundleInstanceResponse.ReadOnly
      ]
  object RevokeClientVpnIngress
      extends Effect[
        RevokeClientVpnIngressRequest,
        AwsError,
        zio.aws.ec2.model.RevokeClientVpnIngressResponse.ReadOnly
      ]
  object DeleteSubnetCidrReservation
      extends Effect[
        DeleteSubnetCidrReservationRequest,
        AwsError,
        zio.aws.ec2.model.DeleteSubnetCidrReservationResponse.ReadOnly
      ]
  object AssociateTransitGatewayMulticastDomain
      extends Effect[
        AssociateTransitGatewayMulticastDomainRequest,
        AwsError,
        zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse.ReadOnly
      ]
  object SearchTransitGatewayMulticastGroups
      extends Stream[
        SearchTransitGatewayMulticastGroupsRequest,
        AwsError,
        zio.aws.ec2.model.TransitGatewayMulticastGroup.ReadOnly
      ]
  object SearchTransitGatewayMulticastGroupsPaginated
      extends Effect[
        SearchTransitGatewayMulticastGroupsRequest,
        AwsError,
        zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsResponse.ReadOnly
      ]
  object SendDiagnosticInterrupt
      extends Effect[SendDiagnosticInterruptRequest, AwsError, Unit]
  object DescribeAddresses
      extends Effect[
        DescribeAddressesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeAddressesResponse.ReadOnly
      ]
  object EnableTransitGatewayRouteTablePropagation
      extends Effect[
        EnableTransitGatewayRouteTablePropagationRequest,
        AwsError,
        zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationResponse.ReadOnly
      ]
  object DeleteIpamScope
      extends Effect[
        DeleteIpamScopeRequest,
        AwsError,
        zio.aws.ec2.model.DeleteIpamScopeResponse.ReadOnly
      ]
  object CreatePublicIpv4Pool
      extends Effect[
        CreatePublicIpv4PoolRequest,
        AwsError,
        zio.aws.ec2.model.CreatePublicIpv4PoolResponse.ReadOnly
      ]
  object CreateTransitGatewayRouteTable
      extends Effect[
        CreateTransitGatewayRouteTableRequest,
        AwsError,
        zio.aws.ec2.model.CreateTransitGatewayRouteTableResponse.ReadOnly
      ]
  object RegisterTransitGatewayMulticastGroupMembers
      extends Effect[
        RegisterTransitGatewayMulticastGroupMembersRequest,
        AwsError,
        zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse.ReadOnly
      ]
  object DescribeKeyPairs
      extends Effect[
        DescribeKeyPairsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeKeyPairsResponse.ReadOnly
      ]
  object StartInstances
      extends Effect[
        StartInstancesRequest,
        AwsError,
        zio.aws.ec2.model.StartInstancesResponse.ReadOnly
      ]
  object DescribeScheduledInstanceAvailability
      extends Stream[
        DescribeScheduledInstanceAvailabilityRequest,
        AwsError,
        zio.aws.ec2.model.ScheduledInstanceAvailability.ReadOnly
      ]
  object DescribeScheduledInstanceAvailabilityPaginated
      extends Effect[
        DescribeScheduledInstanceAvailabilityRequest,
        AwsError,
        zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityResponse.ReadOnly
      ]
  object ResetInstanceAttribute
      extends Effect[ResetInstanceAttributeRequest, AwsError, Unit]
  object ModifyInstanceMetadataOptions
      extends Effect[
        ModifyInstanceMetadataOptionsRequest,
        AwsError,
        zio.aws.ec2.model.ModifyInstanceMetadataOptionsResponse.ReadOnly
      ]
  object CreateRoute
      extends Effect[
        CreateRouteRequest,
        AwsError,
        zio.aws.ec2.model.CreateRouteResponse.ReadOnly
      ]
  object DeleteFlowLogs
      extends Effect[
        DeleteFlowLogsRequest,
        AwsError,
        zio.aws.ec2.model.DeleteFlowLogsResponse.ReadOnly
      ]
  object DescribeFpgaImages
      extends Stream[
        DescribeFpgaImagesRequest,
        AwsError,
        zio.aws.ec2.model.FpgaImage.ReadOnly
      ]
  object DescribeFpgaImagesPaginated
      extends Effect[
        DescribeFpgaImagesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeFpgaImagesResponse.ReadOnly
      ]
  object DeleteRoute extends Effect[DeleteRouteRequest, AwsError, Unit]
  object ModifyClientVpnEndpoint
      extends Effect[
        ModifyClientVpnEndpointRequest,
        AwsError,
        zio.aws.ec2.model.ModifyClientVpnEndpointResponse.ReadOnly
      ]
  object ModifyTrafficMirrorFilterNetworkServices
      extends Effect[
        ModifyTrafficMirrorFilterNetworkServicesRequest,
        AwsError,
        zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse.ReadOnly
      ]
  object DisassociateTransitGatewayRouteTable
      extends Effect[
        DisassociateTransitGatewayRouteTableRequest,
        AwsError,
        zio.aws.ec2.model.DisassociateTransitGatewayRouteTableResponse.ReadOnly
      ]
  object ModifyInstanceCapacityReservationAttributes
      extends Effect[
        ModifyInstanceCapacityReservationAttributesRequest,
        AwsError,
        zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesResponse.ReadOnly
      ]
  object DescribeRouteTables
      extends Stream[
        DescribeRouteTablesRequest,
        AwsError,
        zio.aws.ec2.model.RouteTable.ReadOnly
      ]
  object DescribeRouteTablesPaginated
      extends Effect[
        DescribeRouteTablesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeRouteTablesResponse.ReadOnly
      ]
  object ModifySubnetAttribute
      extends Effect[ModifySubnetAttributeRequest, AwsError, Unit]
  object ModifyVolumeAttribute
      extends Effect[ModifyVolumeAttributeRequest, AwsError, Unit]
  object AcceptVpcEndpointConnections
      extends Effect[
        AcceptVpcEndpointConnectionsRequest,
        AwsError,
        zio.aws.ec2.model.AcceptVpcEndpointConnectionsResponse.ReadOnly
      ]
  object AttachNetworkInterface
      extends Effect[
        AttachNetworkInterfaceRequest,
        AwsError,
        zio.aws.ec2.model.AttachNetworkInterfaceResponse.ReadOnly
      ]
  object DeleteFpgaImage
      extends Effect[
        DeleteFpgaImageRequest,
        AwsError,
        zio.aws.ec2.model.DeleteFpgaImageResponse.ReadOnly
      ]
  object DeleteTransitGatewayVpcAttachment
      extends Effect[
        DeleteTransitGatewayVpcAttachmentRequest,
        AwsError,
        zio.aws.ec2.model.DeleteTransitGatewayVpcAttachmentResponse.ReadOnly
      ]
  object DeleteSecurityGroup
      extends Effect[DeleteSecurityGroupRequest, AwsError, Unit]
  object DescribeNatGateways
      extends Stream[
        DescribeNatGatewaysRequest,
        AwsError,
        zio.aws.ec2.model.NatGateway.ReadOnly
      ]
  object DescribeNatGatewaysPaginated
      extends Effect[
        DescribeNatGatewaysRequest,
        AwsError,
        zio.aws.ec2.model.DescribeNatGatewaysResponse.ReadOnly
      ]
  object GetCoipPoolUsage
      extends Effect[
        GetCoipPoolUsageRequest,
        AwsError,
        zio.aws.ec2.model.GetCoipPoolUsageResponse.ReadOnly
      ]
  object AuthorizeSecurityGroupEgress
      extends Effect[
        AuthorizeSecurityGroupEgressRequest,
        AwsError,
        zio.aws.ec2.model.AuthorizeSecurityGroupEgressResponse.ReadOnly
      ]
  object ModifyVpcEndpoint
      extends Effect[
        ModifyVpcEndpointRequest,
        AwsError,
        zio.aws.ec2.model.ModifyVpcEndpointResponse.ReadOnly
      ]
  object DeprovisionIpamPoolCidr
      extends Effect[
        DeprovisionIpamPoolCidrRequest,
        AwsError,
        zio.aws.ec2.model.DeprovisionIpamPoolCidrResponse.ReadOnly
      ]
  object DeleteTransitGatewayPrefixListReference
      extends Effect[
        DeleteTransitGatewayPrefixListReferenceRequest,
        AwsError,
        zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse.ReadOnly
      ]
  object CreateInternetGateway
      extends Effect[
        CreateInternetGatewayRequest,
        AwsError,
        zio.aws.ec2.model.CreateInternetGatewayResponse.ReadOnly
      ]
  object DescribeCarrierGateways
      extends Stream[
        DescribeCarrierGatewaysRequest,
        AwsError,
        zio.aws.ec2.model.CarrierGateway.ReadOnly
      ]
  object DescribeCarrierGatewaysPaginated
      extends Effect[
        DescribeCarrierGatewaysRequest,
        AwsError,
        zio.aws.ec2.model.DescribeCarrierGatewaysResponse.ReadOnly
      ]
  object DisableSerialConsoleAccess
      extends Effect[
        DisableSerialConsoleAccessRequest,
        AwsError,
        zio.aws.ec2.model.DisableSerialConsoleAccessResponse.ReadOnly
      ]
  object EnableEbsEncryptionByDefault
      extends Effect[
        EnableEbsEncryptionByDefaultRequest,
        AwsError,
        zio.aws.ec2.model.EnableEbsEncryptionByDefaultResponse.ReadOnly
      ]
  object ModifyTransitGatewayVpcAttachment
      extends Effect[
        ModifyTransitGatewayVpcAttachmentRequest,
        AwsError,
        zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentResponse.ReadOnly
      ]
  object AssignPrivateIpAddresses
      extends Effect[
        AssignPrivateIpAddressesRequest,
        AwsError,
        zio.aws.ec2.model.AssignPrivateIpAddressesResponse.ReadOnly
      ]
  object ModifyLaunchTemplate
      extends Effect[
        ModifyLaunchTemplateRequest,
        AwsError,
        zio.aws.ec2.model.ModifyLaunchTemplateResponse.ReadOnly
      ]
  object DeleteRouteTable
      extends Effect[DeleteRouteTableRequest, AwsError, Unit]
  object RestoreAddressToClassic
      extends Effect[
        RestoreAddressToClassicRequest,
        AwsError,
        zio.aws.ec2.model.RestoreAddressToClassicResponse.ReadOnly
      ]
  object DescribeFastLaunchImages
      extends Stream[
        DescribeFastLaunchImagesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeFastLaunchImagesSuccessItem.ReadOnly
      ]
  object DescribeFastLaunchImagesPaginated
      extends Effect[
        DescribeFastLaunchImagesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeFastLaunchImagesResponse.ReadOnly
      ]
  object DescribeMovingAddresses
      extends Stream[
        DescribeMovingAddressesRequest,
        AwsError,
        zio.aws.ec2.model.MovingAddressStatus.ReadOnly
      ]
  object DescribeMovingAddressesPaginated
      extends Effect[
        DescribeMovingAddressesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeMovingAddressesResponse.ReadOnly
      ]
  object ModifyPrivateDnsNameOptions
      extends Effect[
        ModifyPrivateDnsNameOptionsRequest,
        AwsError,
        zio.aws.ec2.model.ModifyPrivateDnsNameOptionsResponse.ReadOnly
      ]
  object DescribeFleetInstances
      extends Effect[
        DescribeFleetInstancesRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.ec2.model.DescribeFleetInstancesResponse.ReadOnly,
          zio.aws.ec2.model.ActiveInstance.ReadOnly
        ]
      ]
  object DescribeFleetInstancesPaginated
      extends Effect[
        DescribeFleetInstancesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeFleetInstancesResponse.ReadOnly
      ]
  object DescribeSecurityGroupRules
      extends Stream[DescribeSecurityGroupRulesRequest, AwsError, ReadOnly]
  object DescribeSecurityGroupRulesPaginated
      extends Effect[
        DescribeSecurityGroupRulesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeSecurityGroupRulesResponse.ReadOnly
      ]
  object RejectVpcPeeringConnection
      extends Effect[
        RejectVpcPeeringConnectionRequest,
        AwsError,
        zio.aws.ec2.model.RejectVpcPeeringConnectionResponse.ReadOnly
      ]
  object AttachInternetGateway
      extends Effect[AttachInternetGatewayRequest, AwsError, Unit]
  object DescribeAvailabilityZones
      extends Effect[
        DescribeAvailabilityZonesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeAvailabilityZonesResponse.ReadOnly
      ]
  object CancelBundleTask
      extends Effect[
        CancelBundleTaskRequest,
        AwsError,
        zio.aws.ec2.model.CancelBundleTaskResponse.ReadOnly
      ]
  object DescribeLocalGateways
      extends Stream[
        DescribeLocalGatewaysRequest,
        AwsError,
        zio.aws.ec2.model.LocalGateway.ReadOnly
      ]
  object DescribeLocalGatewaysPaginated
      extends Effect[
        DescribeLocalGatewaysRequest,
        AwsError,
        zio.aws.ec2.model.DescribeLocalGatewaysResponse.ReadOnly
      ]
  object DeleteVpc extends Effect[DeleteVpcRequest, AwsError, Unit]
  object DeleteVpnConnectionRoute
      extends Effect[DeleteVpnConnectionRouteRequest, AwsError, Unit]
  object DeleteTransitGatewayMulticastDomain
      extends Effect[
        DeleteTransitGatewayMulticastDomainRequest,
        AwsError,
        zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainResponse.ReadOnly
      ]
  object DisassociateClientVpnTargetNetwork
      extends Effect[
        DisassociateClientVpnTargetNetworkRequest,
        AwsError,
        zio.aws.ec2.model.DisassociateClientVpnTargetNetworkResponse.ReadOnly
      ]
  object DescribeInstances
      extends Stream[
        DescribeInstancesRequest,
        AwsError,
        zio.aws.ec2.model.Reservation.ReadOnly
      ]
  object DescribeInstancesPaginated
      extends Effect[
        DescribeInstancesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeInstancesResponse.ReadOnly
      ]
  object DescribeVpnConnections
      extends Effect[
        DescribeVpnConnectionsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVpnConnectionsResponse.ReadOnly
      ]
  object AttachClassicLinkVpc
      extends Effect[
        AttachClassicLinkVpcRequest,
        AwsError,
        zio.aws.ec2.model.AttachClassicLinkVpcResponse.ReadOnly
      ]
  object CreateLaunchTemplateVersion
      extends Effect[
        CreateLaunchTemplateVersionRequest,
        AwsError,
        zio.aws.ec2.model.CreateLaunchTemplateVersionResponse.ReadOnly
      ]
  object DeleteNetworkInsightsAccessScope
      extends Effect[
        DeleteNetworkInsightsAccessScopeRequest,
        AwsError,
        zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeResponse.ReadOnly
      ]
  object ModifyVpcEndpointConnectionNotification
      extends Effect[
        ModifyVpcEndpointConnectionNotificationRequest,
        AwsError,
        zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationResponse.ReadOnly
      ]
  object DescribeInstanceTypes
      extends Stream[
        DescribeInstanceTypesRequest,
        AwsError,
        zio.aws.ec2.model.InstanceTypeInfo.ReadOnly
      ]
  object DescribeInstanceTypesPaginated
      extends Effect[
        DescribeInstanceTypesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeInstanceTypesResponse.ReadOnly
      ]
  object RebootInstances extends Effect[RebootInstancesRequest, AwsError, Unit]
  object DescribeInstanceCreditSpecifications
      extends Stream[
        DescribeInstanceCreditSpecificationsRequest,
        AwsError,
        zio.aws.ec2.model.InstanceCreditSpecification.ReadOnly
      ]
  object DescribeInstanceCreditSpecificationsPaginated
      extends Effect[
        DescribeInstanceCreditSpecificationsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeInstanceCreditSpecificationsResponse.ReadOnly
      ]
  object DescribeFleets
      extends Stream[
        DescribeFleetsRequest,
        AwsError,
        zio.aws.ec2.model.FleetData.ReadOnly
      ]
  object DescribeFleetsPaginated
      extends Effect[
        DescribeFleetsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeFleetsResponse.ReadOnly
      ]
  object GetSpotPlacementScores
      extends Stream[
        GetSpotPlacementScoresRequest,
        AwsError,
        zio.aws.ec2.model.SpotPlacementScore.ReadOnly
      ]
  object GetSpotPlacementScoresPaginated
      extends Effect[
        GetSpotPlacementScoresRequest,
        AwsError,
        zio.aws.ec2.model.GetSpotPlacementScoresResponse.ReadOnly
      ]
  object CreateDefaultSubnet
      extends Effect[
        CreateDefaultSubnetRequest,
        AwsError,
        zio.aws.ec2.model.CreateDefaultSubnetResponse.ReadOnly
      ]
  object ModifyVolume
      extends Effect[
        ModifyVolumeRequest,
        AwsError,
        zio.aws.ec2.model.ModifyVolumeResponse.ReadOnly
      ]
  object GetSerialConsoleAccessStatus
      extends Effect[
        GetSerialConsoleAccessStatusRequest,
        AwsError,
        zio.aws.ec2.model.GetSerialConsoleAccessStatusResponse.ReadOnly
      ]
  object GetEbsEncryptionByDefault
      extends Effect[
        GetEbsEncryptionByDefaultRequest,
        AwsError,
        zio.aws.ec2.model.GetEbsEncryptionByDefaultResponse.ReadOnly
      ]
  object DescribeSnapshotTierStatus
      extends Stream[
        DescribeSnapshotTierStatusRequest,
        AwsError,
        zio.aws.ec2.model.SnapshotTierStatus.ReadOnly
      ]
  object DescribeSnapshotTierStatusPaginated
      extends Effect[
        DescribeSnapshotTierStatusRequest,
        AwsError,
        zio.aws.ec2.model.DescribeSnapshotTierStatusResponse.ReadOnly
      ]
  object ResetNetworkInterfaceAttribute
      extends Effect[ResetNetworkInterfaceAttributeRequest, AwsError, Unit]
  object ModifyTransitGateway
      extends Effect[
        ModifyTransitGatewayRequest,
        AwsError,
        zio.aws.ec2.model.ModifyTransitGatewayResponse.ReadOnly
      ]
  object EnableVolumeIO extends Effect[EnableVolumeIoRequest, AwsError, Unit]
  object DeleteTransitGatewayRoute
      extends Effect[
        DeleteTransitGatewayRouteRequest,
        AwsError,
        zio.aws.ec2.model.DeleteTransitGatewayRouteResponse.ReadOnly
      ]
  object DescribeImportSnapshotTasks
      extends Stream[
        DescribeImportSnapshotTasksRequest,
        AwsError,
        zio.aws.ec2.model.ImportSnapshotTask.ReadOnly
      ]
  object DescribeImportSnapshotTasksPaginated
      extends Effect[
        DescribeImportSnapshotTasksRequest,
        AwsError,
        zio.aws.ec2.model.DescribeImportSnapshotTasksResponse.ReadOnly
      ]
  object DescribeNetworkInsightsAnalyses
      extends Stream[
        DescribeNetworkInsightsAnalysesRequest,
        AwsError,
        zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly
      ]
  object DescribeNetworkInsightsAnalysesPaginated
      extends Effect[
        DescribeNetworkInsightsAnalysesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeNetworkInsightsAnalysesResponse.ReadOnly
      ]
  object DisassociateSubnetCidrBlock
      extends Effect[
        DisassociateSubnetCidrBlockRequest,
        AwsError,
        zio.aws.ec2.model.DisassociateSubnetCidrBlockResponse.ReadOnly
      ]
  object CancelExportTask
      extends Effect[CancelExportTaskRequest, AwsError, Unit]
  object DeleteVpnGateway
      extends Effect[DeleteVpnGatewayRequest, AwsError, Unit]
  object AssociateVpcCidrBlock
      extends Effect[
        AssociateVpcCidrBlockRequest,
        AwsError,
        zio.aws.ec2.model.AssociateVpcCidrBlockResponse.ReadOnly
      ]
  object ModifyInstanceEventStartTime
      extends Effect[
        ModifyInstanceEventStartTimeRequest,
        AwsError,
        zio.aws.ec2.model.ModifyInstanceEventStartTimeResponse.ReadOnly
      ]
  object ReportInstanceStatus
      extends Effect[ReportInstanceStatusRequest, AwsError, Unit]
  object CreateVpcEndpointServiceConfiguration
      extends Effect[
        CreateVpcEndpointServiceConfigurationRequest,
        AwsError,
        zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse.ReadOnly
      ]
  object GetEbsDefaultKmsKeyId
      extends Effect[
        GetEbsDefaultKmsKeyIdRequest,
        AwsError,
        zio.aws.ec2.model.GetEbsDefaultKmsKeyIdResponse.ReadOnly
      ]
  object DeleteNetworkInterfacePermission
      extends Effect[
        DeleteNetworkInterfacePermissionRequest,
        AwsError,
        zio.aws.ec2.model.DeleteNetworkInterfacePermissionResponse.ReadOnly
      ]
  object DescribeTransitGatewayPeeringAttachments
      extends Stream[
        DescribeTransitGatewayPeeringAttachmentsRequest,
        AwsError,
        zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly
      ]
  object DescribeTransitGatewayPeeringAttachmentsPaginated
      extends Effect[
        DescribeTransitGatewayPeeringAttachmentsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse.ReadOnly
      ]
  object DescribeReservedInstances
      extends Effect[
        DescribeReservedInstancesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeReservedInstancesResponse.ReadOnly
      ]
  object DescribeLocalGatewayVirtualInterfaces
      extends Stream[
        DescribeLocalGatewayVirtualInterfacesRequest,
        AwsError,
        zio.aws.ec2.model.LocalGatewayVirtualInterface.ReadOnly
      ]
  object DescribeLocalGatewayVirtualInterfacesPaginated
      extends Effect[
        DescribeLocalGatewayVirtualInterfacesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse.ReadOnly
      ]
  object ModifySecurityGroupRules
      extends Effect[
        ModifySecurityGroupRulesRequest,
        AwsError,
        zio.aws.ec2.model.ModifySecurityGroupRulesResponse.ReadOnly
      ]
  object CreateEgressOnlyInternetGateway
      extends Effect[
        CreateEgressOnlyInternetGatewayRequest,
        AwsError,
        zio.aws.ec2.model.CreateEgressOnlyInternetGatewayResponse.ReadOnly
      ]
  object GetPasswordData
      extends Effect[
        GetPasswordDataRequest,
        AwsError,
        zio.aws.ec2.model.GetPasswordDataResponse.ReadOnly
      ]
  object ExportClientVpnClientCertificateRevocationList
      extends Effect[
        ExportClientVpnClientCertificateRevocationListRequest,
        AwsError,
        zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListResponse.ReadOnly
      ]
  object PurchaseScheduledInstances
      extends Effect[
        PurchaseScheduledInstancesRequest,
        AwsError,
        zio.aws.ec2.model.PurchaseScheduledInstancesResponse.ReadOnly
      ]
  object GetTransitGatewayAttachmentPropagations
      extends Stream[
        GetTransitGatewayAttachmentPropagationsRequest,
        AwsError,
        zio.aws.ec2.model.TransitGatewayAttachmentPropagation.ReadOnly
      ]
  object GetTransitGatewayAttachmentPropagationsPaginated
      extends Effect[
        GetTransitGatewayAttachmentPropagationsRequest,
        AwsError,
        zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsResponse.ReadOnly
      ]
  object DescribeClassicLinkInstances
      extends Stream[
        DescribeClassicLinkInstancesRequest,
        AwsError,
        zio.aws.ec2.model.ClassicLinkInstance.ReadOnly
      ]
  object DescribeClassicLinkInstancesPaginated
      extends Effect[
        DescribeClassicLinkInstancesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeClassicLinkInstancesResponse.ReadOnly
      ]
  object DescribeCoipPools
      extends Stream[
        DescribeCoipPoolsRequest,
        AwsError,
        zio.aws.ec2.model.CoipPool.ReadOnly
      ]
  object DescribeCoipPoolsPaginated
      extends Effect[
        DescribeCoipPoolsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeCoipPoolsResponse.ReadOnly
      ]
  object CreateVpcEndpointConnectionNotification
      extends Effect[
        CreateVpcEndpointConnectionNotificationRequest,
        AwsError,
        zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationResponse.ReadOnly
      ]
  object ModifyVpnConnectionOptions
      extends Effect[
        ModifyVpnConnectionOptionsRequest,
        AwsError,
        zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse.ReadOnly
      ]
  object GetSubnetCidrReservations
      extends Effect[
        GetSubnetCidrReservationsRequest,
        AwsError,
        zio.aws.ec2.model.GetSubnetCidrReservationsResponse.ReadOnly
      ]
  object DeleteDhcpOptions
      extends Effect[DeleteDhcpOptionsRequest, AwsError, Unit]
  object RequestSpotInstances
      extends Effect[
        RequestSpotInstancesRequest,
        AwsError,
        zio.aws.ec2.model.RequestSpotInstancesResponse.ReadOnly
      ]
  object DeleteCustomerGateway
      extends Effect[DeleteCustomerGatewayRequest, AwsError, Unit]
  object DeleteTransitGateway
      extends Effect[
        DeleteTransitGatewayRequest,
        AwsError,
        zio.aws.ec2.model.DeleteTransitGatewayResponse.ReadOnly
      ]
  object AuthorizeSecurityGroupIngress
      extends Effect[
        AuthorizeSecurityGroupIngressRequest,
        AwsError,
        zio.aws.ec2.model.AuthorizeSecurityGroupIngressResponse.ReadOnly
      ]
  object TerminateClientVpnConnections
      extends Effect[
        TerminateClientVpnConnectionsRequest,
        AwsError,
        zio.aws.ec2.model.TerminateClientVpnConnectionsResponse.ReadOnly
      ]
  object ImportVolume
      extends Effect[
        ImportVolumeRequest,
        AwsError,
        zio.aws.ec2.model.ImportVolumeResponse.ReadOnly
      ]
  object DeregisterTransitGatewayMulticastGroupSources
      extends Effect[
        DeregisterTransitGatewayMulticastGroupSourcesRequest,
        AwsError,
        zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly
      ]
  object DisassociateTransitGatewayMulticastDomain
      extends Effect[
        DisassociateTransitGatewayMulticastDomainRequest,
        AwsError,
        zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainResponse.ReadOnly
      ]
  object DescribeVpcClassicLinkDnsSupport
      extends Stream[
        DescribeVpcClassicLinkDnsSupportRequest,
        AwsError,
        zio.aws.ec2.model.ClassicLinkDnsSupport.ReadOnly
      ]
  object DescribeVpcClassicLinkDnsSupportPaginated
      extends Effect[
        DescribeVpcClassicLinkDnsSupportRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportResponse.ReadOnly
      ]
  object DescribeInstanceEventWindows
      extends Stream[
        DescribeInstanceEventWindowsRequest,
        AwsError,
        zio.aws.ec2.model.InstanceEventWindow.ReadOnly
      ]
  object DescribeInstanceEventWindowsPaginated
      extends Effect[
        DescribeInstanceEventWindowsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeInstanceEventWindowsResponse.ReadOnly
      ]
  object ApplySecurityGroupsToClientVpnTargetNetwork
      extends Effect[
        ApplySecurityGroupsToClientVpnTargetNetworkRequest,
        AwsError,
        zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse.ReadOnly
      ]
  object CreateSnapshots
      extends Effect[
        CreateSnapshotsRequest,
        AwsError,
        zio.aws.ec2.model.CreateSnapshotsResponse.ReadOnly
      ]
  object RejectVpcEndpointConnections
      extends Effect[
        RejectVpcEndpointConnectionsRequest,
        AwsError,
        zio.aws.ec2.model.RejectVpcEndpointConnectionsResponse.ReadOnly
      ]
  object CopySnapshot
      extends Effect[
        CopySnapshotRequest,
        AwsError,
        zio.aws.ec2.model.CopySnapshotResponse.ReadOnly
      ]
  object DescribeInstanceTypeOfferings
      extends Stream[
        DescribeInstanceTypeOfferingsRequest,
        AwsError,
        zio.aws.ec2.model.InstanceTypeOffering.ReadOnly
      ]
  object DescribeInstanceTypeOfferingsPaginated
      extends Effect[
        DescribeInstanceTypeOfferingsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeInstanceTypeOfferingsResponse.ReadOnly
      ]
  object DeleteManagedPrefixList
      extends Effect[
        DeleteManagedPrefixListRequest,
        AwsError,
        zio.aws.ec2.model.DeleteManagedPrefixListResponse.ReadOnly
      ]
  object DeleteTransitGatewayRouteTable
      extends Effect[
        DeleteTransitGatewayRouteTableRequest,
        AwsError,
        zio.aws.ec2.model.DeleteTransitGatewayRouteTableResponse.ReadOnly
      ]
  object DescribeHosts
      extends Stream[
        DescribeHostsRequest,
        AwsError,
        zio.aws.ec2.model.Host.ReadOnly
      ]
  object DescribeHostsPaginated
      extends Effect[
        DescribeHostsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeHostsResponse.ReadOnly
      ]
  object ModifyIdFormat extends Effect[ModifyIdFormatRequest, AwsError, Unit]
  object DisableFastLaunch
      extends Effect[
        DisableFastLaunchRequest,
        AwsError,
        zio.aws.ec2.model.DisableFastLaunchResponse.ReadOnly
      ]
  object GetGroupsForCapacityReservation
      extends Stream[
        GetGroupsForCapacityReservationRequest,
        AwsError,
        zio.aws.ec2.model.CapacityReservationGroup.ReadOnly
      ]
  object GetGroupsForCapacityReservationPaginated
      extends Effect[
        GetGroupsForCapacityReservationRequest,
        AwsError,
        zio.aws.ec2.model.GetGroupsForCapacityReservationResponse.ReadOnly
      ]
  object DisableEbsEncryptionByDefault
      extends Effect[
        DisableEbsEncryptionByDefaultRequest,
        AwsError,
        zio.aws.ec2.model.DisableEbsEncryptionByDefaultResponse.ReadOnly
      ]
  object CreateTransitGatewayPeeringAttachment
      extends Effect[
        CreateTransitGatewayPeeringAttachmentRequest,
        AwsError,
        zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentResponse.ReadOnly
      ]
  object DescribeVpnGateways
      extends Effect[
        DescribeVpnGatewaysRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVpnGatewaysResponse.ReadOnly
      ]
  object DeprovisionByoipCidr
      extends Effect[
        DeprovisionByoipCidrRequest,
        AwsError,
        zio.aws.ec2.model.DeprovisionByoipCidrResponse.ReadOnly
      ]
  object DescribeSubnets
      extends Stream[
        DescribeSubnetsRequest,
        AwsError,
        zio.aws.ec2.model.Subnet.ReadOnly
      ]
  object DescribeSubnetsPaginated
      extends Effect[
        DescribeSubnetsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeSubnetsResponse.ReadOnly
      ]
  object DescribeSpotFleetRequestHistory
      extends Effect[
        DescribeSpotFleetRequestHistoryRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.ReadOnly,
          zio.aws.ec2.model.HistoryRecord.ReadOnly
        ]
      ]
  object DescribeSpotFleetRequestHistoryPaginated
      extends Effect[
        DescribeSpotFleetRequestHistoryRequest,
        AwsError,
        zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.ReadOnly
      ]
  object UnmonitorInstances
      extends Effect[
        UnmonitorInstancesRequest,
        AwsError,
        zio.aws.ec2.model.UnmonitorInstancesResponse.ReadOnly
      ]
  object CreateManagedPrefixList
      extends Effect[
        CreateManagedPrefixListRequest,
        AwsError,
        zio.aws.ec2.model.CreateManagedPrefixListResponse.ReadOnly
      ]
  object DescribeTransitGatewayConnectPeers
      extends Stream[
        DescribeTransitGatewayConnectPeersRequest,
        AwsError,
        zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly
      ]
  object DescribeTransitGatewayConnectPeersPaginated
      extends Effect[
        DescribeTransitGatewayConnectPeersRequest,
        AwsError,
        zio.aws.ec2.model.DescribeTransitGatewayConnectPeersResponse.ReadOnly
      ]
  object DescribeTransitGatewayConnects
      extends Stream[
        DescribeTransitGatewayConnectsRequest,
        AwsError,
        zio.aws.ec2.model.TransitGatewayConnect.ReadOnly
      ]
  object DescribeTransitGatewayConnectsPaginated
      extends Effect[
        DescribeTransitGatewayConnectsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeTransitGatewayConnectsResponse.ReadOnly
      ]
  object CreateIpamScope
      extends Effect[
        CreateIpamScopeRequest,
        AwsError,
        zio.aws.ec2.model.CreateIpamScopeResponse.ReadOnly
      ]
  object DescribeTrafficMirrorTargets
      extends Stream[
        DescribeTrafficMirrorTargetsRequest,
        AwsError,
        zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly
      ]
  object DescribeTrafficMirrorTargetsPaginated
      extends Effect[
        DescribeTrafficMirrorTargetsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeTrafficMirrorTargetsResponse.ReadOnly
      ]
  object DeleteVpcEndpoints
      extends Effect[
        DeleteVpcEndpointsRequest,
        AwsError,
        zio.aws.ec2.model.DeleteVpcEndpointsResponse.ReadOnly
      ]
  object DisassociateIamInstanceProfile
      extends Effect[
        DisassociateIamInstanceProfileRequest,
        AwsError,
        zio.aws.ec2.model.DisassociateIamInstanceProfileResponse.ReadOnly
      ]
  object ModifyFleet
      extends Effect[
        ModifyFleetRequest,
        AwsError,
        zio.aws.ec2.model.ModifyFleetResponse.ReadOnly
      ]
  object DescribeVpcEndpointServiceConfigurations
      extends Stream[
        DescribeVpcEndpointServiceConfigurationsRequest,
        AwsError,
        zio.aws.ec2.model.ServiceConfiguration.ReadOnly
      ]
  object DescribeVpcEndpointServiceConfigurationsPaginated
      extends Effect[
        DescribeVpcEndpointServiceConfigurationsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse.ReadOnly
      ]
  object ModifyVpcEndpointServicePayerResponsibility
      extends Effect[
        ModifyVpcEndpointServicePayerResponsibilityRequest,
        AwsError,
        zio.aws.ec2.model.ModifyVpcEndpointServicePayerResponsibilityResponse.ReadOnly
      ]
  object DeleteNetworkAclEntry
      extends Effect[DeleteNetworkAclEntryRequest, AwsError, Unit]
  object UpdateSecurityGroupRuleDescriptionsIngress
      extends Effect[
        UpdateSecurityGroupRuleDescriptionsIngressRequest,
        AwsError,
        zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressResponse.ReadOnly
      ]
  object DescribeCapacityReservations
      extends Stream[
        DescribeCapacityReservationsRequest,
        AwsError,
        zio.aws.ec2.model.CapacityReservation.ReadOnly
      ]
  object DescribeCapacityReservationsPaginated
      extends Effect[
        DescribeCapacityReservationsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeCapacityReservationsResponse.ReadOnly
      ]
  object CreateTransitGatewayMulticastDomain
      extends Effect[
        CreateTransitGatewayMulticastDomainRequest,
        AwsError,
        zio.aws.ec2.model.CreateTransitGatewayMulticastDomainResponse.ReadOnly
      ]
  object StartVpcEndpointServicePrivateDnsVerification
      extends Effect[
        StartVpcEndpointServicePrivateDnsVerificationRequest,
        AwsError,
        zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse.ReadOnly
      ]
  object CreateLaunchTemplate
      extends Effect[
        CreateLaunchTemplateRequest,
        AwsError,
        zio.aws.ec2.model.CreateLaunchTemplateResponse.ReadOnly
      ]
  object DeleteTrafficMirrorFilter
      extends Effect[
        DeleteTrafficMirrorFilterRequest,
        AwsError,
        zio.aws.ec2.model.DeleteTrafficMirrorFilterResponse.ReadOnly
      ]
  object DescribeLocalGatewayRouteTables
      extends Stream[
        DescribeLocalGatewayRouteTablesRequest,
        AwsError,
        zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly
      ]
  object DescribeLocalGatewayRouteTablesPaginated
      extends Effect[
        DescribeLocalGatewayRouteTablesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse.ReadOnly
      ]
  object DescribeNetworkInterfaceAttribute
      extends Effect[
        DescribeNetworkInterfaceAttributeRequest,
        AwsError,
        zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse.ReadOnly
      ]
  object CreateCapacityReservationFleet
      extends Effect[
        CreateCapacityReservationFleetRequest,
        AwsError,
        zio.aws.ec2.model.CreateCapacityReservationFleetResponse.ReadOnly
      ]
  object DeleteLaunchTemplate
      extends Effect[
        DeleteLaunchTemplateRequest,
        AwsError,
        zio.aws.ec2.model.DeleteLaunchTemplateResponse.ReadOnly
      ]
  object ReplaceNetworkAclAssociation
      extends Effect[
        ReplaceNetworkAclAssociationRequest,
        AwsError,
        zio.aws.ec2.model.ReplaceNetworkAclAssociationResponse.ReadOnly
      ]
  object GetManagedPrefixListAssociations
      extends Stream[
        GetManagedPrefixListAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.PrefixListAssociation.ReadOnly
      ]
  object GetManagedPrefixListAssociationsPaginated
      extends Effect[
        GetManagedPrefixListAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse.ReadOnly
      ]
  object CreateNetworkAcl
      extends Effect[
        CreateNetworkAclRequest,
        AwsError,
        zio.aws.ec2.model.CreateNetworkAclResponse.ReadOnly
      ]
  object DescribeVpcEndpointConnections
      extends Stream[
        DescribeVpcEndpointConnectionsRequest,
        AwsError,
        zio.aws.ec2.model.VpcEndpointConnection.ReadOnly
      ]
  object DescribeVpcEndpointConnectionsPaginated
      extends Effect[
        DescribeVpcEndpointConnectionsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVpcEndpointConnectionsResponse.ReadOnly
      ]
  object CreateLocalGatewayRouteTableVpcAssociation
      extends Effect[
        CreateLocalGatewayRouteTableVpcAssociationRequest,
        AwsError,
        zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse.ReadOnly
      ]
  object DescribeVpcAttribute
      extends Effect[
        DescribeVpcAttributeRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVpcAttributeResponse.ReadOnly
      ]
  object DescribeStoreImageTasks
      extends Stream[
        DescribeStoreImageTasksRequest,
        AwsError,
        zio.aws.ec2.model.StoreImageTaskResult.ReadOnly
      ]
  object DescribeStoreImageTasksPaginated
      extends Effect[
        DescribeStoreImageTasksRequest,
        AwsError,
        zio.aws.ec2.model.DescribeStoreImageTasksResponse.ReadOnly
      ]
  object DescribeFastSnapshotRestores
      extends Stream[
        DescribeFastSnapshotRestoresRequest,
        AwsError,
        zio.aws.ec2.model.DescribeFastSnapshotRestoreSuccessItem.ReadOnly
      ]
  object DescribeFastSnapshotRestoresPaginated
      extends Effect[
        DescribeFastSnapshotRestoresRequest,
        AwsError,
        zio.aws.ec2.model.DescribeFastSnapshotRestoresResponse.ReadOnly
      ]
  object ModifyInstancePlacement
      extends Effect[
        ModifyInstancePlacementRequest,
        AwsError,
        zio.aws.ec2.model.ModifyInstancePlacementResponse.ReadOnly
      ]
  object CreateIpamPool
      extends Effect[
        CreateIpamPoolRequest,
        AwsError,
        zio.aws.ec2.model.CreateIpamPoolResponse.ReadOnly
      ]
  object ModifySnapshotTier
      extends Effect[
        ModifySnapshotTierRequest,
        AwsError,
        zio.aws.ec2.model.ModifySnapshotTierResponse.ReadOnly
      ]
  object DescribeSpotFleetRequests
      extends Stream[
        DescribeSpotFleetRequestsRequest,
        AwsError,
        zio.aws.ec2.model.SpotFleetRequestConfig.ReadOnly
      ]
  object DescribeSpotFleetRequestsPaginated
      extends Effect[
        DescribeSpotFleetRequestsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeSpotFleetRequestsResponse.ReadOnly
      ]
  object GetTransitGatewayRouteTableAssociations
      extends Stream[
        GetTransitGatewayRouteTableAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.TransitGatewayRouteTableAssociation.ReadOnly
      ]
  object GetTransitGatewayRouteTableAssociationsPaginated
      extends Effect[
        GetTransitGatewayRouteTableAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsResponse.ReadOnly
      ]
  object ReleaseIpamPoolAllocation
      extends Effect[
        ReleaseIpamPoolAllocationRequest,
        AwsError,
        zio.aws.ec2.model.ReleaseIpamPoolAllocationResponse.ReadOnly
      ]
  object RegisterImage
      extends Effect[
        RegisterImageRequest,
        AwsError,
        zio.aws.ec2.model.RegisterImageResponse.ReadOnly
      ]
  object CreateDhcpOptions
      extends Effect[
        CreateDhcpOptionsRequest,
        AwsError,
        zio.aws.ec2.model.CreateDhcpOptionsResponse.ReadOnly
      ]
  object DescribeReservedInstancesModifications
      extends Stream[
        DescribeReservedInstancesModificationsRequest,
        AwsError,
        zio.aws.ec2.model.ReservedInstancesModification.ReadOnly
      ]
  object DescribeReservedInstancesModificationsPaginated
      extends Effect[
        DescribeReservedInstancesModificationsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeReservedInstancesModificationsResponse.ReadOnly
      ]
  object DescribeSpotDatafeedSubscription
      extends Effect[
        DescribeSpotDatafeedSubscriptionRequest,
        AwsError,
        zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionResponse.ReadOnly
      ]
  object DescribeNetworkInsightsAccessScopeAnalyses
      extends Stream[
        DescribeNetworkInsightsAccessScopeAnalysesRequest,
        AwsError,
        zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly
      ]
  object DescribeNetworkInsightsAccessScopeAnalysesPaginated
      extends Effect[
        DescribeNetworkInsightsAccessScopeAnalysesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse.ReadOnly
      ]
  object CreateTrafficMirrorFilterRule
      extends Effect[
        CreateTrafficMirrorFilterRuleRequest,
        AwsError,
        zio.aws.ec2.model.CreateTrafficMirrorFilterRuleResponse.ReadOnly
      ]
  object SearchLocalGatewayRoutes
      extends Stream[
        SearchLocalGatewayRoutesRequest,
        AwsError,
        zio.aws.ec2.model.LocalGatewayRoute.ReadOnly
      ]
  object SearchLocalGatewayRoutesPaginated
      extends Effect[
        SearchLocalGatewayRoutesRequest,
        AwsError,
        zio.aws.ec2.model.SearchLocalGatewayRoutesResponse.ReadOnly
      ]
  object DescribeHostReservationOfferings
      extends Stream[
        DescribeHostReservationOfferingsRequest,
        AwsError,
        zio.aws.ec2.model.HostOffering.ReadOnly
      ]
  object DescribeHostReservationOfferingsPaginated
      extends Effect[
        DescribeHostReservationOfferingsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeHostReservationOfferingsResponse.ReadOnly
      ]
  object ModifyIpam
      extends Effect[
        ModifyIpamRequest,
        AwsError,
        zio.aws.ec2.model.ModifyIpamResponse.ReadOnly
      ]
  object DisableVpcClassicLink
      extends Effect[
        DisableVpcClassicLinkRequest,
        AwsError,
        zio.aws.ec2.model.DisableVpcClassicLinkResponse.ReadOnly
      ]
  object GetNetworkInsightsAccessScopeContent
      extends Effect[
        GetNetworkInsightsAccessScopeContentRequest,
        AwsError,
        zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentResponse.ReadOnly
      ]
  object CreateCapacityReservation
      extends Effect[
        CreateCapacityReservationRequest,
        AwsError,
        zio.aws.ec2.model.CreateCapacityReservationResponse.ReadOnly
      ]
  object ModifyAddressAttribute
      extends Effect[
        ModifyAddressAttributeRequest,
        AwsError,
        zio.aws.ec2.model.ModifyAddressAttributeResponse.ReadOnly
      ]
  object CreateNetworkInterfacePermission
      extends Effect[
        CreateNetworkInterfacePermissionRequest,
        AwsError,
        zio.aws.ec2.model.CreateNetworkInterfacePermissionResponse.ReadOnly
      ]
  object DescribeLaunchTemplateVersions
      extends Stream[
        DescribeLaunchTemplateVersionsRequest,
        AwsError,
        zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly
      ]
  object DescribeLaunchTemplateVersionsPaginated
      extends Effect[
        DescribeLaunchTemplateVersionsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeLaunchTemplateVersionsResponse.ReadOnly
      ]
  object AllocateHosts
      extends Effect[
        AllocateHostsRequest,
        AwsError,
        zio.aws.ec2.model.AllocateHostsResponse.ReadOnly
      ]
  object DescribeExportImageTasks
      extends Stream[
        DescribeExportImageTasksRequest,
        AwsError,
        zio.aws.ec2.model.ExportImageTask.ReadOnly
      ]
  object DescribeExportImageTasksPaginated
      extends Effect[
        DescribeExportImageTasksRequest,
        AwsError,
        zio.aws.ec2.model.DescribeExportImageTasksResponse.ReadOnly
      ]
  object DescribeSpotFleetInstances
      extends Effect[
        DescribeSpotFleetInstancesRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.ReadOnly,
          zio.aws.ec2.model.ActiveInstance.ReadOnly
        ]
      ]
  object DescribeSpotFleetInstancesPaginated
      extends Effect[
        DescribeSpotFleetInstancesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.ReadOnly
      ]
  object RejectTransitGatewayVpcAttachment
      extends Effect[
        RejectTransitGatewayVpcAttachmentRequest,
        AwsError,
        zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentResponse.ReadOnly
      ]
  object DescribeByoipCidrs
      extends Stream[
        DescribeByoipCidrsRequest,
        AwsError,
        zio.aws.ec2.model.ByoipCidr.ReadOnly
      ]
  object DescribeByoipCidrsPaginated
      extends Effect[
        DescribeByoipCidrsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeByoipCidrsResponse.ReadOnly
      ]
  object MoveAddressToVpc
      extends Effect[
        MoveAddressToVpcRequest,
        AwsError,
        zio.aws.ec2.model.MoveAddressToVpcResponse.ReadOnly
      ]
  object DisassociateAddress
      extends Effect[DisassociateAddressRequest, AwsError, Unit]
  object ResetFpgaImageAttribute
      extends Effect[
        ResetFpgaImageAttributeRequest,
        AwsError,
        zio.aws.ec2.model.ResetFpgaImageAttributeResponse.ReadOnly
      ]
  object ModifyImageAttribute
      extends Effect[ModifyImageAttributeRequest, AwsError, Unit]
  object RestoreSnapshotFromRecycleBin
      extends Effect[
        RestoreSnapshotFromRecycleBinRequest,
        AwsError,
        zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse.ReadOnly
      ]
  object ExportClientVpnClientConfiguration
      extends Effect[
        ExportClientVpnClientConfigurationRequest,
        AwsError,
        zio.aws.ec2.model.ExportClientVpnClientConfigurationResponse.ReadOnly
      ]
  object RestoreSnapshotTier
      extends Effect[
        RestoreSnapshotTierRequest,
        AwsError,
        zio.aws.ec2.model.RestoreSnapshotTierResponse.ReadOnly
      ]
  object RegisterTransitGatewayMulticastGroupSources
      extends Effect[
        RegisterTransitGatewayMulticastGroupSourcesRequest,
        AwsError,
        zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly
      ]
  object DeleteNetworkInterface
      extends Effect[DeleteNetworkInterfaceRequest, AwsError, Unit]
  object ProvisionPublicIpv4PoolCidr
      extends Effect[
        ProvisionPublicIpv4PoolCidrRequest,
        AwsError,
        zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrResponse.ReadOnly
      ]
  object DescribeVolumes
      extends Stream[
        DescribeVolumesRequest,
        AwsError,
        zio.aws.ec2.model.Volume.ReadOnly
      ]
  object DescribeVolumesPaginated
      extends Effect[
        DescribeVolumesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVolumesResponse.ReadOnly
      ]
  object ModifyTransitGatewayPrefixListReference
      extends Effect[
        ModifyTransitGatewayPrefixListReferenceRequest,
        AwsError,
        zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse.ReadOnly
      ]
  object CreateFlowLogs
      extends Effect[
        CreateFlowLogsRequest,
        AwsError,
        zio.aws.ec2.model.CreateFlowLogsResponse.ReadOnly
      ]
  object ModifyIpamScope
      extends Effect[
        ModifyIpamScopeRequest,
        AwsError,
        zio.aws.ec2.model.ModifyIpamScopeResponse.ReadOnly
      ]
  object PurchaseHostReservation
      extends Effect[
        PurchaseHostReservationRequest,
        AwsError,
        zio.aws.ec2.model.PurchaseHostReservationResponse.ReadOnly
      ]
  object DescribeStaleSecurityGroups
      extends Stream[
        DescribeStaleSecurityGroupsRequest,
        AwsError,
        zio.aws.ec2.model.StaleSecurityGroup.ReadOnly
      ]
  object DescribeStaleSecurityGroupsPaginated
      extends Effect[
        DescribeStaleSecurityGroupsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeStaleSecurityGroupsResponse.ReadOnly
      ]
  object CreateVolume
      extends Effect[
        CreateVolumeRequest,
        AwsError,
        zio.aws.ec2.model.CreateVolumeResponse.ReadOnly
      ]
  object RunInstances
      extends Effect[
        RunInstancesRequest,
        AwsError,
        zio.aws.ec2.model.RunInstancesResponse.ReadOnly
      ]
  object DescribeReplaceRootVolumeTasks
      extends Stream[
        DescribeReplaceRootVolumeTasksRequest,
        AwsError,
        zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly
      ]
  object DescribeReplaceRootVolumeTasksPaginated
      extends Effect[
        DescribeReplaceRootVolumeTasksRequest,
        AwsError,
        zio.aws.ec2.model.DescribeReplaceRootVolumeTasksResponse.ReadOnly
      ]
  object AssociateDhcpOptions
      extends Effect[AssociateDhcpOptionsRequest, AwsError, Unit]
  object CreateRouteTable
      extends Effect[
        CreateRouteTableRequest,
        AwsError,
        zio.aws.ec2.model.CreateRouteTableResponse.ReadOnly
      ]
  object DeleteVpcPeeringConnection
      extends Effect[
        DeleteVpcPeeringConnectionRequest,
        AwsError,
        zio.aws.ec2.model.DeleteVpcPeeringConnectionResponse.ReadOnly
      ]
  object DescribePublicIpv4Pools
      extends Stream[
        DescribePublicIpv4PoolsRequest,
        AwsError,
        zio.aws.ec2.model.PublicIpv4Pool.ReadOnly
      ]
  object DescribePublicIpv4PoolsPaginated
      extends Effect[
        DescribePublicIpv4PoolsRequest,
        AwsError,
        zio.aws.ec2.model.DescribePublicIpv4PoolsResponse.ReadOnly
      ]
  object ModifyAvailabilityZoneGroup
      extends Effect[
        ModifyAvailabilityZoneGroupRequest,
        AwsError,
        zio.aws.ec2.model.ModifyAvailabilityZoneGroupResponse.ReadOnly
      ]
  object CreateClientVpnEndpoint
      extends Effect[
        CreateClientVpnEndpointRequest,
        AwsError,
        zio.aws.ec2.model.CreateClientVpnEndpointResponse.ReadOnly
      ]
  object DeleteSnapshot extends Effect[DeleteSnapshotRequest, AwsError, Unit]
  object CreateTrafficMirrorFilter
      extends Effect[
        CreateTrafficMirrorFilterRequest,
        AwsError,
        zio.aws.ec2.model.CreateTrafficMirrorFilterResponse.ReadOnly
      ]
  object CreateReservedInstancesListing
      extends Effect[
        CreateReservedInstancesListingRequest,
        AwsError,
        zio.aws.ec2.model.CreateReservedInstancesListingResponse.ReadOnly
      ]
  object AssignIpv6Addresses
      extends Effect[
        AssignIpv6AddressesRequest,
        AwsError,
        zio.aws.ec2.model.AssignIpv6AddressesResponse.ReadOnly
      ]
  object GetVpnConnectionDeviceTypes
      extends Stream[
        GetVpnConnectionDeviceTypesRequest,
        AwsError,
        zio.aws.ec2.model.VpnConnectionDeviceType.ReadOnly
      ]
  object GetVpnConnectionDeviceTypesPaginated
      extends Effect[
        GetVpnConnectionDeviceTypesRequest,
        AwsError,
        zio.aws.ec2.model.GetVpnConnectionDeviceTypesResponse.ReadOnly
      ]
  object DescribeSecurityGroupReferences
      extends Effect[
        DescribeSecurityGroupReferencesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeSecurityGroupReferencesResponse.ReadOnly
      ]
  object DescribeImages
      extends Effect[
        DescribeImagesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeImagesResponse.ReadOnly
      ]
  object RequestSpotFleet
      extends Effect[
        RequestSpotFleetRequest,
        AwsError,
        zio.aws.ec2.model.RequestSpotFleetResponse.ReadOnly
      ]
  object AcceptTransitGatewayMulticastDomainAssociations
      extends Effect[
        AcceptTransitGatewayMulticastDomainAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
      ]
  object DeletePublicIpv4Pool
      extends Effect[
        DeletePublicIpv4PoolRequest,
        AwsError,
        zio.aws.ec2.model.DeletePublicIpv4PoolResponse.ReadOnly
      ]
  object UpdateSecurityGroupRuleDescriptionsEgress
      extends Effect[
        UpdateSecurityGroupRuleDescriptionsEgressRequest,
        AwsError,
        zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse.ReadOnly
      ]
  object ReplaceRoute extends Effect[ReplaceRouteRequest, AwsError, Unit]
  object CreateNetworkInsightsPath
      extends Effect[
        CreateNetworkInsightsPathRequest,
        AwsError,
        zio.aws.ec2.model.CreateNetworkInsightsPathResponse.ReadOnly
      ]
  object DeleteQueuedReservedInstances
      extends Effect[
        DeleteQueuedReservedInstancesRequest,
        AwsError,
        zio.aws.ec2.model.DeleteQueuedReservedInstancesResponse.ReadOnly
      ]
  object DisassociateInstanceEventWindow
      extends Effect[
        DisassociateInstanceEventWindowRequest,
        AwsError,
        zio.aws.ec2.model.DisassociateInstanceEventWindowResponse.ReadOnly
      ]
  object GetConsoleOutput
      extends Effect[
        GetConsoleOutputRequest,
        AwsError,
        zio.aws.ec2.model.GetConsoleOutputResponse.ReadOnly
      ]
  object CreateStoreImageTask
      extends Effect[
        CreateStoreImageTaskRequest,
        AwsError,
        zio.aws.ec2.model.CreateStoreImageTaskResponse.ReadOnly
      ]
  object GetReservedInstancesExchangeQuote
      extends Effect[
        GetReservedInstancesExchangeQuoteRequest,
        AwsError,
        zio.aws.ec2.model.GetReservedInstancesExchangeQuoteResponse.ReadOnly
      ]
  object AttachVpnGateway
      extends Effect[
        AttachVpnGatewayRequest,
        AwsError,
        zio.aws.ec2.model.AttachVpnGatewayResponse.ReadOnly
      ]
  object ModifyVpnConnection
      extends Effect[
        ModifyVpnConnectionRequest,
        AwsError,
        zio.aws.ec2.model.ModifyVpnConnectionResponse.ReadOnly
      ]
  object GetDefaultCreditSpecification
      extends Effect[
        GetDefaultCreditSpecificationRequest,
        AwsError,
        zio.aws.ec2.model.GetDefaultCreditSpecificationResponse.ReadOnly
      ]
  object CreateImage
      extends Effect[
        CreateImageRequest,
        AwsError,
        zio.aws.ec2.model.CreateImageResponse.ReadOnly
      ]
  object DisableTransitGatewayRouteTablePropagation
      extends Effect[
        DisableTransitGatewayRouteTablePropagationRequest,
        AwsError,
        zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationResponse.ReadOnly
      ]
  object CreateFleet
      extends Effect[
        CreateFleetRequest,
        AwsError,
        zio.aws.ec2.model.CreateFleetResponse.ReadOnly
      ]
  object CreateSubnet
      extends Effect[
        CreateSubnetRequest,
        AwsError,
        zio.aws.ec2.model.CreateSubnetResponse.ReadOnly
      ]
  object ListSnapshotsInRecycleBin
      extends Stream[
        ListSnapshotsInRecycleBinRequest,
        AwsError,
        zio.aws.ec2.model.SnapshotRecycleBinInfo.ReadOnly
      ]
  object ListSnapshotsInRecycleBinPaginated
      extends Effect[
        ListSnapshotsInRecycleBinRequest,
        AwsError,
        zio.aws.ec2.model.ListSnapshotsInRecycleBinResponse.ReadOnly
      ]
  object DescribeAggregateIdFormat
      extends Effect[
        DescribeAggregateIdFormatRequest,
        AwsError,
        zio.aws.ec2.model.DescribeAggregateIdFormatResponse.ReadOnly
      ]
  object CreateNetworkInsightsAccessScope
      extends Effect[
        CreateNetworkInsightsAccessScopeRequest,
        AwsError,
        zio.aws.ec2.model.CreateNetworkInsightsAccessScopeResponse.ReadOnly
      ]
  object ModifySpotFleetRequest
      extends Effect[
        ModifySpotFleetRequestRequest,
        AwsError,
        zio.aws.ec2.model.ModifySpotFleetRequestResponse.ReadOnly
      ]
  object ModifyCapacityReservationFleet
      extends Effect[
        ModifyCapacityReservationFleetRequest,
        AwsError,
        zio.aws.ec2.model.ModifyCapacityReservationFleetResponse.ReadOnly
      ]
  object DescribeIpv6Pools
      extends Stream[
        DescribeIpv6PoolsRequest,
        AwsError,
        zio.aws.ec2.model.Ipv6Pool.ReadOnly
      ]
  object DescribeIpv6PoolsPaginated
      extends Effect[
        DescribeIpv6PoolsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeIpv6PoolsResponse.ReadOnly
      ]
  object StopInstances
      extends Effect[
        StopInstancesRequest,
        AwsError,
        zio.aws.ec2.model.StopInstancesResponse.ReadOnly
      ]
  object DescribeExportTasks
      extends Effect[
        DescribeExportTasksRequest,
        AwsError,
        zio.aws.ec2.model.DescribeExportTasksResponse.ReadOnly
      ]
  object RestoreManagedPrefixListVersion
      extends Effect[
        RestoreManagedPrefixListVersionRequest,
        AwsError,
        zio.aws.ec2.model.RestoreManagedPrefixListVersionResponse.ReadOnly
      ]
  object DescribeBundleTasks
      extends Effect[
        DescribeBundleTasksRequest,
        AwsError,
        zio.aws.ec2.model.DescribeBundleTasksResponse.ReadOnly
      ]
  object DescribeClientVpnRoutes
      extends Stream[
        DescribeClientVpnRoutesRequest,
        AwsError,
        zio.aws.ec2.model.ClientVpnRoute.ReadOnly
      ]
  object DescribeClientVpnRoutesPaginated
      extends Effect[
        DescribeClientVpnRoutesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeClientVpnRoutesResponse.ReadOnly
      ]
  object DescribeIamInstanceProfileAssociations
      extends Stream[
        DescribeIamInstanceProfileAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly
      ]
  object DescribeIamInstanceProfileAssociationsPaginated
      extends Effect[
        DescribeIamInstanceProfileAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse.ReadOnly
      ]
  object DeleteIpam
      extends Effect[
        DeleteIpamRequest,
        AwsError,
        zio.aws.ec2.model.DeleteIpamResponse.ReadOnly
      ]
  object AttachVolume
      extends Effect[
        AttachVolumeRequest,
        AwsError,
        zio.aws.ec2.model.AttachVolumeResponse.ReadOnly
      ]
  object CreateClientVpnRoute
      extends Effect[
        CreateClientVpnRouteRequest,
        AwsError,
        zio.aws.ec2.model.CreateClientVpnRouteResponse.ReadOnly
      ]
  object AcceptTransitGatewayPeeringAttachment
      extends Effect[
        AcceptTransitGatewayPeeringAttachmentRequest,
        AwsError,
        zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse.ReadOnly
      ]
  object DescribeNetworkInterfaces
      extends Stream[
        DescribeNetworkInterfacesRequest,
        AwsError,
        zio.aws.ec2.model.NetworkInterface.ReadOnly
      ]
  object DescribeNetworkInterfacesPaginated
      extends Effect[
        DescribeNetworkInterfacesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeNetworkInterfacesResponse.ReadOnly
      ]
  object DescribeLocalGatewayVirtualInterfaceGroups
      extends Stream[
        DescribeLocalGatewayVirtualInterfaceGroupsRequest,
        AwsError,
        zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup.ReadOnly
      ]
  object DescribeLocalGatewayVirtualInterfaceGroupsPaginated
      extends Effect[
        DescribeLocalGatewayVirtualInterfaceGroupsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse.ReadOnly
      ]
  object GetInstanceUefiData
      extends Effect[
        GetInstanceUefiDataRequest,
        AwsError,
        zio.aws.ec2.model.GetInstanceUefiDataResponse.ReadOnly
      ]
  object ModifyTrafficMirrorSession
      extends Effect[
        ModifyTrafficMirrorSessionRequest,
        AwsError,
        zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse.ReadOnly
      ]
  object DisassociateVpcCidrBlock
      extends Effect[
        DisassociateVpcCidrBlockRequest,
        AwsError,
        zio.aws.ec2.model.DisassociateVpcCidrBlockResponse.ReadOnly
      ]
  object DisableVpcClassicLinkDnsSupport
      extends Effect[
        DisableVpcClassicLinkDnsSupportRequest,
        AwsError,
        zio.aws.ec2.model.DisableVpcClassicLinkDnsSupportResponse.ReadOnly
      ]
  object DeleteClientVpnRoute
      extends Effect[
        DeleteClientVpnRouteRequest,
        AwsError,
        zio.aws.ec2.model.DeleteClientVpnRouteResponse.ReadOnly
      ]
  object CreateTransitGatewayConnect
      extends Effect[
        CreateTransitGatewayConnectRequest,
        AwsError,
        zio.aws.ec2.model.CreateTransitGatewayConnectResponse.ReadOnly
      ]
  object CreateReplaceRootVolumeTask
      extends Effect[
        CreateReplaceRootVolumeTaskRequest,
        AwsError,
        zio.aws.ec2.model.CreateReplaceRootVolumeTaskResponse.ReadOnly
      ]
  object CancelImportTask
      extends Effect[
        CancelImportTaskRequest,
        AwsError,
        zio.aws.ec2.model.CancelImportTaskResponse.ReadOnly
      ]
  object DescribeVpcClassicLink
      extends Effect[
        DescribeVpcClassicLinkRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVpcClassicLinkResponse.ReadOnly
      ]
  object ModifyHosts
      extends Effect[
        ModifyHostsRequest,
        AwsError,
        zio.aws.ec2.model.ModifyHostsResponse.ReadOnly
      ]
  object CreateRestoreImageTask
      extends Effect[
        CreateRestoreImageTaskRequest,
        AwsError,
        zio.aws.ec2.model.CreateRestoreImageTaskResponse.ReadOnly
      ]
  object DescribeTransitGatewayAttachments
      extends Stream[
        DescribeTransitGatewayAttachmentsRequest,
        AwsError,
        zio.aws.ec2.model.TransitGatewayAttachment.ReadOnly
      ]
  object DescribeTransitGatewayAttachmentsPaginated
      extends Effect[
        DescribeTransitGatewayAttachmentsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeTransitGatewayAttachmentsResponse.ReadOnly
      ]
  object DeleteVpcEndpointServiceConfigurations
      extends Effect[
        DeleteVpcEndpointServiceConfigurationsRequest,
        AwsError,
        zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsResponse.ReadOnly
      ]
  object StartNetworkInsightsAccessScopeAnalysis
      extends Effect[
        StartNetworkInsightsAccessScopeAnalysisRequest,
        AwsError,
        zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse.ReadOnly
      ]
  object DescribeTransitGatewayMulticastDomains
      extends Stream[
        DescribeTransitGatewayMulticastDomainsRequest,
        AwsError,
        zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly
      ]
  object DescribeTransitGatewayMulticastDomainsPaginated
      extends Effect[
        DescribeTransitGatewayMulticastDomainsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsResponse.ReadOnly
      ]
  object ImportKeyPair
      extends Effect[
        ImportKeyPairRequest,
        AwsError,
        zio.aws.ec2.model.ImportKeyPairResponse.ReadOnly
      ]
  object RevokeSecurityGroupEgress
      extends Effect[
        RevokeSecurityGroupEgressRequest,
        AwsError,
        zio.aws.ec2.model.RevokeSecurityGroupEgressResponse.ReadOnly
      ]
  object EnableVgwRoutePropagation
      extends Effect[EnableVgwRoutePropagationRequest, AwsError, Unit]
  object CreateTransitGatewayRoute
      extends Effect[
        CreateTransitGatewayRouteRequest,
        AwsError,
        zio.aws.ec2.model.CreateTransitGatewayRouteResponse.ReadOnly
      ]
  object AcceptReservedInstancesExchangeQuote
      extends Effect[
        AcceptReservedInstancesExchangeQuoteRequest,
        AwsError,
        zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteResponse.ReadOnly
      ]
  object ModifyInstanceAttribute
      extends Effect[ModifyInstanceAttributeRequest, AwsError, Unit]
  object DeleteTransitGatewayConnectPeer
      extends Effect[
        DeleteTransitGatewayConnectPeerRequest,
        AwsError,
        zio.aws.ec2.model.DeleteTransitGatewayConnectPeerResponse.ReadOnly
      ]
  object CreateIpam
      extends Effect[
        CreateIpamRequest,
        AwsError,
        zio.aws.ec2.model.CreateIpamResponse.ReadOnly
      ]
  object GetConsoleScreenshot
      extends Effect[
        GetConsoleScreenshotRequest,
        AwsError,
        zio.aws.ec2.model.GetConsoleScreenshotResponse.ReadOnly
      ]
  object DeregisterTransitGatewayMulticastGroupMembers
      extends Effect[
        DeregisterTransitGatewayMulticastGroupMembersRequest,
        AwsError,
        zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse.ReadOnly
      ]
  object DescribeNetworkInterfacePermissions
      extends Stream[
        DescribeNetworkInterfacePermissionsRequest,
        AwsError,
        zio.aws.ec2.model.NetworkInterfacePermission.ReadOnly
      ]
  object DescribeNetworkInterfacePermissionsPaginated
      extends Effect[
        DescribeNetworkInterfacePermissionsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeNetworkInterfacePermissionsResponse.ReadOnly
      ]
  object CreateTransitGatewayPrefixListReference
      extends Effect[
        CreateTransitGatewayPrefixListReferenceRequest,
        AwsError,
        zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceResponse.ReadOnly
      ]
  object CancelCapacityReservation
      extends Effect[
        CancelCapacityReservationRequest,
        AwsError,
        zio.aws.ec2.model.CancelCapacityReservationResponse.ReadOnly
      ]
  object GetIpamAddressHistory
      extends Stream[
        GetIpamAddressHistoryRequest,
        AwsError,
        zio.aws.ec2.model.IpamAddressHistoryRecord.ReadOnly
      ]
  object GetIpamAddressHistoryPaginated
      extends Effect[
        GetIpamAddressHistoryRequest,
        AwsError,
        zio.aws.ec2.model.GetIpamAddressHistoryResponse.ReadOnly
      ]
  object DescribePlacementGroups
      extends Effect[
        DescribePlacementGroupsRequest,
        AwsError,
        zio.aws.ec2.model.DescribePlacementGroupsResponse.ReadOnly
      ]
  object DetachVpnGateway
      extends Effect[DetachVpnGatewayRequest, AwsError, Unit]
  object DescribeInternetGateways
      extends Stream[
        DescribeInternetGatewaysRequest,
        AwsError,
        zio.aws.ec2.model.InternetGateway.ReadOnly
      ]
  object DescribeInternetGatewaysPaginated
      extends Effect[
        DescribeInternetGatewaysRequest,
        AwsError,
        zio.aws.ec2.model.DescribeInternetGatewaysResponse.ReadOnly
      ]
  object DisassociateEnclaveCertificateIamRole
      extends Effect[
        DisassociateEnclaveCertificateIamRoleRequest,
        AwsError,
        zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleResponse.ReadOnly
      ]
  object ModifyTrafficMirrorFilterRule
      extends Effect[
        ModifyTrafficMirrorFilterRuleRequest,
        AwsError,
        zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleResponse.ReadOnly
      ]
  object ModifyVpcEndpointServicePermissions
      extends Effect[
        ModifyVpcEndpointServicePermissionsRequest,
        AwsError,
        zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsResponse.ReadOnly
      ]
  object CreateKeyPair
      extends Effect[
        CreateKeyPairRequest,
        AwsError,
        zio.aws.ec2.model.CreateKeyPairResponse.ReadOnly
      ]
  object ReleaseAddress extends Effect[ReleaseAddressRequest, AwsError, Unit]
  object DescribeVpcEndpointConnectionNotifications
      extends Stream[
        DescribeVpcEndpointConnectionNotificationsRequest,
        AwsError,
        zio.aws.ec2.model.ConnectionNotification.ReadOnly
      ]
  object DescribeVpcEndpointConnectionNotificationsPaginated
      extends Effect[
        DescribeVpcEndpointConnectionNotificationsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse.ReadOnly
      ]
  object AssociateAddress
      extends Effect[
        AssociateAddressRequest,
        AwsError,
        zio.aws.ec2.model.AssociateAddressResponse.ReadOnly
      ]
  object DescribeTransitGateways
      extends Stream[
        DescribeTransitGatewaysRequest,
        AwsError,
        zio.aws.ec2.model.TransitGateway.ReadOnly
      ]
  object DescribeTransitGatewaysPaginated
      extends Effect[
        DescribeTransitGatewaysRequest,
        AwsError,
        zio.aws.ec2.model.DescribeTransitGatewaysResponse.ReadOnly
      ]
  object CreateCarrierGateway
      extends Effect[
        CreateCarrierGatewayRequest,
        AwsError,
        zio.aws.ec2.model.CreateCarrierGatewayResponse.ReadOnly
      ]
  object ModifyVpcEndpointServiceConfiguration
      extends Effect[
        ModifyVpcEndpointServiceConfigurationRequest,
        AwsError,
        zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationResponse.ReadOnly
      ]
  object DescribeVolumeStatus
      extends Stream[
        DescribeVolumeStatusRequest,
        AwsError,
        zio.aws.ec2.model.VolumeStatusItem.ReadOnly
      ]
  object DescribeVolumeStatusPaginated
      extends Effect[
        DescribeVolumeStatusRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVolumeStatusResponse.ReadOnly
      ]
  object DescribeTransitGatewayVpcAttachments
      extends Stream[
        DescribeTransitGatewayVpcAttachmentsRequest,
        AwsError,
        zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly
      ]
  object DescribeTransitGatewayVpcAttachmentsPaginated
      extends Effect[
        DescribeTransitGatewayVpcAttachmentsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse.ReadOnly
      ]
  object CreateVpcPeeringConnection
      extends Effect[
        CreateVpcPeeringConnectionRequest,
        AwsError,
        zio.aws.ec2.model.CreateVpcPeeringConnectionResponse.ReadOnly
      ]
  object CreateVpcEndpoint
      extends Effect[
        CreateVpcEndpointRequest,
        AwsError,
        zio.aws.ec2.model.CreateVpcEndpointResponse.ReadOnly
      ]
  object ListImagesInRecycleBin
      extends Stream[
        ListImagesInRecycleBinRequest,
        AwsError,
        zio.aws.ec2.model.ImageRecycleBinInfo.ReadOnly
      ]
  object ListImagesInRecycleBinPaginated
      extends Effect[
        ListImagesInRecycleBinRequest,
        AwsError,
        zio.aws.ec2.model.ListImagesInRecycleBinResponse.ReadOnly
      ]
  object ReplaceIamInstanceProfileAssociation
      extends Effect[
        ReplaceIamInstanceProfileAssociationRequest,
        AwsError,
        zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationResponse.ReadOnly
      ]
  object DisableVgwRoutePropagation
      extends Effect[DisableVgwRoutePropagationRequest, AwsError, Unit]
  object DescribeNetworkInsightsAccessScopes
      extends Stream[
        DescribeNetworkInsightsAccessScopesRequest,
        AwsError,
        zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly
      ]
  object DescribeNetworkInsightsAccessScopesPaginated
      extends Effect[
        DescribeNetworkInsightsAccessScopesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesResponse.ReadOnly
      ]
  object GetNetworkInsightsAccessScopeAnalysisFindings
      extends Effect[
        GetNetworkInsightsAccessScopeAnalysisFindingsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.ReadOnly,
          zio.aws.ec2.model.AccessScopeAnalysisFinding.ReadOnly
        ]
      ]
  object GetNetworkInsightsAccessScopeAnalysisFindingsPaginated
      extends Effect[
        GetNetworkInsightsAccessScopeAnalysisFindingsRequest,
        AwsError,
        zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.ReadOnly
      ]
  object CancelCapacityReservationFleets
      extends Effect[
        CancelCapacityReservationFleetsRequest,
        AwsError,
        zio.aws.ec2.model.CancelCapacityReservationFleetsResponse.ReadOnly
      ]
  object DeleteLocalGatewayRouteTableVpcAssociation
      extends Effect[
        DeleteLocalGatewayRouteTableVpcAssociationRequest,
        AwsError,
        zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationResponse.ReadOnly
      ]
  object AssociateIamInstanceProfile
      extends Effect[
        AssociateIamInstanceProfileRequest,
        AwsError,
        zio.aws.ec2.model.AssociateIamInstanceProfileResponse.ReadOnly
      ]
  object DescribeTrunkInterfaceAssociations
      extends Stream[
        DescribeTrunkInterfaceAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.TrunkInterfaceAssociation.ReadOnly
      ]
  object DescribeTrunkInterfaceAssociationsPaginated
      extends Effect[
        DescribeTrunkInterfaceAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsResponse.ReadOnly
      ]
  object StartNetworkInsightsAnalysis
      extends Effect[
        StartNetworkInsightsAnalysisRequest,
        AwsError,
        zio.aws.ec2.model.StartNetworkInsightsAnalysisResponse.ReadOnly
      ]
  object PurchaseReservedInstancesOffering
      extends Effect[
        PurchaseReservedInstancesOfferingRequest,
        AwsError,
        zio.aws.ec2.model.PurchaseReservedInstancesOfferingResponse.ReadOnly
      ]
  object ExportImage
      extends Effect[
        ExportImageRequest,
        AwsError,
        zio.aws.ec2.model.ExportImageResponse.ReadOnly
      ]
  object DescribeClientVpnConnections
      extends Stream[
        DescribeClientVpnConnectionsRequest,
        AwsError,
        zio.aws.ec2.model.ClientVpnConnection.ReadOnly
      ]
  object DescribeClientVpnConnectionsPaginated
      extends Effect[
        DescribeClientVpnConnectionsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeClientVpnConnectionsResponse.ReadOnly
      ]
  object DescribeInstanceStatus
      extends Stream[
        DescribeInstanceStatusRequest,
        AwsError,
        zio.aws.ec2.model.InstanceStatus.ReadOnly
      ]
  object DescribeInstanceStatusPaginated
      extends Effect[
        DescribeInstanceStatusRequest,
        AwsError,
        zio.aws.ec2.model.DescribeInstanceStatusResponse.ReadOnly
      ]
  object DescribeAddressesAttribute
      extends Stream[
        DescribeAddressesAttributeRequest,
        AwsError,
        zio.aws.ec2.model.AddressAttribute.ReadOnly
      ]
  object DescribeAddressesAttributePaginated
      extends Effect[
        DescribeAddressesAttributeRequest,
        AwsError,
        zio.aws.ec2.model.DescribeAddressesAttributeResponse.ReadOnly
      ]
  object AssociateRouteTable
      extends Effect[
        AssociateRouteTableRequest,
        AwsError,
        zio.aws.ec2.model.AssociateRouteTableResponse.ReadOnly
      ]
  object ProvisionIpamPoolCidr
      extends Effect[
        ProvisionIpamPoolCidrRequest,
        AwsError,
        zio.aws.ec2.model.ProvisionIpamPoolCidrResponse.ReadOnly
      ]
  object WithdrawByoipCidr
      extends Effect[
        WithdrawByoipCidrRequest,
        AwsError,
        zio.aws.ec2.model.WithdrawByoipCidrResponse.ReadOnly
      ]
  object DescribeIpamPools
      extends Stream[
        DescribeIpamPoolsRequest,
        AwsError,
        zio.aws.ec2.model.IpamPool.ReadOnly
      ]
  object DescribeIpamPoolsPaginated
      extends Effect[
        DescribeIpamPoolsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeIpamPoolsResponse.ReadOnly
      ]
  object GetAssociatedIpv6PoolCidrs
      extends Stream[
        GetAssociatedIpv6PoolCidrsRequest,
        AwsError,
        zio.aws.ec2.model.Ipv6CidrAssociation.ReadOnly
      ]
  object GetAssociatedIpv6PoolCidrsPaginated
      extends Effect[
        GetAssociatedIpv6PoolCidrsRequest,
        AwsError,
        zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsResponse.ReadOnly
      ]
  object DescribeSnapshots
      extends Stream[
        DescribeSnapshotsRequest,
        AwsError,
        zio.aws.ec2.model.Snapshot.ReadOnly
      ]
  object DescribeSnapshotsPaginated
      extends Effect[
        DescribeSnapshotsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeSnapshotsResponse.ReadOnly
      ]
  object EnableVpcClassicLinkDnsSupport
      extends Effect[
        EnableVpcClassicLinkDnsSupportRequest,
        AwsError,
        zio.aws.ec2.model.EnableVpcClassicLinkDnsSupportResponse.ReadOnly
      ]
  object CreateTrafficMirrorSession
      extends Effect[
        CreateTrafficMirrorSessionRequest,
        AwsError,
        zio.aws.ec2.model.CreateTrafficMirrorSessionResponse.ReadOnly
      ]
  object GetIpamPoolAllocations
      extends Stream[
        GetIpamPoolAllocationsRequest,
        AwsError,
        zio.aws.ec2.model.IpamPoolAllocation.ReadOnly
      ]
  object GetIpamPoolAllocationsPaginated
      extends Effect[
        GetIpamPoolAllocationsRequest,
        AwsError,
        zio.aws.ec2.model.GetIpamPoolAllocationsResponse.ReadOnly
      ]
  object DescribeCustomerGateways
      extends Effect[
        DescribeCustomerGatewaysRequest,
        AwsError,
        zio.aws.ec2.model.DescribeCustomerGatewaysResponse.ReadOnly
      ]
  object DescribeClientVpnAuthorizationRules
      extends Stream[
        DescribeClientVpnAuthorizationRulesRequest,
        AwsError,
        zio.aws.ec2.model.AuthorizationRule.ReadOnly
      ]
  object DescribeClientVpnAuthorizationRulesPaginated
      extends Effect[
        DescribeClientVpnAuthorizationRulesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesResponse.ReadOnly
      ]
  object RejectTransitGatewayMulticastDomainAssociations
      extends Effect[
        RejectTransitGatewayMulticastDomainAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
      ]
  object DeleteSubnet extends Effect[DeleteSubnetRequest, AwsError, Unit]
  object DeleteEgressOnlyInternetGateway
      extends Effect[
        DeleteEgressOnlyInternetGatewayRequest,
        AwsError,
        zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayResponse.ReadOnly
      ]
  object DeleteTrafficMirrorTarget
      extends Effect[
        DeleteTrafficMirrorTargetRequest,
        AwsError,
        zio.aws.ec2.model.DeleteTrafficMirrorTargetResponse.ReadOnly
      ]
  object DescribeInstanceAttribute
      extends Effect[
        DescribeInstanceAttributeRequest,
        AwsError,
        zio.aws.ec2.model.DescribeInstanceAttributeResponse.ReadOnly
      ]
  object DisableImageDeprecation
      extends Effect[
        DisableImageDeprecationRequest,
        AwsError,
        zio.aws.ec2.model.DisableImageDeprecationResponse.ReadOnly
      ]
  object DeleteKeyPair extends Effect[DeleteKeyPairRequest, AwsError, Unit]
  object EnableFastLaunch
      extends Effect[
        EnableFastLaunchRequest,
        AwsError,
        zio.aws.ec2.model.EnableFastLaunchResponse.ReadOnly
      ]
  object DeleteCarrierGateway
      extends Effect[
        DeleteCarrierGatewayRequest,
        AwsError,
        zio.aws.ec2.model.DeleteCarrierGatewayResponse.ReadOnly
      ]
  object DeleteTransitGatewayConnect
      extends Effect[
        DeleteTransitGatewayConnectRequest,
        AwsError,
        zio.aws.ec2.model.DeleteTransitGatewayConnectResponse.ReadOnly
      ]
  object CreateCustomerGateway
      extends Effect[
        CreateCustomerGatewayRequest,
        AwsError,
        zio.aws.ec2.model.CreateCustomerGatewayResponse.ReadOnly
      ]
  object DeleteInternetGateway
      extends Effect[DeleteInternetGatewayRequest, AwsError, Unit]
  object CreateVpnConnectionRoute
      extends Effect[CreateVpnConnectionRouteRequest, AwsError, Unit]
  object GetCapacityReservationUsage
      extends Effect[
        GetCapacityReservationUsageRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.ec2.model.GetCapacityReservationUsageResponse.ReadOnly,
          zio.aws.ec2.model.InstanceUsage.ReadOnly
        ]
      ]
  object GetCapacityReservationUsagePaginated
      extends Effect[
        GetCapacityReservationUsageRequest,
        AwsError,
        zio.aws.ec2.model.GetCapacityReservationUsageResponse.ReadOnly
      ]
  object CreatePlacementGroup
      extends Effect[
        CreatePlacementGroupRequest,
        AwsError,
        zio.aws.ec2.model.CreatePlacementGroupResponse.ReadOnly
      ]
  object ModifyNetworkInterfaceAttribute
      extends Effect[ModifyNetworkInterfaceAttributeRequest, AwsError, Unit]
  object ImportSnapshot
      extends Effect[
        ImportSnapshotRequest,
        AwsError,
        zio.aws.ec2.model.ImportSnapshotResponse.ReadOnly
      ]
  object ModifyFpgaImageAttribute
      extends Effect[
        ModifyFpgaImageAttributeRequest,
        AwsError,
        zio.aws.ec2.model.ModifyFpgaImageAttributeResponse.ReadOnly
      ]
  object DescribeNetworkInsightsPaths
      extends Stream[
        DescribeNetworkInsightsPathsRequest,
        AwsError,
        zio.aws.ec2.model.NetworkInsightsPath.ReadOnly
      ]
  object DescribeNetworkInsightsPathsPaginated
      extends Effect[
        DescribeNetworkInsightsPathsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeNetworkInsightsPathsResponse.ReadOnly
      ]
  object CreateVpc
      extends Effect[
        CreateVpcRequest,
        AwsError,
        zio.aws.ec2.model.CreateVpcResponse.ReadOnly
      ]
  object CancelReservedInstancesListing
      extends Effect[
        CancelReservedInstancesListingRequest,
        AwsError,
        zio.aws.ec2.model.CancelReservedInstancesListingResponse.ReadOnly
      ]
  object GetIpamPoolCidrs
      extends Stream[
        GetIpamPoolCidrsRequest,
        AwsError,
        zio.aws.ec2.model.IpamPoolCidr.ReadOnly
      ]
  object GetIpamPoolCidrsPaginated
      extends Effect[
        GetIpamPoolCidrsRequest,
        AwsError,
        zio.aws.ec2.model.GetIpamPoolCidrsResponse.ReadOnly
      ]
  object DeleteVolume extends Effect[DeleteVolumeRequest, AwsError, Unit]
  object RevokeSecurityGroupIngress
      extends Effect[
        RevokeSecurityGroupIngressRequest,
        AwsError,
        zio.aws.ec2.model.RevokeSecurityGroupIngressResponse.ReadOnly
      ]
  object DescribeNetworkAcls
      extends Stream[
        DescribeNetworkAclsRequest,
        AwsError,
        zio.aws.ec2.model.NetworkAcl.ReadOnly
      ]
  object DescribeNetworkAclsPaginated
      extends Effect[
        DescribeNetworkAclsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeNetworkAclsResponse.ReadOnly
      ]
  object CopyImage
      extends Effect[
        CopyImageRequest,
        AwsError,
        zio.aws.ec2.model.CopyImageResponse.ReadOnly
      ]
  object AdvertiseByoipCidr
      extends Effect[
        AdvertiseByoipCidrRequest,
        AwsError,
        zio.aws.ec2.model.AdvertiseByoipCidrResponse.ReadOnly
      ]
  object CreateLocalGatewayRoute
      extends Effect[
        CreateLocalGatewayRouteRequest,
        AwsError,
        zio.aws.ec2.model.CreateLocalGatewayRouteResponse.ReadOnly
      ]
  object DisassociateTrunkInterface
      extends Effect[
        DisassociateTrunkInterfaceRequest,
        AwsError,
        zio.aws.ec2.model.DisassociateTrunkInterfaceResponse.ReadOnly
      ]
  object DescribeClientVpnEndpoints
      extends Stream[
        DescribeClientVpnEndpointsRequest,
        AwsError,
        zio.aws.ec2.model.ClientVpnEndpoint.ReadOnly
      ]
  object DescribeClientVpnEndpointsPaginated
      extends Effect[
        DescribeClientVpnEndpointsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeClientVpnEndpointsResponse.ReadOnly
      ]
  object DisableFastSnapshotRestores
      extends Effect[
        DisableFastSnapshotRestoresRequest,
        AwsError,
        zio.aws.ec2.model.DisableFastSnapshotRestoresResponse.ReadOnly
      ]
  object CreateSubnetCidrReservation
      extends Effect[
        CreateSubnetCidrReservationRequest,
        AwsError,
        zio.aws.ec2.model.CreateSubnetCidrReservationResponse.ReadOnly
      ]
  object DisassociateRouteTable
      extends Effect[DisassociateRouteTableRequest, AwsError, Unit]
  object DescribeSpotInstanceRequests
      extends Stream[
        DescribeSpotInstanceRequestsRequest,
        AwsError,
        zio.aws.ec2.model.SpotInstanceRequest.ReadOnly
      ]
  object DescribeSpotInstanceRequestsPaginated
      extends Effect[
        DescribeSpotInstanceRequestsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeSpotInstanceRequestsResponse.ReadOnly
      ]
  object DeleteTrafficMirrorFilterRule
      extends Effect[
        DeleteTrafficMirrorFilterRuleRequest,
        AwsError,
        zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleResponse.ReadOnly
      ]
  object DescribeHostReservations
      extends Stream[
        DescribeHostReservationsRequest,
        AwsError,
        zio.aws.ec2.model.HostReservation.ReadOnly
      ]
  object DescribeHostReservationsPaginated
      extends Effect[
        DescribeHostReservationsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeHostReservationsResponse.ReadOnly
      ]
  object ModifyVpnTunnelCertificate
      extends Effect[
        ModifyVpnTunnelCertificateRequest,
        AwsError,
        zio.aws.ec2.model.ModifyVpnTunnelCertificateResponse.ReadOnly
      ]
  object DetachInternetGateway
      extends Effect[DetachInternetGatewayRequest, AwsError, Unit]
  object DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations
      extends Stream[
        DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly
      ]
  object DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginated
      extends Effect[
        DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.ReadOnly
      ]
  object DeregisterImage extends Effect[DeregisterImageRequest, AwsError, Unit]
  object ModifySnapshotAttribute
      extends Effect[ModifySnapshotAttributeRequest, AwsError, Unit]
  object DescribeVolumeAttribute
      extends Effect[
        DescribeVolumeAttributeRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVolumeAttributeResponse.ReadOnly
      ]
  object DescribeVpcEndpoints
      extends Stream[
        DescribeVpcEndpointsRequest,
        AwsError,
        zio.aws.ec2.model.VpcEndpoint.ReadOnly
      ]
  object DescribeVpcEndpointsPaginated
      extends Effect[
        DescribeVpcEndpointsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVpcEndpointsResponse.ReadOnly
      ]
  object GetLaunchTemplateData
      extends Effect[
        GetLaunchTemplateDataRequest,
        AwsError,
        zio.aws.ec2.model.GetLaunchTemplateDataResponse.ReadOnly
      ]
  object DeleteNetworkAcl
      extends Effect[DeleteNetworkAclRequest, AwsError, Unit]
  object DescribeSecurityGroups
      extends Stream[
        DescribeSecurityGroupsRequest,
        AwsError,
        zio.aws.ec2.model.SecurityGroup.ReadOnly
      ]
  object DescribeSecurityGroupsPaginated
      extends Effect[
        DescribeSecurityGroupsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeSecurityGroupsResponse.ReadOnly
      ]
  object DeleteFleets
      extends Effect[
        DeleteFleetsRequest,
        AwsError,
        zio.aws.ec2.model.DeleteFleetsResponse.ReadOnly
      ]
  object ReplaceTransitGatewayRoute
      extends Effect[
        ReplaceTransitGatewayRouteRequest,
        AwsError,
        zio.aws.ec2.model.ReplaceTransitGatewayRouteResponse.ReadOnly
      ]
  object GetVpnConnectionDeviceSampleConfiguration
      extends Effect[
        GetVpnConnectionDeviceSampleConfigurationRequest,
        AwsError,
        zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse.ReadOnly
      ]
  object DetachClassicLinkVpc
      extends Effect[
        DetachClassicLinkVpcRequest,
        AwsError,
        zio.aws.ec2.model.DetachClassicLinkVpcResponse.ReadOnly
      ]
  object AllocateAddress
      extends Effect[
        AllocateAddressRequest,
        AwsError,
        zio.aws.ec2.model.AllocateAddressResponse.ReadOnly
      ]
  object DeleteVpnConnection
      extends Effect[DeleteVpnConnectionRequest, AwsError, Unit]
  object DescribeReservedInstancesOfferings
      extends Stream[
        DescribeReservedInstancesOfferingsRequest,
        AwsError,
        zio.aws.ec2.model.ReservedInstancesOffering.ReadOnly
      ]
  object DescribeReservedInstancesOfferingsPaginated
      extends Effect[
        DescribeReservedInstancesOfferingsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeReservedInstancesOfferingsResponse.ReadOnly
      ]
  object DescribeConversionTasks
      extends Effect[
        DescribeConversionTasksRequest,
        AwsError,
        zio.aws.ec2.model.DescribeConversionTasksResponse.ReadOnly
      ]
  object DescribeLocalGatewayRouteTableVpcAssociations
      extends Stream[
        DescribeLocalGatewayRouteTableVpcAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.ReadOnly
      ]
  object DescribeLocalGatewayRouteTableVpcAssociationsPaginated
      extends Effect[
        DescribeLocalGatewayRouteTableVpcAssociationsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse.ReadOnly
      ]
  object AssociateInstanceEventWindow
      extends Effect[
        AssociateInstanceEventWindowRequest,
        AwsError,
        zio.aws.ec2.model.AssociateInstanceEventWindowResponse.ReadOnly
      ]
  object DescribeInstanceEventNotificationAttributes
      extends Effect[
        DescribeInstanceEventNotificationAttributesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesResponse.ReadOnly
      ]
  object DeleteNetworkInsightsPath
      extends Effect[
        DeleteNetworkInsightsPathRequest,
        AwsError,
        zio.aws.ec2.model.DeleteNetworkInsightsPathResponse.ReadOnly
      ]
  object DescribeElasticGpus
      extends Effect[
        DescribeElasticGpusRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly,
          zio.aws.ec2.model.ElasticGpus.ReadOnly
        ]
      ]
  object DescribeElasticGpusPaginated
      extends Effect[
        DescribeElasticGpusRequest,
        AwsError,
        zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly
      ]
  object ExportTransitGatewayRoutes
      extends Effect[
        ExportTransitGatewayRoutesRequest,
        AwsError,
        zio.aws.ec2.model.ExportTransitGatewayRoutesResponse.ReadOnly
      ]
  object DescribeTrafficMirrorSessions
      extends Stream[
        DescribeTrafficMirrorSessionsRequest,
        AwsError,
        zio.aws.ec2.model.TrafficMirrorSession.ReadOnly
      ]
  object DescribeTrafficMirrorSessionsPaginated
      extends Effect[
        DescribeTrafficMirrorSessionsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeTrafficMirrorSessionsResponse.ReadOnly
      ]
  object DescribeSpotPriceHistory
      extends Stream[
        DescribeSpotPriceHistoryRequest,
        AwsError,
        zio.aws.ec2.model.SpotPrice.ReadOnly
      ]
  object DescribeSpotPriceHistoryPaginated
      extends Effect[
        DescribeSpotPriceHistoryRequest,
        AwsError,
        zio.aws.ec2.model.DescribeSpotPriceHistoryResponse.ReadOnly
      ]
  object EnableImageDeprecation
      extends Effect[
        EnableImageDeprecationRequest,
        AwsError,
        zio.aws.ec2.model.EnableImageDeprecationResponse.ReadOnly
      ]
  object ModifyInstanceMaintenanceOptions
      extends Effect[
        ModifyInstanceMaintenanceOptionsRequest,
        AwsError,
        zio.aws.ec2.model.ModifyInstanceMaintenanceOptionsResponse.ReadOnly
      ]
  object DescribeRegions
      extends Effect[
        DescribeRegionsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeRegionsResponse.ReadOnly
      ]
  object RunScheduledInstances
      extends Effect[
        RunScheduledInstancesRequest,
        AwsError,
        zio.aws.ec2.model.RunScheduledInstancesResponse.ReadOnly
      ]
  object ModifyInstanceEventWindow
      extends Effect[
        ModifyInstanceEventWindowRequest,
        AwsError,
        zio.aws.ec2.model.ModifyInstanceEventWindowResponse.ReadOnly
      ]
  object DeleteTrafficMirrorSession
      extends Effect[
        DeleteTrafficMirrorSessionRequest,
        AwsError,
        zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse.ReadOnly
      ]
  object ModifyVpcPeeringConnectionOptions
      extends Effect[
        ModifyVpcPeeringConnectionOptionsRequest,
        AwsError,
        zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsResponse.ReadOnly
      ]
  object DescribeFlowLogs
      extends Stream[
        DescribeFlowLogsRequest,
        AwsError,
        zio.aws.ec2.model.FlowLog.ReadOnly
      ]
  object DescribeFlowLogsPaginated
      extends Effect[
        DescribeFlowLogsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeFlowLogsResponse.ReadOnly
      ]
  object DescribeIpams
      extends Stream[
        DescribeIpamsRequest,
        AwsError,
        zio.aws.ec2.model.Ipam.ReadOnly
      ]
  object DescribeIpamsPaginated
      extends Effect[
        DescribeIpamsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeIpamsResponse.ReadOnly
      ]
  object ModifyIpamPool
      extends Effect[
        ModifyIpamPoolRequest,
        AwsError,
        zio.aws.ec2.model.ModifyIpamPoolResponse.ReadOnly
      ]
  object UnassignIpv6Addresses
      extends Effect[
        UnassignIpv6AddressesRequest,
        AwsError,
        zio.aws.ec2.model.UnassignIpv6AddressesResponse.ReadOnly
      ]
  object DescribeImportImageTasks
      extends Stream[
        DescribeImportImageTasksRequest,
        AwsError,
        zio.aws.ec2.model.ImportImageTask.ReadOnly
      ]
  object DescribeImportImageTasksPaginated
      extends Effect[
        DescribeImportImageTasksRequest,
        AwsError,
        zio.aws.ec2.model.DescribeImportImageTasksResponse.ReadOnly
      ]
  object DeletePlacementGroup
      extends Effect[DeletePlacementGroupRequest, AwsError, Unit]
  object CancelSpotInstanceRequests
      extends Effect[
        CancelSpotInstanceRequestsRequest,
        AwsError,
        zio.aws.ec2.model.CancelSpotInstanceRequestsResponse.ReadOnly
      ]
  object DescribeSnapshotAttribute
      extends Effect[
        DescribeSnapshotAttributeRequest,
        AwsError,
        zio.aws.ec2.model.DescribeSnapshotAttributeResponse.ReadOnly
      ]
  object DescribeManagedPrefixLists
      extends Stream[
        DescribeManagedPrefixListsRequest,
        AwsError,
        zio.aws.ec2.model.ManagedPrefixList.ReadOnly
      ]
  object DescribeManagedPrefixListsPaginated
      extends Effect[
        DescribeManagedPrefixListsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeManagedPrefixListsResponse.ReadOnly
      ]
  object CreateNetworkAclEntry
      extends Effect[CreateNetworkAclEntryRequest, AwsError, Unit]
  object AssociateTransitGatewayRouteTable
      extends Effect[
        AssociateTransitGatewayRouteTableRequest,
        AwsError,
        zio.aws.ec2.model.AssociateTransitGatewayRouteTableResponse.ReadOnly
      ]
  object DescribeScheduledInstances
      extends Stream[
        DescribeScheduledInstancesRequest,
        AwsError,
        zio.aws.ec2.model.ScheduledInstance.ReadOnly
      ]
  object DescribeScheduledInstancesPaginated
      extends Effect[
        DescribeScheduledInstancesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeScheduledInstancesResponse.ReadOnly
      ]
  object AuthorizeClientVpnIngress
      extends Effect[
        AuthorizeClientVpnIngressRequest,
        AwsError,
        zio.aws.ec2.model.AuthorizeClientVpnIngressResponse.ReadOnly
      ]
  object GetTransitGatewayPrefixListReferences
      extends Stream[
        GetTransitGatewayPrefixListReferencesRequest,
        AwsError,
        zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly
      ]
  object GetTransitGatewayPrefixListReferencesPaginated
      extends Effect[
        GetTransitGatewayPrefixListReferencesRequest,
        AwsError,
        zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse.ReadOnly
      ]
  object DetachNetworkInterface
      extends Effect[DetachNetworkInterfaceRequest, AwsError, Unit]
  object ImportImage
      extends Effect[
        ImportImageRequest,
        AwsError,
        zio.aws.ec2.model.ImportImageResponse.ReadOnly
      ]
  object DescribeEgressOnlyInternetGateways
      extends Stream[
        DescribeEgressOnlyInternetGatewaysRequest,
        AwsError,
        zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly
      ]
  object DescribeEgressOnlyInternetGatewaysPaginated
      extends Effect[
        DescribeEgressOnlyInternetGatewaysRequest,
        AwsError,
        zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysResponse.ReadOnly
      ]
  object ConfirmProductInstance
      extends Effect[
        ConfirmProductInstanceRequest,
        AwsError,
        zio.aws.ec2.model.ConfirmProductInstanceResponse.ReadOnly
      ]
  object DescribePrincipalIdFormat
      extends Stream[
        DescribePrincipalIdFormatRequest,
        AwsError,
        zio.aws.ec2.model.PrincipalIdFormat.ReadOnly
      ]
  object DescribePrincipalIdFormatPaginated
      extends Effect[
        DescribePrincipalIdFormatRequest,
        AwsError,
        zio.aws.ec2.model.DescribePrincipalIdFormatResponse.ReadOnly
      ]
  object AssociateSubnetCidrBlock
      extends Effect[
        AssociateSubnetCidrBlockRequest,
        AwsError,
        zio.aws.ec2.model.AssociateSubnetCidrBlockResponse.ReadOnly
      ]
  object DescribeClientVpnTargetNetworks
      extends Stream[
        DescribeClientVpnTargetNetworksRequest,
        AwsError,
        zio.aws.ec2.model.TargetNetwork.ReadOnly
      ]
  object DescribeClientVpnTargetNetworksPaginated
      extends Effect[
        DescribeClientVpnTargetNetworksRequest,
        AwsError,
        zio.aws.ec2.model.DescribeClientVpnTargetNetworksResponse.ReadOnly
      ]
  object ResetEbsDefaultKmsKeyId
      extends Effect[
        ResetEbsDefaultKmsKeyIdRequest,
        AwsError,
        zio.aws.ec2.model.ResetEbsDefaultKmsKeyIdResponse.ReadOnly
      ]
  object DisableIpamOrganizationAdminAccount
      extends Effect[
        DisableIpamOrganizationAdminAccountRequest,
        AwsError,
        zio.aws.ec2.model.DisableIpamOrganizationAdminAccountResponse.ReadOnly
      ]
  object DescribeIdFormat
      extends Effect[
        DescribeIdFormatRequest,
        AwsError,
        zio.aws.ec2.model.DescribeIdFormatResponse.ReadOnly
      ]
  object DescribeIpamScopes
      extends Stream[
        DescribeIpamScopesRequest,
        AwsError,
        zio.aws.ec2.model.IpamScope.ReadOnly
      ]
  object DescribeIpamScopesPaginated
      extends Effect[
        DescribeIpamScopesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeIpamScopesResponse.ReadOnly
      ]
  object DescribeVpcEndpointServicePermissions
      extends Stream[
        DescribeVpcEndpointServicePermissionsRequest,
        AwsError,
        zio.aws.ec2.model.AllowedPrincipal.ReadOnly
      ]
  object DescribeVpcEndpointServicePermissionsPaginated
      extends Effect[
        DescribeVpcEndpointServicePermissionsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse.ReadOnly
      ]
  object DescribeFpgaImageAttribute
      extends Effect[
        DescribeFpgaImageAttributeRequest,
        AwsError,
        zio.aws.ec2.model.DescribeFpgaImageAttributeResponse.ReadOnly
      ]
  object RegisterInstanceEventNotificationAttributes
      extends Effect[
        RegisterInstanceEventNotificationAttributesRequest,
        AwsError,
        zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesResponse.ReadOnly
      ]
  object RestoreImageFromRecycleBin
      extends Effect[
        RestoreImageFromRecycleBinRequest,
        AwsError,
        zio.aws.ec2.model.RestoreImageFromRecycleBinResponse.ReadOnly
      ]
  object DeleteNetworkInsightsAccessScopeAnalysis
      extends Effect[
        DeleteNetworkInsightsAccessScopeAnalysisRequest,
        AwsError,
        zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse.ReadOnly
      ]
  object ModifyVpcAttribute
      extends Effect[ModifyVpcAttributeRequest, AwsError, Unit]
  object DescribeTrafficMirrorFilters
      extends Stream[
        DescribeTrafficMirrorFiltersRequest,
        AwsError,
        zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly
      ]
  object DescribeTrafficMirrorFiltersPaginated
      extends Effect[
        DescribeTrafficMirrorFiltersRequest,
        AwsError,
        zio.aws.ec2.model.DescribeTrafficMirrorFiltersResponse.ReadOnly
      ]
  object DescribeImageAttribute
      extends Effect[
        DescribeImageAttributeRequest,
        AwsError,
        zio.aws.ec2.model.DescribeImageAttributeResponse.ReadOnly
      ]
  object ResetImageAttribute
      extends Effect[ResetImageAttributeRequest, AwsError, Unit]
  object DescribeCapacityReservationFleets
      extends Stream[
        DescribeCapacityReservationFleetsRequest,
        AwsError,
        zio.aws.ec2.model.CapacityReservationFleet.ReadOnly
      ]
  object DescribeCapacityReservationFleetsPaginated
      extends Effect[
        DescribeCapacityReservationFleetsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeCapacityReservationFleetsResponse.ReadOnly
      ]
  object DeleteNatGateway
      extends Effect[
        DeleteNatGatewayRequest,
        AwsError,
        zio.aws.ec2.model.DeleteNatGatewayResponse.ReadOnly
      ]
  object DeleteTags extends Effect[DeleteTagsRequest, AwsError, Unit]
  object DescribeReservedInstancesListings
      extends Effect[
        DescribeReservedInstancesListingsRequest,
        AwsError,
        zio.aws.ec2.model.DescribeReservedInstancesListingsResponse.ReadOnly
      ]
  object DeleteIpamPool
      extends Effect[
        DeleteIpamPoolRequest,
        AwsError,
        zio.aws.ec2.model.DeleteIpamPoolResponse.ReadOnly
      ]
  object AssociateClientVpnTargetNetwork
      extends Effect[
        AssociateClientVpnTargetNetworkRequest,
        AwsError,
        zio.aws.ec2.model.AssociateClientVpnTargetNetworkResponse.ReadOnly
      ]
  object CopyFpgaImage
      extends Effect[
        CopyFpgaImageRequest,
        AwsError,
        zio.aws.ec2.model.CopyFpgaImageResponse.ReadOnly
      ]
  object GetFlowLogsIntegrationTemplate
      extends Effect[
        GetFlowLogsIntegrationTemplateRequest,
        AwsError,
        zio.aws.ec2.model.GetFlowLogsIntegrationTemplateResponse.ReadOnly
      ]
  object GetInstanceTypesFromInstanceRequirements
      extends Stream[
        GetInstanceTypesFromInstanceRequirementsRequest,
        AwsError,
        zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements.ReadOnly
      ]
  object GetInstanceTypesFromInstanceRequirementsPaginated
      extends Effect[
        GetInstanceTypesFromInstanceRequirementsRequest,
        AwsError,
        zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse.ReadOnly
      ]
  object UnassignPrivateIpAddresses
      extends Effect[UnassignPrivateIpAddressesRequest, AwsError, Unit]
  object ResetSnapshotAttribute
      extends Effect[ResetSnapshotAttributeRequest, AwsError, Unit]
  object DescribeAccountAttributes
      extends Effect[
        DescribeAccountAttributesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeAccountAttributesResponse.ReadOnly
      ]
  object AcceptTransitGatewayVpcAttachment
      extends Effect[
        AcceptTransitGatewayVpcAttachmentRequest,
        AwsError,
        zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentResponse.ReadOnly
      ]
  object CreateInstanceExportTask
      extends Effect[
        CreateInstanceExportTaskRequest,
        AwsError,
        zio.aws.ec2.model.CreateInstanceExportTaskResponse.ReadOnly
      ]
  object AssociateEnclaveCertificateIamRole
      extends Effect[
        AssociateEnclaveCertificateIamRoleRequest,
        AwsError,
        zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleResponse.ReadOnly
      ]
  object CreateDefaultVpc
      extends Effect[
        CreateDefaultVpcRequest,
        AwsError,
        zio.aws.ec2.model.CreateDefaultVpcResponse.ReadOnly
      ]
  object GetTransitGatewayRouteTablePropagations
      extends Stream[
        GetTransitGatewayRouteTablePropagationsRequest,
        AwsError,
        zio.aws.ec2.model.TransitGatewayRouteTablePropagation.ReadOnly
      ]
  object GetTransitGatewayRouteTablePropagationsPaginated
      extends Effect[
        GetTransitGatewayRouteTablePropagationsRequest,
        AwsError,
        zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsResponse.ReadOnly
      ]
  object EnableIpamOrganizationAdminAccount
      extends Effect[
        EnableIpamOrganizationAdminAccountRequest,
        AwsError,
        zio.aws.ec2.model.EnableIpamOrganizationAdminAccountResponse.ReadOnly
      ]
  object CreateTransitGateway
      extends Effect[
        CreateTransitGatewayRequest,
        AwsError,
        zio.aws.ec2.model.CreateTransitGatewayResponse.ReadOnly
      ]
  object CreateTransitGatewayConnectPeer
      extends Effect[
        CreateTransitGatewayConnectPeerRequest,
        AwsError,
        zio.aws.ec2.model.CreateTransitGatewayConnectPeerResponse.ReadOnly
      ]
  object ModifyDefaultCreditSpecification
      extends Effect[
        ModifyDefaultCreditSpecificationRequest,
        AwsError,
        zio.aws.ec2.model.ModifyDefaultCreditSpecificationResponse.ReadOnly
      ]
  object ModifyManagedPrefixList
      extends Effect[
        ModifyManagedPrefixListRequest,
        AwsError,
        zio.aws.ec2.model.ModifyManagedPrefixListResponse.ReadOnly
      ]
  object ModifyVpcTenancy
      extends Effect[
        ModifyVpcTenancyRequest,
        AwsError,
        zio.aws.ec2.model.ModifyVpcTenancyResponse.ReadOnly
      ]
  object AssociateTrunkInterface
      extends Effect[
        AssociateTrunkInterfaceRequest,
        AwsError,
        zio.aws.ec2.model.AssociateTrunkInterfaceResponse.ReadOnly
      ]
  object CancelConversionTask
      extends Effect[CancelConversionTaskRequest, AwsError, Unit]
  object CreateTrafficMirrorTarget
      extends Effect[
        CreateTrafficMirrorTargetRequest,
        AwsError,
        zio.aws.ec2.model.CreateTrafficMirrorTargetResponse.ReadOnly
      ]
  object SearchTransitGatewayRoutes
      extends Effect[
        SearchTransitGatewayRoutesRequest,
        AwsError,
        zio.aws.ec2.model.SearchTransitGatewayRoutesResponse.ReadOnly
      ]
  object DescribeVpcEndpointServices
      extends Effect[
        DescribeVpcEndpointServicesRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.ReadOnly,
          zio.aws.ec2.model.ServiceDetail.ReadOnly
        ]
      ]
  object DescribeVpcEndpointServicesPaginated
      extends Effect[
        DescribeVpcEndpointServicesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.ReadOnly
      ]
  object DeleteLaunchTemplateVersions
      extends Effect[
        DeleteLaunchTemplateVersionsRequest,
        AwsError,
        zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponse.ReadOnly
      ]
  object CreateInstanceEventWindow
      extends Effect[
        CreateInstanceEventWindowRequest,
        AwsError,
        zio.aws.ec2.model.CreateInstanceEventWindowResponse.ReadOnly
      ]
  object CreateNatGateway
      extends Effect[
        CreateNatGatewayRequest,
        AwsError,
        zio.aws.ec2.model.CreateNatGatewayResponse.ReadOnly
      ]
  object EnableSerialConsoleAccess
      extends Effect[
        EnableSerialConsoleAccessRequest,
        AwsError,
        zio.aws.ec2.model.EnableSerialConsoleAccessResponse.ReadOnly
      ]
  object ReplaceRouteTableAssociation
      extends Effect[
        ReplaceRouteTableAssociationRequest,
        AwsError,
        zio.aws.ec2.model.ReplaceRouteTableAssociationResponse.ReadOnly
      ]
  object ModifyEbsDefaultKmsKeyId
      extends Effect[
        ModifyEbsDefaultKmsKeyIdRequest,
        AwsError,
        zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdResponse.ReadOnly
      ]
  object ProvisionByoipCidr
      extends Effect[
        ProvisionByoipCidrRequest,
        AwsError,
        zio.aws.ec2.model.ProvisionByoipCidrResponse.ReadOnly
      ]
  object DeleteLocalGatewayRoute
      extends Effect[
        DeleteLocalGatewayRouteRequest,
        AwsError,
        zio.aws.ec2.model.DeleteLocalGatewayRouteResponse.ReadOnly
      ]
  object ReleaseHosts
      extends Effect[
        ReleaseHostsRequest,
        AwsError,
        zio.aws.ec2.model.ReleaseHostsResponse.ReadOnly
      ]
  object DescribeLaunchTemplates
      extends Stream[
        DescribeLaunchTemplatesRequest,
        AwsError,
        zio.aws.ec2.model.LaunchTemplate.ReadOnly
      ]
  object DescribeLaunchTemplatesPaginated
      extends Effect[
        DescribeLaunchTemplatesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeLaunchTemplatesResponse.ReadOnly
      ]
  object TerminateInstances
      extends Effect[
        TerminateInstancesRequest,
        AwsError,
        zio.aws.ec2.model.TerminateInstancesResponse.ReadOnly
      ]
  object GetHostReservationPurchasePreview
      extends Effect[
        GetHostReservationPurchasePreviewRequest,
        AwsError,
        zio.aws.ec2.model.GetHostReservationPurchasePreviewResponse.ReadOnly
      ]
  object ModifyInstanceCreditSpecification
      extends Effect[
        ModifyInstanceCreditSpecificationRequest,
        AwsError,
        zio.aws.ec2.model.ModifyInstanceCreditSpecificationResponse.ReadOnly
      ]
  object DetachVolume
      extends Effect[
        DetachVolumeRequest,
        AwsError,
        zio.aws.ec2.model.DetachVolumeResponse.ReadOnly
      ]
  object CreateSnapshot
      extends Effect[
        CreateSnapshotRequest,
        AwsError,
        zio.aws.ec2.model.CreateSnapshotResponse.ReadOnly
      ]
  object GetIpamResourceCidrs
      extends Stream[
        GetIpamResourceCidrsRequest,
        AwsError,
        zio.aws.ec2.model.IpamResourceCidr.ReadOnly
      ]
  object GetIpamResourceCidrsPaginated
      extends Effect[
        GetIpamResourceCidrsRequest,
        AwsError,
        zio.aws.ec2.model.GetIpamResourceCidrsResponse.ReadOnly
      ]
  object ModifyReservedInstances
      extends Effect[
        ModifyReservedInstancesRequest,
        AwsError,
        zio.aws.ec2.model.ModifyReservedInstancesResponse.ReadOnly
      ]
  object CreateFpgaImage
      extends Effect[
        CreateFpgaImageRequest,
        AwsError,
        zio.aws.ec2.model.CreateFpgaImageResponse.ReadOnly
      ]
  object DeprovisionPublicIpv4PoolCidr
      extends Effect[
        DeprovisionPublicIpv4PoolCidrRequest,
        AwsError,
        zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrResponse.ReadOnly
      ]
  object AcceptVpcPeeringConnection
      extends Effect[
        AcceptVpcPeeringConnectionRequest,
        AwsError,
        zio.aws.ec2.model.AcceptVpcPeeringConnectionResponse.ReadOnly
      ]
  object DescribeTransitGatewayRouteTables
      extends Stream[
        DescribeTransitGatewayRouteTablesRequest,
        AwsError,
        zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly
      ]
  object DescribeTransitGatewayRouteTablesPaginated
      extends Effect[
        DescribeTransitGatewayRouteTablesRequest,
        AwsError,
        zio.aws.ec2.model.DescribeTransitGatewayRouteTablesResponse.ReadOnly
      ]
  object DeleteClientVpnEndpoint
      extends Effect[
        DeleteClientVpnEndpointRequest,
        AwsError,
        zio.aws.ec2.model.DeleteClientVpnEndpointResponse.ReadOnly
      ]
  object ImportInstance
      extends Effect[
        ImportInstanceRequest,
        AwsError,
        zio.aws.ec2.model.ImportInstanceResponse.ReadOnly
      ]
  object EnableFastSnapshotRestores
      extends Effect[
        EnableFastSnapshotRestoresRequest,
        AwsError,
        zio.aws.ec2.model.EnableFastSnapshotRestoresResponse.ReadOnly
      ]
  object GetAssociatedEnclaveCertificateIamRoles
      extends Effect[
        GetAssociatedEnclaveCertificateIamRolesRequest,
        AwsError,
        zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse.ReadOnly
      ]
  object DeregisterInstanceEventNotificationAttributes
      extends Effect[
        DeregisterInstanceEventNotificationAttributesRequest,
        AwsError,
        zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesResponse.ReadOnly
      ]
  object ResetAddressAttribute
      extends Effect[
        ResetAddressAttributeRequest,
        AwsError,
        zio.aws.ec2.model.ResetAddressAttributeResponse.ReadOnly
      ]
  object MoveByoipCidrToIpam
      extends Effect[
        MoveByoipCidrToIpamRequest,
        AwsError,
        zio.aws.ec2.model.MoveByoipCidrToIpamResponse.ReadOnly
      ]
  object ImportClientVpnClientCertificateRevocationList
      extends Effect[
        ImportClientVpnClientCertificateRevocationListRequest,
        AwsError,
        zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListResponse.ReadOnly
      ]
  object CreateSpotDatafeedSubscription
      extends Effect[
        CreateSpotDatafeedSubscriptionRequest,
        AwsError,
        zio.aws.ec2.model.CreateSpotDatafeedSubscriptionResponse.ReadOnly
      ]
  object ModifyIdentityIdFormat
      extends Effect[ModifyIdentityIdFormatRequest, AwsError, Unit]
  object DescribePrefixLists
      extends Stream[
        DescribePrefixListsRequest,
        AwsError,
        zio.aws.ec2.model.PrefixList.ReadOnly
      ]
  object DescribePrefixListsPaginated
      extends Effect[
        DescribePrefixListsRequest,
        AwsError,
        zio.aws.ec2.model.DescribePrefixListsResponse.ReadOnly
      ]
  object CreateVpnGateway
      extends Effect[
        CreateVpnGatewayRequest,
        AwsError,
        zio.aws.ec2.model.CreateVpnGatewayResponse.ReadOnly
      ]
  object CreateTags extends Effect[CreateTagsRequest, AwsError, Unit]
  object CreateSecurityGroup
      extends Effect[
        CreateSecurityGroupRequest,
        AwsError,
        zio.aws.ec2.model.CreateSecurityGroupResponse.ReadOnly
      ]
  object DeleteInstanceEventWindow
      extends Effect[
        DeleteInstanceEventWindowRequest,
        AwsError,
        zio.aws.ec2.model.DeleteInstanceEventWindowResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Ec2] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Ec2] { rts =>
        ZIO.succeed {
          new Ec2 {
            val api: Ec2AsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Ec2 = this
            def describeVolumesModifications(
                request: DescribeVolumesModificationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.VolumeModification.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeVolumesModifications, request))
            def describeVolumesModificationsPaginated(
                request: DescribeVolumesModificationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVolumesModificationsResponse.ReadOnly
            ] = proxy(DescribeVolumesModificationsPaginated, request)
            def deleteSpotDatafeedSubscription(
                request: DeleteSpotDatafeedSubscriptionRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteSpotDatafeedSubscription, request)
            def deleteVpcEndpointConnectionNotifications(
                request: DeleteVpcEndpointConnectionNotificationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsResponse.ReadOnly
            ] = proxy(DeleteVpcEndpointConnectionNotifications, request)
            def createNetworkInterface(
                request: CreateNetworkInterfaceRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateNetworkInterfaceResponse.ReadOnly
            ] = proxy(CreateNetworkInterface, request)
            def enableVpcClassicLink(request: EnableVpcClassicLinkRequest): IO[
              AwsError,
              zio.aws.ec2.model.EnableVpcClassicLinkResponse.ReadOnly
            ] = proxy(EnableVpcClassicLink, request)
            def rejectTransitGatewayPeeringAttachment(
                request: RejectTransitGatewayPeeringAttachmentRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentResponse.ReadOnly
            ] = proxy(RejectTransitGatewayPeeringAttachment, request)
            def createVpnConnection(request: CreateVpnConnectionRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateVpnConnectionResponse.ReadOnly
            ] = proxy(CreateVpnConnection, request)
            def describeDhcpOptions(
                request: DescribeDhcpOptionsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.DhcpOptions.ReadOnly] =
              rts.unsafeRun(proxy(DescribeDhcpOptions, request))
            def describeDhcpOptionsPaginated(
                request: DescribeDhcpOptionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeDhcpOptionsResponse.ReadOnly
            ] = proxy(DescribeDhcpOptionsPaginated, request)
            def modifyVpnTunnelOptions(
                request: ModifyVpnTunnelOptionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyVpnTunnelOptionsResponse.ReadOnly
            ] = proxy(ModifyVpnTunnelOptions, request)
            def modifyCapacityReservation(
                request: ModifyCapacityReservationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyCapacityReservationResponse.ReadOnly
            ] = proxy(ModifyCapacityReservation, request)
            def describeVpcs(
                request: DescribeVpcsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.Vpc.ReadOnly] =
              rts.unsafeRun(proxy(DescribeVpcs, request))
            def describeVpcsPaginated(
                request: DescribeVpcsRequest
            ): IO[AwsError, zio.aws.ec2.model.DescribeVpcsResponse.ReadOnly] =
              proxy(DescribeVpcsPaginated, request)
            def deleteNetworkInsightsAnalysis(
                request: DeleteNetworkInsightsAnalysisRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteNetworkInsightsAnalysisResponse.ReadOnly
            ] = proxy(DeleteNetworkInsightsAnalysis, request)
            def describeIdentityIdFormat(
                request: DescribeIdentityIdFormatRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeIdentityIdFormatResponse.ReadOnly
            ] = proxy(DescribeIdentityIdFormat, request)
            def describeTags(request: DescribeTagsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TagDescription.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeTags, request))
            def describeTagsPaginated(
                request: DescribeTagsRequest
            ): IO[AwsError, zio.aws.ec2.model.DescribeTagsResponse.ReadOnly] =
              proxy(DescribeTagsPaginated, request)
            def monitorInstances(request: MonitorInstancesRequest): IO[
              AwsError,
              zio.aws.ec2.model.MonitorInstancesResponse.ReadOnly
            ] = proxy(MonitorInstances, request)
            def allocateIpamPoolCidr(request: AllocateIpamPoolCidrRequest): IO[
              AwsError,
              zio.aws.ec2.model.AllocateIpamPoolCidrResponse.ReadOnly
            ] = proxy(AllocateIpamPoolCidr, request)
            def getManagedPrefixListEntries(
                request: GetManagedPrefixListEntriesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.PrefixListEntry.ReadOnly
            ] = rts.unsafeRun(proxy(GetManagedPrefixListEntries, request))
            def getManagedPrefixListEntriesPaginated(
                request: GetManagedPrefixListEntriesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetManagedPrefixListEntriesResponse.ReadOnly
            ] = proxy(GetManagedPrefixListEntriesPaginated, request)
            def deleteTransitGatewayPeeringAttachment(
                request: DeleteTransitGatewayPeeringAttachmentRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse.ReadOnly
            ] = proxy(DeleteTransitGatewayPeeringAttachment, request)
            def getTransitGatewayMulticastDomainAssociations(
                request: GetTransitGatewayMulticastDomainAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation.ReadOnly
            ] = rts.unsafeRun(
              proxy(GetTransitGatewayMulticastDomainAssociations, request)
            )
            def getTransitGatewayMulticastDomainAssociationsPaginated(
                request: GetTransitGatewayMulticastDomainAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
            ] = proxy(
              GetTransitGatewayMulticastDomainAssociationsPaginated,
              request
            )
            def modifyIpamResourceCidr(
                request: ModifyIpamResourceCidrRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyIpamResourceCidrResponse.ReadOnly
            ] = proxy(ModifyIpamResourceCidr, request)
            def createTransitGatewayVpcAttachment(
                request: CreateTransitGatewayVpcAttachmentRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentResponse.ReadOnly
            ] = proxy(CreateTransitGatewayVpcAttachment, request)
            def replaceNetworkAclEntry(
                request: ReplaceNetworkAclEntryRequest
            ): IO[AwsError, Unit] = proxy(ReplaceNetworkAclEntry, request)
            def describeVpcPeeringConnections(
                request: DescribeVpcPeeringConnectionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.VpcPeeringConnection.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeVpcPeeringConnections, request))
            def describeVpcPeeringConnectionsPaginated(
                request: DescribeVpcPeeringConnectionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVpcPeeringConnectionsResponse.ReadOnly
            ] = proxy(DescribeVpcPeeringConnectionsPaginated, request)
            def describeFleetHistory(
                request: DescribeFleetHistoryRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.ec2.model.DescribeFleetHistoryResponse.ReadOnly,
              zio.aws.ec2.model.HistoryRecordEntry.ReadOnly
            ]] = proxy(DescribeFleetHistory, request)
            def describeFleetHistoryPaginated(
                request: DescribeFleetHistoryRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeFleetHistoryResponse.ReadOnly
            ] = proxy(DescribeFleetHistoryPaginated, request)
            def cancelSpotFleetRequests(
                request: CancelSpotFleetRequestsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CancelSpotFleetRequestsResponse.ReadOnly
            ] = proxy(CancelSpotFleetRequests, request)
            def bundleInstance(
                request: BundleInstanceRequest
            ): IO[AwsError, zio.aws.ec2.model.BundleInstanceResponse.ReadOnly] =
              proxy(BundleInstance, request)
            def revokeClientVpnIngress(
                request: RevokeClientVpnIngressRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RevokeClientVpnIngressResponse.ReadOnly
            ] = proxy(RevokeClientVpnIngress, request)
            def deleteSubnetCidrReservation(
                request: DeleteSubnetCidrReservationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteSubnetCidrReservationResponse.ReadOnly
            ] = proxy(DeleteSubnetCidrReservation, request)
            def associateTransitGatewayMulticastDomain(
                request: AssociateTransitGatewayMulticastDomainRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse.ReadOnly
            ] = proxy(AssociateTransitGatewayMulticastDomain, request)
            def searchTransitGatewayMulticastGroups(
                request: SearchTransitGatewayMulticastGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TransitGatewayMulticastGroup.ReadOnly
            ] =
              rts.unsafeRun(proxy(SearchTransitGatewayMulticastGroups, request))
            def searchTransitGatewayMulticastGroupsPaginated(
                request: SearchTransitGatewayMulticastGroupsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsResponse.ReadOnly
            ] = proxy(SearchTransitGatewayMulticastGroupsPaginated, request)
            def sendDiagnosticInterrupt(
                request: SendDiagnosticInterruptRequest
            ): IO[AwsError, Unit] = proxy(SendDiagnosticInterrupt, request)
            def describeAddresses(request: DescribeAddressesRequest): IO[
              AwsError,
              zio.aws.ec2.model.DescribeAddressesResponse.ReadOnly
            ] = proxy(DescribeAddresses, request)
            def enableTransitGatewayRouteTablePropagation(
                request: EnableTransitGatewayRouteTablePropagationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationResponse.ReadOnly
            ] = proxy(EnableTransitGatewayRouteTablePropagation, request)
            def deleteIpamScope(request: DeleteIpamScopeRequest): IO[
              AwsError,
              zio.aws.ec2.model.DeleteIpamScopeResponse.ReadOnly
            ] = proxy(DeleteIpamScope, request)
            def createPublicIpv4Pool(request: CreatePublicIpv4PoolRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreatePublicIpv4PoolResponse.ReadOnly
            ] = proxy(CreatePublicIpv4Pool, request)
            def createTransitGatewayRouteTable(
                request: CreateTransitGatewayRouteTableRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateTransitGatewayRouteTableResponse.ReadOnly
            ] = proxy(CreateTransitGatewayRouteTable, request)
            def registerTransitGatewayMulticastGroupMembers(
                request: RegisterTransitGatewayMulticastGroupMembersRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse.ReadOnly
            ] = proxy(RegisterTransitGatewayMulticastGroupMembers, request)
            def describeKeyPairs(request: DescribeKeyPairsRequest): IO[
              AwsError,
              zio.aws.ec2.model.DescribeKeyPairsResponse.ReadOnly
            ] = proxy(DescribeKeyPairs, request)
            def startInstances(
                request: StartInstancesRequest
            ): IO[AwsError, zio.aws.ec2.model.StartInstancesResponse.ReadOnly] =
              proxy(StartInstances, request)
            def describeScheduledInstanceAvailability(
                request: DescribeScheduledInstanceAvailabilityRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ScheduledInstanceAvailability.ReadOnly
            ] = rts
              .unsafeRun(proxy(DescribeScheduledInstanceAvailability, request))
            def describeScheduledInstanceAvailabilityPaginated(
                request: DescribeScheduledInstanceAvailabilityRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityResponse.ReadOnly
            ] = proxy(DescribeScheduledInstanceAvailabilityPaginated, request)
            def resetInstanceAttribute(
                request: ResetInstanceAttributeRequest
            ): IO[AwsError, Unit] = proxy(ResetInstanceAttribute, request)
            def modifyInstanceMetadataOptions(
                request: ModifyInstanceMetadataOptionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyInstanceMetadataOptionsResponse.ReadOnly
            ] = proxy(ModifyInstanceMetadataOptions, request)
            def createRoute(
                request: CreateRouteRequest
            ): IO[AwsError, zio.aws.ec2.model.CreateRouteResponse.ReadOnly] =
              proxy(CreateRoute, request)
            def deleteFlowLogs(
                request: DeleteFlowLogsRequest
            ): IO[AwsError, zio.aws.ec2.model.DeleteFlowLogsResponse.ReadOnly] =
              proxy(DeleteFlowLogs, request)
            def describeFpgaImages(
                request: DescribeFpgaImagesRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.FpgaImage.ReadOnly] =
              rts.unsafeRun(proxy(DescribeFpgaImages, request))
            def describeFpgaImagesPaginated(
                request: DescribeFpgaImagesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeFpgaImagesResponse.ReadOnly
            ] = proxy(DescribeFpgaImagesPaginated, request)
            def deleteRoute(request: DeleteRouteRequest): IO[AwsError, Unit] =
              proxy(DeleteRoute, request)
            def modifyClientVpnEndpoint(
                request: ModifyClientVpnEndpointRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyClientVpnEndpointResponse.ReadOnly
            ] = proxy(ModifyClientVpnEndpoint, request)
            def modifyTrafficMirrorFilterNetworkServices(
                request: ModifyTrafficMirrorFilterNetworkServicesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse.ReadOnly
            ] = proxy(ModifyTrafficMirrorFilterNetworkServices, request)
            def disassociateTransitGatewayRouteTable(
                request: DisassociateTransitGatewayRouteTableRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisassociateTransitGatewayRouteTableResponse.ReadOnly
            ] = proxy(DisassociateTransitGatewayRouteTable, request)
            def modifyInstanceCapacityReservationAttributes(
                request: ModifyInstanceCapacityReservationAttributesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesResponse.ReadOnly
            ] = proxy(ModifyInstanceCapacityReservationAttributes, request)
            def describeRouteTables(
                request: DescribeRouteTablesRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.RouteTable.ReadOnly] =
              rts.unsafeRun(proxy(DescribeRouteTables, request))
            def describeRouteTablesPaginated(
                request: DescribeRouteTablesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeRouteTablesResponse.ReadOnly
            ] = proxy(DescribeRouteTablesPaginated, request)
            def modifySubnetAttribute(
                request: ModifySubnetAttributeRequest
            ): IO[AwsError, Unit] = proxy(ModifySubnetAttribute, request)
            def modifyVolumeAttribute(
                request: ModifyVolumeAttributeRequest
            ): IO[AwsError, Unit] = proxy(ModifyVolumeAttribute, request)
            def acceptVpcEndpointConnections(
                request: AcceptVpcEndpointConnectionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AcceptVpcEndpointConnectionsResponse.ReadOnly
            ] = proxy(AcceptVpcEndpointConnections, request)
            def attachNetworkInterface(
                request: AttachNetworkInterfaceRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AttachNetworkInterfaceResponse.ReadOnly
            ] = proxy(AttachNetworkInterface, request)
            def deleteFpgaImage(request: DeleteFpgaImageRequest): IO[
              AwsError,
              zio.aws.ec2.model.DeleteFpgaImageResponse.ReadOnly
            ] = proxy(DeleteFpgaImage, request)
            def deleteTransitGatewayVpcAttachment(
                request: DeleteTransitGatewayVpcAttachmentRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteTransitGatewayVpcAttachmentResponse.ReadOnly
            ] = proxy(DeleteTransitGatewayVpcAttachment, request)
            def deleteSecurityGroup(
                request: DeleteSecurityGroupRequest
            ): IO[AwsError, Unit] = proxy(DeleteSecurityGroup, request)
            def describeNatGateways(
                request: DescribeNatGatewaysRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.NatGateway.ReadOnly] =
              rts.unsafeRun(proxy(DescribeNatGateways, request))
            def describeNatGatewaysPaginated(
                request: DescribeNatGatewaysRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeNatGatewaysResponse.ReadOnly
            ] = proxy(DescribeNatGatewaysPaginated, request)
            def getCoipPoolUsage(request: GetCoipPoolUsageRequest): IO[
              AwsError,
              zio.aws.ec2.model.GetCoipPoolUsageResponse.ReadOnly
            ] = proxy(GetCoipPoolUsage, request)
            def authorizeSecurityGroupEgress(
                request: AuthorizeSecurityGroupEgressRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AuthorizeSecurityGroupEgressResponse.ReadOnly
            ] = proxy(AuthorizeSecurityGroupEgress, request)
            def modifyVpcEndpoint(request: ModifyVpcEndpointRequest): IO[
              AwsError,
              zio.aws.ec2.model.ModifyVpcEndpointResponse.ReadOnly
            ] = proxy(ModifyVpcEndpoint, request)
            def deprovisionIpamPoolCidr(
                request: DeprovisionIpamPoolCidrRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeprovisionIpamPoolCidrResponse.ReadOnly
            ] = proxy(DeprovisionIpamPoolCidr, request)
            def deleteTransitGatewayPrefixListReference(
                request: DeleteTransitGatewayPrefixListReferenceRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse.ReadOnly
            ] = proxy(DeleteTransitGatewayPrefixListReference, request)
            def createInternetGateway(
                request: CreateInternetGatewayRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateInternetGatewayResponse.ReadOnly
            ] = proxy(CreateInternetGateway, request)
            def describeCarrierGateways(
                request: DescribeCarrierGatewaysRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.CarrierGateway.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeCarrierGateways, request))
            def describeCarrierGatewaysPaginated(
                request: DescribeCarrierGatewaysRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeCarrierGatewaysResponse.ReadOnly
            ] = proxy(DescribeCarrierGatewaysPaginated, request)
            def disableSerialConsoleAccess(
                request: DisableSerialConsoleAccessRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisableSerialConsoleAccessResponse.ReadOnly
            ] = proxy(DisableSerialConsoleAccess, request)
            def enableEbsEncryptionByDefault(
                request: EnableEbsEncryptionByDefaultRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.EnableEbsEncryptionByDefaultResponse.ReadOnly
            ] = proxy(EnableEbsEncryptionByDefault, request)
            def modifyTransitGatewayVpcAttachment(
                request: ModifyTransitGatewayVpcAttachmentRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentResponse.ReadOnly
            ] = proxy(ModifyTransitGatewayVpcAttachment, request)
            def assignPrivateIpAddresses(
                request: AssignPrivateIpAddressesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AssignPrivateIpAddressesResponse.ReadOnly
            ] = proxy(AssignPrivateIpAddresses, request)
            def modifyLaunchTemplate(request: ModifyLaunchTemplateRequest): IO[
              AwsError,
              zio.aws.ec2.model.ModifyLaunchTemplateResponse.ReadOnly
            ] = proxy(ModifyLaunchTemplate, request)
            def deleteRouteTable(
                request: DeleteRouteTableRequest
            ): IO[AwsError, Unit] = proxy(DeleteRouteTable, request)
            def restoreAddressToClassic(
                request: RestoreAddressToClassicRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RestoreAddressToClassicResponse.ReadOnly
            ] = proxy(RestoreAddressToClassic, request)
            def describeFastLaunchImages(
                request: DescribeFastLaunchImagesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.DescribeFastLaunchImagesSuccessItem.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeFastLaunchImages, request))
            def describeFastLaunchImagesPaginated(
                request: DescribeFastLaunchImagesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeFastLaunchImagesResponse.ReadOnly
            ] = proxy(DescribeFastLaunchImagesPaginated, request)
            def describeMovingAddresses(
                request: DescribeMovingAddressesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.MovingAddressStatus.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeMovingAddresses, request))
            def describeMovingAddressesPaginated(
                request: DescribeMovingAddressesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeMovingAddressesResponse.ReadOnly
            ] = proxy(DescribeMovingAddressesPaginated, request)
            def modifyPrivateDnsNameOptions(
                request: ModifyPrivateDnsNameOptionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyPrivateDnsNameOptionsResponse.ReadOnly
            ] = proxy(ModifyPrivateDnsNameOptions, request)
            def describeFleetInstances(
                request: DescribeFleetInstancesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.ec2.model.DescribeFleetInstancesResponse.ReadOnly,
              zio.aws.ec2.model.ActiveInstance.ReadOnly
            ]] = proxy(DescribeFleetInstances, request)
            def describeFleetInstancesPaginated(
                request: DescribeFleetInstancesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeFleetInstancesResponse.ReadOnly
            ] = proxy(DescribeFleetInstancesPaginated, request)
            def describeSecurityGroupRules(
                request: DescribeSecurityGroupRulesRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              rts.unsafeRun(proxy(DescribeSecurityGroupRules, request))
            def describeSecurityGroupRulesPaginated(
                request: DescribeSecurityGroupRulesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeSecurityGroupRulesResponse.ReadOnly
            ] = proxy(DescribeSecurityGroupRulesPaginated, request)
            def rejectVpcPeeringConnection(
                request: RejectVpcPeeringConnectionRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RejectVpcPeeringConnectionResponse.ReadOnly
            ] = proxy(RejectVpcPeeringConnection, request)
            def attachInternetGateway(
                request: AttachInternetGatewayRequest
            ): IO[AwsError, Unit] = proxy(AttachInternetGateway, request)
            def describeAvailabilityZones(
                request: DescribeAvailabilityZonesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeAvailabilityZonesResponse.ReadOnly
            ] = proxy(DescribeAvailabilityZones, request)
            def cancelBundleTask(request: CancelBundleTaskRequest): IO[
              AwsError,
              zio.aws.ec2.model.CancelBundleTaskResponse.ReadOnly
            ] = proxy(CancelBundleTask, request)
            def describeLocalGateways(
                request: DescribeLocalGatewaysRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.LocalGateway.ReadOnly] =
              rts.unsafeRun(proxy(DescribeLocalGateways, request))
            def describeLocalGatewaysPaginated(
                request: DescribeLocalGatewaysRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeLocalGatewaysResponse.ReadOnly
            ] = proxy(DescribeLocalGatewaysPaginated, request)
            def deleteVpc(request: DeleteVpcRequest): IO[AwsError, Unit] =
              proxy(DeleteVpc, request)
            def deleteVpnConnectionRoute(
                request: DeleteVpnConnectionRouteRequest
            ): IO[AwsError, Unit] = proxy(DeleteVpnConnectionRoute, request)
            def deleteTransitGatewayMulticastDomain(
                request: DeleteTransitGatewayMulticastDomainRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainResponse.ReadOnly
            ] = proxy(DeleteTransitGatewayMulticastDomain, request)
            def disassociateClientVpnTargetNetwork(
                request: DisassociateClientVpnTargetNetworkRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisassociateClientVpnTargetNetworkResponse.ReadOnly
            ] = proxy(DisassociateClientVpnTargetNetwork, request)
            def describeInstances(
                request: DescribeInstancesRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.Reservation.ReadOnly] =
              rts.unsafeRun(proxy(DescribeInstances, request))
            def describeInstancesPaginated(
                request: DescribeInstancesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeInstancesResponse.ReadOnly
            ] = proxy(DescribeInstancesPaginated, request)
            def describeVpnConnections(
                request: DescribeVpnConnectionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVpnConnectionsResponse.ReadOnly
            ] = proxy(DescribeVpnConnections, request)
            def attachClassicLinkVpc(request: AttachClassicLinkVpcRequest): IO[
              AwsError,
              zio.aws.ec2.model.AttachClassicLinkVpcResponse.ReadOnly
            ] = proxy(AttachClassicLinkVpc, request)
            def createLaunchTemplateVersion(
                request: CreateLaunchTemplateVersionRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateLaunchTemplateVersionResponse.ReadOnly
            ] = proxy(CreateLaunchTemplateVersion, request)
            def deleteNetworkInsightsAccessScope(
                request: DeleteNetworkInsightsAccessScopeRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeResponse.ReadOnly
            ] = proxy(DeleteNetworkInsightsAccessScope, request)
            def modifyVpcEndpointConnectionNotification(
                request: ModifyVpcEndpointConnectionNotificationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationResponse.ReadOnly
            ] = proxy(ModifyVpcEndpointConnectionNotification, request)
            def describeInstanceTypes(
                request: DescribeInstanceTypesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.InstanceTypeInfo.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeInstanceTypes, request))
            def describeInstanceTypesPaginated(
                request: DescribeInstanceTypesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeInstanceTypesResponse.ReadOnly
            ] = proxy(DescribeInstanceTypesPaginated, request)
            def rebootInstances(
                request: RebootInstancesRequest
            ): IO[AwsError, Unit] = proxy(RebootInstances, request)
            def describeInstanceCreditSpecifications(
                request: DescribeInstanceCreditSpecificationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.InstanceCreditSpecification.ReadOnly
            ] = rts
              .unsafeRun(proxy(DescribeInstanceCreditSpecifications, request))
            def describeInstanceCreditSpecificationsPaginated(
                request: DescribeInstanceCreditSpecificationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeInstanceCreditSpecificationsResponse.ReadOnly
            ] = proxy(DescribeInstanceCreditSpecificationsPaginated, request)
            def describeFleets(
                request: DescribeFleetsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.FleetData.ReadOnly] =
              rts.unsafeRun(proxy(DescribeFleets, request))
            def describeFleetsPaginated(
                request: DescribeFleetsRequest
            ): IO[AwsError, zio.aws.ec2.model.DescribeFleetsResponse.ReadOnly] =
              proxy(DescribeFleetsPaginated, request)
            def getSpotPlacementScores(
                request: GetSpotPlacementScoresRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.SpotPlacementScore.ReadOnly
            ] = rts.unsafeRun(proxy(GetSpotPlacementScores, request))
            def getSpotPlacementScoresPaginated(
                request: GetSpotPlacementScoresRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetSpotPlacementScoresResponse.ReadOnly
            ] = proxy(GetSpotPlacementScoresPaginated, request)
            def createDefaultSubnet(request: CreateDefaultSubnetRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateDefaultSubnetResponse.ReadOnly
            ] = proxy(CreateDefaultSubnet, request)
            def modifyVolume(
                request: ModifyVolumeRequest
            ): IO[AwsError, zio.aws.ec2.model.ModifyVolumeResponse.ReadOnly] =
              proxy(ModifyVolume, request)
            def getSerialConsoleAccessStatus(
                request: GetSerialConsoleAccessStatusRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetSerialConsoleAccessStatusResponse.ReadOnly
            ] = proxy(GetSerialConsoleAccessStatus, request)
            def getEbsEncryptionByDefault(
                request: GetEbsEncryptionByDefaultRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetEbsEncryptionByDefaultResponse.ReadOnly
            ] = proxy(GetEbsEncryptionByDefault, request)
            def describeSnapshotTierStatus(
                request: DescribeSnapshotTierStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.SnapshotTierStatus.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeSnapshotTierStatus, request))
            def describeSnapshotTierStatusPaginated(
                request: DescribeSnapshotTierStatusRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeSnapshotTierStatusResponse.ReadOnly
            ] = proxy(DescribeSnapshotTierStatusPaginated, request)
            def resetNetworkInterfaceAttribute(
                request: ResetNetworkInterfaceAttributeRequest
            ): IO[AwsError, Unit] =
              proxy(ResetNetworkInterfaceAttribute, request)
            def modifyTransitGateway(request: ModifyTransitGatewayRequest): IO[
              AwsError,
              zio.aws.ec2.model.ModifyTransitGatewayResponse.ReadOnly
            ] = proxy(ModifyTransitGateway, request)
            def enableVolumeIO(
                request: EnableVolumeIoRequest
            ): IO[AwsError, Unit] = proxy(EnableVolumeIO, request)
            def deleteTransitGatewayRoute(
                request: DeleteTransitGatewayRouteRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteTransitGatewayRouteResponse.ReadOnly
            ] = proxy(DeleteTransitGatewayRoute, request)
            def describeImportSnapshotTasks(
                request: DescribeImportSnapshotTasksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ImportSnapshotTask.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeImportSnapshotTasks, request))
            def describeImportSnapshotTasksPaginated(
                request: DescribeImportSnapshotTasksRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeImportSnapshotTasksResponse.ReadOnly
            ] = proxy(DescribeImportSnapshotTasksPaginated, request)
            def describeNetworkInsightsAnalyses(
                request: DescribeNetworkInsightsAnalysesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeNetworkInsightsAnalyses, request))
            def describeNetworkInsightsAnalysesPaginated(
                request: DescribeNetworkInsightsAnalysesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeNetworkInsightsAnalysesResponse.ReadOnly
            ] = proxy(DescribeNetworkInsightsAnalysesPaginated, request)
            def disassociateSubnetCidrBlock(
                request: DisassociateSubnetCidrBlockRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisassociateSubnetCidrBlockResponse.ReadOnly
            ] = proxy(DisassociateSubnetCidrBlock, request)
            def cancelExportTask(
                request: CancelExportTaskRequest
            ): IO[AwsError, Unit] = proxy(CancelExportTask, request)
            def deleteVpnGateway(
                request: DeleteVpnGatewayRequest
            ): IO[AwsError, Unit] = proxy(DeleteVpnGateway, request)
            def associateVpcCidrBlock(
                request: AssociateVpcCidrBlockRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AssociateVpcCidrBlockResponse.ReadOnly
            ] = proxy(AssociateVpcCidrBlock, request)
            def modifyInstanceEventStartTime(
                request: ModifyInstanceEventStartTimeRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyInstanceEventStartTimeResponse.ReadOnly
            ] = proxy(ModifyInstanceEventStartTime, request)
            def reportInstanceStatus(
                request: ReportInstanceStatusRequest
            ): IO[AwsError, Unit] = proxy(ReportInstanceStatus, request)
            def createVpcEndpointServiceConfiguration(
                request: CreateVpcEndpointServiceConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse.ReadOnly
            ] = proxy(CreateVpcEndpointServiceConfiguration, request)
            def getEbsDefaultKmsKeyId(
                request: GetEbsDefaultKmsKeyIdRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetEbsDefaultKmsKeyIdResponse.ReadOnly
            ] = proxy(GetEbsDefaultKmsKeyId, request)
            def deleteNetworkInterfacePermission(
                request: DeleteNetworkInterfacePermissionRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteNetworkInterfacePermissionResponse.ReadOnly
            ] = proxy(DeleteNetworkInterfacePermission, request)
            def describeTransitGatewayPeeringAttachments(
                request: DescribeTransitGatewayPeeringAttachmentsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly
            ] = rts.unsafeRun(
              proxy(DescribeTransitGatewayPeeringAttachments, request)
            )
            def describeTransitGatewayPeeringAttachmentsPaginated(
                request: DescribeTransitGatewayPeeringAttachmentsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse.ReadOnly
            ] =
              proxy(DescribeTransitGatewayPeeringAttachmentsPaginated, request)
            def describeReservedInstances(
                request: DescribeReservedInstancesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeReservedInstancesResponse.ReadOnly
            ] = proxy(DescribeReservedInstances, request)
            def describeLocalGatewayVirtualInterfaces(
                request: DescribeLocalGatewayVirtualInterfacesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.LocalGatewayVirtualInterface.ReadOnly
            ] = rts
              .unsafeRun(proxy(DescribeLocalGatewayVirtualInterfaces, request))
            def describeLocalGatewayVirtualInterfacesPaginated(
                request: DescribeLocalGatewayVirtualInterfacesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse.ReadOnly
            ] = proxy(DescribeLocalGatewayVirtualInterfacesPaginated, request)
            def modifySecurityGroupRules(
                request: ModifySecurityGroupRulesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifySecurityGroupRulesResponse.ReadOnly
            ] = proxy(ModifySecurityGroupRules, request)
            def createEgressOnlyInternetGateway(
                request: CreateEgressOnlyInternetGatewayRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateEgressOnlyInternetGatewayResponse.ReadOnly
            ] = proxy(CreateEgressOnlyInternetGateway, request)
            def getPasswordData(request: GetPasswordDataRequest): IO[
              AwsError,
              zio.aws.ec2.model.GetPasswordDataResponse.ReadOnly
            ] = proxy(GetPasswordData, request)
            def exportClientVpnClientCertificateRevocationList(
                request: ExportClientVpnClientCertificateRevocationListRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListResponse.ReadOnly
            ] = proxy(ExportClientVpnClientCertificateRevocationList, request)
            def purchaseScheduledInstances(
                request: PurchaseScheduledInstancesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.PurchaseScheduledInstancesResponse.ReadOnly
            ] = proxy(PurchaseScheduledInstances, request)
            def getTransitGatewayAttachmentPropagations(
                request: GetTransitGatewayAttachmentPropagationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TransitGatewayAttachmentPropagation.ReadOnly
            ] = rts.unsafeRun(
              proxy(GetTransitGatewayAttachmentPropagations, request)
            )
            def getTransitGatewayAttachmentPropagationsPaginated(
                request: GetTransitGatewayAttachmentPropagationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsResponse.ReadOnly
            ] = proxy(GetTransitGatewayAttachmentPropagationsPaginated, request)
            def describeClassicLinkInstances(
                request: DescribeClassicLinkInstancesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ClassicLinkInstance.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeClassicLinkInstances, request))
            def describeClassicLinkInstancesPaginated(
                request: DescribeClassicLinkInstancesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeClassicLinkInstancesResponse.ReadOnly
            ] = proxy(DescribeClassicLinkInstancesPaginated, request)
            def describeCoipPools(
                request: DescribeCoipPoolsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.CoipPool.ReadOnly] =
              rts.unsafeRun(proxy(DescribeCoipPools, request))
            def describeCoipPoolsPaginated(
                request: DescribeCoipPoolsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeCoipPoolsResponse.ReadOnly
            ] = proxy(DescribeCoipPoolsPaginated, request)
            def createVpcEndpointConnectionNotification(
                request: CreateVpcEndpointConnectionNotificationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationResponse.ReadOnly
            ] = proxy(CreateVpcEndpointConnectionNotification, request)
            def modifyVpnConnectionOptions(
                request: ModifyVpnConnectionOptionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse.ReadOnly
            ] = proxy(ModifyVpnConnectionOptions, request)
            def getSubnetCidrReservations(
                request: GetSubnetCidrReservationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetSubnetCidrReservationsResponse.ReadOnly
            ] = proxy(GetSubnetCidrReservations, request)
            def deleteDhcpOptions(
                request: DeleteDhcpOptionsRequest
            ): IO[AwsError, Unit] = proxy(DeleteDhcpOptions, request)
            def requestSpotInstances(request: RequestSpotInstancesRequest): IO[
              AwsError,
              zio.aws.ec2.model.RequestSpotInstancesResponse.ReadOnly
            ] = proxy(RequestSpotInstances, request)
            def deleteCustomerGateway(
                request: DeleteCustomerGatewayRequest
            ): IO[AwsError, Unit] = proxy(DeleteCustomerGateway, request)
            def deleteTransitGateway(request: DeleteTransitGatewayRequest): IO[
              AwsError,
              zio.aws.ec2.model.DeleteTransitGatewayResponse.ReadOnly
            ] = proxy(DeleteTransitGateway, request)
            def authorizeSecurityGroupIngress(
                request: AuthorizeSecurityGroupIngressRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AuthorizeSecurityGroupIngressResponse.ReadOnly
            ] = proxy(AuthorizeSecurityGroupIngress, request)
            def terminateClientVpnConnections(
                request: TerminateClientVpnConnectionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.TerminateClientVpnConnectionsResponse.ReadOnly
            ] = proxy(TerminateClientVpnConnections, request)
            def importVolume(
                request: ImportVolumeRequest
            ): IO[AwsError, zio.aws.ec2.model.ImportVolumeResponse.ReadOnly] =
              proxy(ImportVolume, request)
            def deregisterTransitGatewayMulticastGroupSources(
                request: DeregisterTransitGatewayMulticastGroupSourcesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly
            ] = proxy(DeregisterTransitGatewayMulticastGroupSources, request)
            def disassociateTransitGatewayMulticastDomain(
                request: DisassociateTransitGatewayMulticastDomainRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainResponse.ReadOnly
            ] = proxy(DisassociateTransitGatewayMulticastDomain, request)
            def describeVpcClassicLinkDnsSupport(
                request: DescribeVpcClassicLinkDnsSupportRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ClassicLinkDnsSupport.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeVpcClassicLinkDnsSupport, request))
            def describeVpcClassicLinkDnsSupportPaginated(
                request: DescribeVpcClassicLinkDnsSupportRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportResponse.ReadOnly
            ] = proxy(DescribeVpcClassicLinkDnsSupportPaginated, request)
            def describeInstanceEventWindows(
                request: DescribeInstanceEventWindowsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.InstanceEventWindow.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeInstanceEventWindows, request))
            def describeInstanceEventWindowsPaginated(
                request: DescribeInstanceEventWindowsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeInstanceEventWindowsResponse.ReadOnly
            ] = proxy(DescribeInstanceEventWindowsPaginated, request)
            def applySecurityGroupsToClientVpnTargetNetwork(
                request: ApplySecurityGroupsToClientVpnTargetNetworkRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse.ReadOnly
            ] = proxy(ApplySecurityGroupsToClientVpnTargetNetwork, request)
            def createSnapshots(request: CreateSnapshotsRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateSnapshotsResponse.ReadOnly
            ] = proxy(CreateSnapshots, request)
            def rejectVpcEndpointConnections(
                request: RejectVpcEndpointConnectionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RejectVpcEndpointConnectionsResponse.ReadOnly
            ] = proxy(RejectVpcEndpointConnections, request)
            def copySnapshot(
                request: CopySnapshotRequest
            ): IO[AwsError, zio.aws.ec2.model.CopySnapshotResponse.ReadOnly] =
              proxy(CopySnapshot, request)
            def describeInstanceTypeOfferings(
                request: DescribeInstanceTypeOfferingsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.InstanceTypeOffering.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeInstanceTypeOfferings, request))
            def describeInstanceTypeOfferingsPaginated(
                request: DescribeInstanceTypeOfferingsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeInstanceTypeOfferingsResponse.ReadOnly
            ] = proxy(DescribeInstanceTypeOfferingsPaginated, request)
            def deleteManagedPrefixList(
                request: DeleteManagedPrefixListRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteManagedPrefixListResponse.ReadOnly
            ] = proxy(DeleteManagedPrefixList, request)
            def deleteTransitGatewayRouteTable(
                request: DeleteTransitGatewayRouteTableRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteTransitGatewayRouteTableResponse.ReadOnly
            ] = proxy(DeleteTransitGatewayRouteTable, request)
            def describeHosts(
                request: DescribeHostsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.Host.ReadOnly] =
              rts.unsafeRun(proxy(DescribeHosts, request))
            def describeHostsPaginated(
                request: DescribeHostsRequest
            ): IO[AwsError, zio.aws.ec2.model.DescribeHostsResponse.ReadOnly] =
              proxy(DescribeHostsPaginated, request)
            def modifyIdFormat(
                request: ModifyIdFormatRequest
            ): IO[AwsError, Unit] = proxy(ModifyIdFormat, request)
            def disableFastLaunch(request: DisableFastLaunchRequest): IO[
              AwsError,
              zio.aws.ec2.model.DisableFastLaunchResponse.ReadOnly
            ] = proxy(DisableFastLaunch, request)
            def getGroupsForCapacityReservation(
                request: GetGroupsForCapacityReservationRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.CapacityReservationGroup.ReadOnly
            ] = rts.unsafeRun(proxy(GetGroupsForCapacityReservation, request))
            def getGroupsForCapacityReservationPaginated(
                request: GetGroupsForCapacityReservationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetGroupsForCapacityReservationResponse.ReadOnly
            ] = proxy(GetGroupsForCapacityReservationPaginated, request)
            def disableEbsEncryptionByDefault(
                request: DisableEbsEncryptionByDefaultRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisableEbsEncryptionByDefaultResponse.ReadOnly
            ] = proxy(DisableEbsEncryptionByDefault, request)
            def createTransitGatewayPeeringAttachment(
                request: CreateTransitGatewayPeeringAttachmentRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentResponse.ReadOnly
            ] = proxy(CreateTransitGatewayPeeringAttachment, request)
            def describeVpnGateways(request: DescribeVpnGatewaysRequest): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVpnGatewaysResponse.ReadOnly
            ] = proxy(DescribeVpnGateways, request)
            def deprovisionByoipCidr(request: DeprovisionByoipCidrRequest): IO[
              AwsError,
              zio.aws.ec2.model.DeprovisionByoipCidrResponse.ReadOnly
            ] = proxy(DeprovisionByoipCidr, request)
            def describeSubnets(
                request: DescribeSubnetsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.Subnet.ReadOnly] =
              rts.unsafeRun(proxy(DescribeSubnets, request))
            def describeSubnetsPaginated(request: DescribeSubnetsRequest): IO[
              AwsError,
              zio.aws.ec2.model.DescribeSubnetsResponse.ReadOnly
            ] = proxy(DescribeSubnetsPaginated, request)
            def describeSpotFleetRequestHistory(
                request: DescribeSpotFleetRequestHistoryRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.ReadOnly,
              zio.aws.ec2.model.HistoryRecord.ReadOnly
            ]] = proxy(DescribeSpotFleetRequestHistory, request)
            def describeSpotFleetRequestHistoryPaginated(
                request: DescribeSpotFleetRequestHistoryRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.ReadOnly
            ] = proxy(DescribeSpotFleetRequestHistoryPaginated, request)
            def unmonitorInstances(request: UnmonitorInstancesRequest): IO[
              AwsError,
              zio.aws.ec2.model.UnmonitorInstancesResponse.ReadOnly
            ] = proxy(UnmonitorInstances, request)
            def createManagedPrefixList(
                request: CreateManagedPrefixListRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateManagedPrefixListResponse.ReadOnly
            ] = proxy(CreateManagedPrefixList, request)
            def describeTransitGatewayConnectPeers(
                request: DescribeTransitGatewayConnectPeersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly
            ] =
              rts.unsafeRun(proxy(DescribeTransitGatewayConnectPeers, request))
            def describeTransitGatewayConnectPeersPaginated(
                request: DescribeTransitGatewayConnectPeersRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeTransitGatewayConnectPeersResponse.ReadOnly
            ] = proxy(DescribeTransitGatewayConnectPeersPaginated, request)
            def describeTransitGatewayConnects(
                request: DescribeTransitGatewayConnectsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TransitGatewayConnect.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeTransitGatewayConnects, request))
            def describeTransitGatewayConnectsPaginated(
                request: DescribeTransitGatewayConnectsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeTransitGatewayConnectsResponse.ReadOnly
            ] = proxy(DescribeTransitGatewayConnectsPaginated, request)
            def createIpamScope(request: CreateIpamScopeRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateIpamScopeResponse.ReadOnly
            ] = proxy(CreateIpamScope, request)
            def describeTrafficMirrorTargets(
                request: DescribeTrafficMirrorTargetsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeTrafficMirrorTargets, request))
            def describeTrafficMirrorTargetsPaginated(
                request: DescribeTrafficMirrorTargetsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeTrafficMirrorTargetsResponse.ReadOnly
            ] = proxy(DescribeTrafficMirrorTargetsPaginated, request)
            def deleteVpcEndpoints(request: DeleteVpcEndpointsRequest): IO[
              AwsError,
              zio.aws.ec2.model.DeleteVpcEndpointsResponse.ReadOnly
            ] = proxy(DeleteVpcEndpoints, request)
            def disassociateIamInstanceProfile(
                request: DisassociateIamInstanceProfileRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisassociateIamInstanceProfileResponse.ReadOnly
            ] = proxy(DisassociateIamInstanceProfile, request)
            def modifyFleet(
                request: ModifyFleetRequest
            ): IO[AwsError, zio.aws.ec2.model.ModifyFleetResponse.ReadOnly] =
              proxy(ModifyFleet, request)
            def describeVpcEndpointServiceConfigurations(
                request: DescribeVpcEndpointServiceConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ServiceConfiguration.ReadOnly
            ] = rts.unsafeRun(
              proxy(DescribeVpcEndpointServiceConfigurations, request)
            )
            def describeVpcEndpointServiceConfigurationsPaginated(
                request: DescribeVpcEndpointServiceConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse.ReadOnly
            ] =
              proxy(DescribeVpcEndpointServiceConfigurationsPaginated, request)
            def modifyVpcEndpointServicePayerResponsibility(
                request: ModifyVpcEndpointServicePayerResponsibilityRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyVpcEndpointServicePayerResponsibilityResponse.ReadOnly
            ] = proxy(ModifyVpcEndpointServicePayerResponsibility, request)
            def deleteNetworkAclEntry(
                request: DeleteNetworkAclEntryRequest
            ): IO[AwsError, Unit] = proxy(DeleteNetworkAclEntry, request)
            def updateSecurityGroupRuleDescriptionsIngress(
                request: UpdateSecurityGroupRuleDescriptionsIngressRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressResponse.ReadOnly
            ] = proxy(UpdateSecurityGroupRuleDescriptionsIngress, request)
            def describeCapacityReservations(
                request: DescribeCapacityReservationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.CapacityReservation.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeCapacityReservations, request))
            def describeCapacityReservationsPaginated(
                request: DescribeCapacityReservationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeCapacityReservationsResponse.ReadOnly
            ] = proxy(DescribeCapacityReservationsPaginated, request)
            def createTransitGatewayMulticastDomain(
                request: CreateTransitGatewayMulticastDomainRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateTransitGatewayMulticastDomainResponse.ReadOnly
            ] = proxy(CreateTransitGatewayMulticastDomain, request)
            def startVpcEndpointServicePrivateDnsVerification(
                request: StartVpcEndpointServicePrivateDnsVerificationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse.ReadOnly
            ] = proxy(StartVpcEndpointServicePrivateDnsVerification, request)
            def createLaunchTemplate(request: CreateLaunchTemplateRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateLaunchTemplateResponse.ReadOnly
            ] = proxy(CreateLaunchTemplate, request)
            def deleteTrafficMirrorFilter(
                request: DeleteTrafficMirrorFilterRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteTrafficMirrorFilterResponse.ReadOnly
            ] = proxy(DeleteTrafficMirrorFilter, request)
            def describeLocalGatewayRouteTables(
                request: DescribeLocalGatewayRouteTablesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeLocalGatewayRouteTables, request))
            def describeLocalGatewayRouteTablesPaginated(
                request: DescribeLocalGatewayRouteTablesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse.ReadOnly
            ] = proxy(DescribeLocalGatewayRouteTablesPaginated, request)
            def describeNetworkInterfaceAttribute(
                request: DescribeNetworkInterfaceAttributeRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse.ReadOnly
            ] = proxy(DescribeNetworkInterfaceAttribute, request)
            def createCapacityReservationFleet(
                request: CreateCapacityReservationFleetRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateCapacityReservationFleetResponse.ReadOnly
            ] = proxy(CreateCapacityReservationFleet, request)
            def deleteLaunchTemplate(request: DeleteLaunchTemplateRequest): IO[
              AwsError,
              zio.aws.ec2.model.DeleteLaunchTemplateResponse.ReadOnly
            ] = proxy(DeleteLaunchTemplate, request)
            def replaceNetworkAclAssociation(
                request: ReplaceNetworkAclAssociationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ReplaceNetworkAclAssociationResponse.ReadOnly
            ] = proxy(ReplaceNetworkAclAssociation, request)
            def getManagedPrefixListAssociations(
                request: GetManagedPrefixListAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.PrefixListAssociation.ReadOnly
            ] = rts.unsafeRun(proxy(GetManagedPrefixListAssociations, request))
            def getManagedPrefixListAssociationsPaginated(
                request: GetManagedPrefixListAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse.ReadOnly
            ] = proxy(GetManagedPrefixListAssociationsPaginated, request)
            def createNetworkAcl(request: CreateNetworkAclRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateNetworkAclResponse.ReadOnly
            ] = proxy(CreateNetworkAcl, request)
            def describeVpcEndpointConnections(
                request: DescribeVpcEndpointConnectionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.VpcEndpointConnection.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeVpcEndpointConnections, request))
            def describeVpcEndpointConnectionsPaginated(
                request: DescribeVpcEndpointConnectionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVpcEndpointConnectionsResponse.ReadOnly
            ] = proxy(DescribeVpcEndpointConnectionsPaginated, request)
            def createLocalGatewayRouteTableVpcAssociation(
                request: CreateLocalGatewayRouteTableVpcAssociationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse.ReadOnly
            ] = proxy(CreateLocalGatewayRouteTableVpcAssociation, request)
            def describeVpcAttribute(request: DescribeVpcAttributeRequest): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVpcAttributeResponse.ReadOnly
            ] = proxy(DescribeVpcAttribute, request)
            def describeStoreImageTasks(
                request: DescribeStoreImageTasksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.StoreImageTaskResult.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeStoreImageTasks, request))
            def describeStoreImageTasksPaginated(
                request: DescribeStoreImageTasksRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeStoreImageTasksResponse.ReadOnly
            ] = proxy(DescribeStoreImageTasksPaginated, request)
            def describeFastSnapshotRestores(
                request: DescribeFastSnapshotRestoresRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.DescribeFastSnapshotRestoreSuccessItem.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeFastSnapshotRestores, request))
            def describeFastSnapshotRestoresPaginated(
                request: DescribeFastSnapshotRestoresRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeFastSnapshotRestoresResponse.ReadOnly
            ] = proxy(DescribeFastSnapshotRestoresPaginated, request)
            def modifyInstancePlacement(
                request: ModifyInstancePlacementRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyInstancePlacementResponse.ReadOnly
            ] = proxy(ModifyInstancePlacement, request)
            def createIpamPool(
                request: CreateIpamPoolRequest
            ): IO[AwsError, zio.aws.ec2.model.CreateIpamPoolResponse.ReadOnly] =
              proxy(CreateIpamPool, request)
            def modifySnapshotTier(request: ModifySnapshotTierRequest): IO[
              AwsError,
              zio.aws.ec2.model.ModifySnapshotTierResponse.ReadOnly
            ] = proxy(ModifySnapshotTier, request)
            def describeSpotFleetRequests(
                request: DescribeSpotFleetRequestsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.SpotFleetRequestConfig.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeSpotFleetRequests, request))
            def describeSpotFleetRequestsPaginated(
                request: DescribeSpotFleetRequestsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeSpotFleetRequestsResponse.ReadOnly
            ] = proxy(DescribeSpotFleetRequestsPaginated, request)
            def getTransitGatewayRouteTableAssociations(
                request: GetTransitGatewayRouteTableAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TransitGatewayRouteTableAssociation.ReadOnly
            ] = rts.unsafeRun(
              proxy(GetTransitGatewayRouteTableAssociations, request)
            )
            def getTransitGatewayRouteTableAssociationsPaginated(
                request: GetTransitGatewayRouteTableAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsResponse.ReadOnly
            ] = proxy(GetTransitGatewayRouteTableAssociationsPaginated, request)
            def releaseIpamPoolAllocation(
                request: ReleaseIpamPoolAllocationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ReleaseIpamPoolAllocationResponse.ReadOnly
            ] = proxy(ReleaseIpamPoolAllocation, request)
            def registerImage(
                request: RegisterImageRequest
            ): IO[AwsError, zio.aws.ec2.model.RegisterImageResponse.ReadOnly] =
              proxy(RegisterImage, request)
            def createDhcpOptions(request: CreateDhcpOptionsRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateDhcpOptionsResponse.ReadOnly
            ] = proxy(CreateDhcpOptions, request)
            def describeReservedInstancesModifications(
                request: DescribeReservedInstancesModificationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ReservedInstancesModification.ReadOnly
            ] = rts
              .unsafeRun(proxy(DescribeReservedInstancesModifications, request))
            def describeReservedInstancesModificationsPaginated(
                request: DescribeReservedInstancesModificationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeReservedInstancesModificationsResponse.ReadOnly
            ] = proxy(DescribeReservedInstancesModificationsPaginated, request)
            def describeSpotDatafeedSubscription(
                request: DescribeSpotDatafeedSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionResponse.ReadOnly
            ] = proxy(DescribeSpotDatafeedSubscription, request)
            def describeNetworkInsightsAccessScopeAnalyses(
                request: DescribeNetworkInsightsAccessScopeAnalysesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly
            ] = rts.unsafeRun(
              proxy(DescribeNetworkInsightsAccessScopeAnalyses, request)
            )
            def describeNetworkInsightsAccessScopeAnalysesPaginated(
                request: DescribeNetworkInsightsAccessScopeAnalysesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse.ReadOnly
            ] = proxy(
              DescribeNetworkInsightsAccessScopeAnalysesPaginated,
              request
            )
            def createTrafficMirrorFilterRule(
                request: CreateTrafficMirrorFilterRuleRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateTrafficMirrorFilterRuleResponse.ReadOnly
            ] = proxy(CreateTrafficMirrorFilterRule, request)
            def searchLocalGatewayRoutes(
                request: SearchLocalGatewayRoutesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.LocalGatewayRoute.ReadOnly
            ] = rts.unsafeRun(proxy(SearchLocalGatewayRoutes, request))
            def searchLocalGatewayRoutesPaginated(
                request: SearchLocalGatewayRoutesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.SearchLocalGatewayRoutesResponse.ReadOnly
            ] = proxy(SearchLocalGatewayRoutesPaginated, request)
            def describeHostReservationOfferings(
                request: DescribeHostReservationOfferingsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.HostOffering.ReadOnly] =
              rts.unsafeRun(proxy(DescribeHostReservationOfferings, request))
            def describeHostReservationOfferingsPaginated(
                request: DescribeHostReservationOfferingsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeHostReservationOfferingsResponse.ReadOnly
            ] = proxy(DescribeHostReservationOfferingsPaginated, request)
            def modifyIpam(
                request: ModifyIpamRequest
            ): IO[AwsError, zio.aws.ec2.model.ModifyIpamResponse.ReadOnly] =
              proxy(ModifyIpam, request)
            def disableVpcClassicLink(
                request: DisableVpcClassicLinkRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisableVpcClassicLinkResponse.ReadOnly
            ] = proxy(DisableVpcClassicLink, request)
            def getNetworkInsightsAccessScopeContent(
                request: GetNetworkInsightsAccessScopeContentRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentResponse.ReadOnly
            ] = proxy(GetNetworkInsightsAccessScopeContent, request)
            def createCapacityReservation(
                request: CreateCapacityReservationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateCapacityReservationResponse.ReadOnly
            ] = proxy(CreateCapacityReservation, request)
            def modifyAddressAttribute(
                request: ModifyAddressAttributeRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyAddressAttributeResponse.ReadOnly
            ] = proxy(ModifyAddressAttribute, request)
            def createNetworkInterfacePermission(
                request: CreateNetworkInterfacePermissionRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateNetworkInterfacePermissionResponse.ReadOnly
            ] = proxy(CreateNetworkInterfacePermission, request)
            def describeLaunchTemplateVersions(
                request: DescribeLaunchTemplateVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeLaunchTemplateVersions, request))
            def describeLaunchTemplateVersionsPaginated(
                request: DescribeLaunchTemplateVersionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeLaunchTemplateVersionsResponse.ReadOnly
            ] = proxy(DescribeLaunchTemplateVersionsPaginated, request)
            def allocateHosts(
                request: AllocateHostsRequest
            ): IO[AwsError, zio.aws.ec2.model.AllocateHostsResponse.ReadOnly] =
              proxy(AllocateHosts, request)
            def describeExportImageTasks(
                request: DescribeExportImageTasksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ExportImageTask.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeExportImageTasks, request))
            def describeExportImageTasksPaginated(
                request: DescribeExportImageTasksRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeExportImageTasksResponse.ReadOnly
            ] = proxy(DescribeExportImageTasksPaginated, request)
            def describeSpotFleetInstances(
                request: DescribeSpotFleetInstancesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.ReadOnly,
              zio.aws.ec2.model.ActiveInstance.ReadOnly
            ]] = proxy(DescribeSpotFleetInstances, request)
            def describeSpotFleetInstancesPaginated(
                request: DescribeSpotFleetInstancesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.ReadOnly
            ] = proxy(DescribeSpotFleetInstancesPaginated, request)
            def rejectTransitGatewayVpcAttachment(
                request: RejectTransitGatewayVpcAttachmentRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentResponse.ReadOnly
            ] = proxy(RejectTransitGatewayVpcAttachment, request)
            def describeByoipCidrs(
                request: DescribeByoipCidrsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.ByoipCidr.ReadOnly] =
              rts.unsafeRun(proxy(DescribeByoipCidrs, request))
            def describeByoipCidrsPaginated(
                request: DescribeByoipCidrsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeByoipCidrsResponse.ReadOnly
            ] = proxy(DescribeByoipCidrsPaginated, request)
            def moveAddressToVpc(request: MoveAddressToVpcRequest): IO[
              AwsError,
              zio.aws.ec2.model.MoveAddressToVpcResponse.ReadOnly
            ] = proxy(MoveAddressToVpc, request)
            def disassociateAddress(
                request: DisassociateAddressRequest
            ): IO[AwsError, Unit] = proxy(DisassociateAddress, request)
            def resetFpgaImageAttribute(
                request: ResetFpgaImageAttributeRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ResetFpgaImageAttributeResponse.ReadOnly
            ] = proxy(ResetFpgaImageAttribute, request)
            def modifyImageAttribute(
                request: ModifyImageAttributeRequest
            ): IO[AwsError, Unit] = proxy(ModifyImageAttribute, request)
            def restoreSnapshotFromRecycleBin(
                request: RestoreSnapshotFromRecycleBinRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse.ReadOnly
            ] = proxy(RestoreSnapshotFromRecycleBin, request)
            def exportClientVpnClientConfiguration(
                request: ExportClientVpnClientConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ExportClientVpnClientConfigurationResponse.ReadOnly
            ] = proxy(ExportClientVpnClientConfiguration, request)
            def restoreSnapshotTier(request: RestoreSnapshotTierRequest): IO[
              AwsError,
              zio.aws.ec2.model.RestoreSnapshotTierResponse.ReadOnly
            ] = proxy(RestoreSnapshotTier, request)
            def registerTransitGatewayMulticastGroupSources(
                request: RegisterTransitGatewayMulticastGroupSourcesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly
            ] = proxy(RegisterTransitGatewayMulticastGroupSources, request)
            def deleteNetworkInterface(
                request: DeleteNetworkInterfaceRequest
            ): IO[AwsError, Unit] = proxy(DeleteNetworkInterface, request)
            def provisionPublicIpv4PoolCidr(
                request: ProvisionPublicIpv4PoolCidrRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrResponse.ReadOnly
            ] = proxy(ProvisionPublicIpv4PoolCidr, request)
            def describeVolumes(
                request: DescribeVolumesRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.Volume.ReadOnly] =
              rts.unsafeRun(proxy(DescribeVolumes, request))
            def describeVolumesPaginated(request: DescribeVolumesRequest): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVolumesResponse.ReadOnly
            ] = proxy(DescribeVolumesPaginated, request)
            def modifyTransitGatewayPrefixListReference(
                request: ModifyTransitGatewayPrefixListReferenceRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse.ReadOnly
            ] = proxy(ModifyTransitGatewayPrefixListReference, request)
            def createFlowLogs(
                request: CreateFlowLogsRequest
            ): IO[AwsError, zio.aws.ec2.model.CreateFlowLogsResponse.ReadOnly] =
              proxy(CreateFlowLogs, request)
            def modifyIpamScope(request: ModifyIpamScopeRequest): IO[
              AwsError,
              zio.aws.ec2.model.ModifyIpamScopeResponse.ReadOnly
            ] = proxy(ModifyIpamScope, request)
            def purchaseHostReservation(
                request: PurchaseHostReservationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.PurchaseHostReservationResponse.ReadOnly
            ] = proxy(PurchaseHostReservation, request)
            def describeStaleSecurityGroups(
                request: DescribeStaleSecurityGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.StaleSecurityGroup.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeStaleSecurityGroups, request))
            def describeStaleSecurityGroupsPaginated(
                request: DescribeStaleSecurityGroupsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeStaleSecurityGroupsResponse.ReadOnly
            ] = proxy(DescribeStaleSecurityGroupsPaginated, request)
            def createVolume(
                request: CreateVolumeRequest
            ): IO[AwsError, zio.aws.ec2.model.CreateVolumeResponse.ReadOnly] =
              proxy(CreateVolume, request)
            def runInstances(
                request: RunInstancesRequest
            ): IO[AwsError, zio.aws.ec2.model.RunInstancesResponse.ReadOnly] =
              proxy(RunInstances, request)
            def describeReplaceRootVolumeTasks(
                request: DescribeReplaceRootVolumeTasksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeReplaceRootVolumeTasks, request))
            def describeReplaceRootVolumeTasksPaginated(
                request: DescribeReplaceRootVolumeTasksRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeReplaceRootVolumeTasksResponse.ReadOnly
            ] = proxy(DescribeReplaceRootVolumeTasksPaginated, request)
            def associateDhcpOptions(
                request: AssociateDhcpOptionsRequest
            ): IO[AwsError, Unit] = proxy(AssociateDhcpOptions, request)
            def createRouteTable(request: CreateRouteTableRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateRouteTableResponse.ReadOnly
            ] = proxy(CreateRouteTable, request)
            def deleteVpcPeeringConnection(
                request: DeleteVpcPeeringConnectionRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteVpcPeeringConnectionResponse.ReadOnly
            ] = proxy(DeleteVpcPeeringConnection, request)
            def describePublicIpv4Pools(
                request: DescribePublicIpv4PoolsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.PublicIpv4Pool.ReadOnly
            ] = rts.unsafeRun(proxy(DescribePublicIpv4Pools, request))
            def describePublicIpv4PoolsPaginated(
                request: DescribePublicIpv4PoolsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribePublicIpv4PoolsResponse.ReadOnly
            ] = proxy(DescribePublicIpv4PoolsPaginated, request)
            def modifyAvailabilityZoneGroup(
                request: ModifyAvailabilityZoneGroupRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyAvailabilityZoneGroupResponse.ReadOnly
            ] = proxy(ModifyAvailabilityZoneGroup, request)
            def createClientVpnEndpoint(
                request: CreateClientVpnEndpointRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateClientVpnEndpointResponse.ReadOnly
            ] = proxy(CreateClientVpnEndpoint, request)
            def deleteSnapshot(
                request: DeleteSnapshotRequest
            ): IO[AwsError, Unit] = proxy(DeleteSnapshot, request)
            def createTrafficMirrorFilter(
                request: CreateTrafficMirrorFilterRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateTrafficMirrorFilterResponse.ReadOnly
            ] = proxy(CreateTrafficMirrorFilter, request)
            def createReservedInstancesListing(
                request: CreateReservedInstancesListingRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateReservedInstancesListingResponse.ReadOnly
            ] = proxy(CreateReservedInstancesListing, request)
            def assignIpv6Addresses(request: AssignIpv6AddressesRequest): IO[
              AwsError,
              zio.aws.ec2.model.AssignIpv6AddressesResponse.ReadOnly
            ] = proxy(AssignIpv6Addresses, request)
            def getVpnConnectionDeviceTypes(
                request: GetVpnConnectionDeviceTypesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.VpnConnectionDeviceType.ReadOnly
            ] = rts.unsafeRun(proxy(GetVpnConnectionDeviceTypes, request))
            def getVpnConnectionDeviceTypesPaginated(
                request: GetVpnConnectionDeviceTypesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetVpnConnectionDeviceTypesResponse.ReadOnly
            ] = proxy(GetVpnConnectionDeviceTypesPaginated, request)
            def describeSecurityGroupReferences(
                request: DescribeSecurityGroupReferencesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeSecurityGroupReferencesResponse.ReadOnly
            ] = proxy(DescribeSecurityGroupReferences, request)
            def describeImages(
                request: DescribeImagesRequest
            ): IO[AwsError, zio.aws.ec2.model.DescribeImagesResponse.ReadOnly] =
              proxy(DescribeImages, request)
            def requestSpotFleet(request: RequestSpotFleetRequest): IO[
              AwsError,
              zio.aws.ec2.model.RequestSpotFleetResponse.ReadOnly
            ] = proxy(RequestSpotFleet, request)
            def acceptTransitGatewayMulticastDomainAssociations(
                request: AcceptTransitGatewayMulticastDomainAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
            ] = proxy(AcceptTransitGatewayMulticastDomainAssociations, request)
            def deletePublicIpv4Pool(request: DeletePublicIpv4PoolRequest): IO[
              AwsError,
              zio.aws.ec2.model.DeletePublicIpv4PoolResponse.ReadOnly
            ] = proxy(DeletePublicIpv4Pool, request)
            def updateSecurityGroupRuleDescriptionsEgress(
                request: UpdateSecurityGroupRuleDescriptionsEgressRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse.ReadOnly
            ] = proxy(UpdateSecurityGroupRuleDescriptionsEgress, request)
            def replaceRoute(request: ReplaceRouteRequest): IO[AwsError, Unit] =
              proxy(ReplaceRoute, request)
            def createNetworkInsightsPath(
                request: CreateNetworkInsightsPathRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateNetworkInsightsPathResponse.ReadOnly
            ] = proxy(CreateNetworkInsightsPath, request)
            def deleteQueuedReservedInstances(
                request: DeleteQueuedReservedInstancesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteQueuedReservedInstancesResponse.ReadOnly
            ] = proxy(DeleteQueuedReservedInstances, request)
            def disassociateInstanceEventWindow(
                request: DisassociateInstanceEventWindowRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisassociateInstanceEventWindowResponse.ReadOnly
            ] = proxy(DisassociateInstanceEventWindow, request)
            def getConsoleOutput(request: GetConsoleOutputRequest): IO[
              AwsError,
              zio.aws.ec2.model.GetConsoleOutputResponse.ReadOnly
            ] = proxy(GetConsoleOutput, request)
            def createStoreImageTask(request: CreateStoreImageTaskRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateStoreImageTaskResponse.ReadOnly
            ] = proxy(CreateStoreImageTask, request)
            def getReservedInstancesExchangeQuote(
                request: GetReservedInstancesExchangeQuoteRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetReservedInstancesExchangeQuoteResponse.ReadOnly
            ] = proxy(GetReservedInstancesExchangeQuote, request)
            def attachVpnGateway(request: AttachVpnGatewayRequest): IO[
              AwsError,
              zio.aws.ec2.model.AttachVpnGatewayResponse.ReadOnly
            ] = proxy(AttachVpnGateway, request)
            def modifyVpnConnection(request: ModifyVpnConnectionRequest): IO[
              AwsError,
              zio.aws.ec2.model.ModifyVpnConnectionResponse.ReadOnly
            ] = proxy(ModifyVpnConnection, request)
            def getDefaultCreditSpecification(
                request: GetDefaultCreditSpecificationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetDefaultCreditSpecificationResponse.ReadOnly
            ] = proxy(GetDefaultCreditSpecification, request)
            def createImage(
                request: CreateImageRequest
            ): IO[AwsError, zio.aws.ec2.model.CreateImageResponse.ReadOnly] =
              proxy(CreateImage, request)
            def disableTransitGatewayRouteTablePropagation(
                request: DisableTransitGatewayRouteTablePropagationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationResponse.ReadOnly
            ] = proxy(DisableTransitGatewayRouteTablePropagation, request)
            def createFleet(
                request: CreateFleetRequest
            ): IO[AwsError, zio.aws.ec2.model.CreateFleetResponse.ReadOnly] =
              proxy(CreateFleet, request)
            def createSubnet(
                request: CreateSubnetRequest
            ): IO[AwsError, zio.aws.ec2.model.CreateSubnetResponse.ReadOnly] =
              proxy(CreateSubnet, request)
            def listSnapshotsInRecycleBin(
                request: ListSnapshotsInRecycleBinRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.SnapshotRecycleBinInfo.ReadOnly
            ] = rts.unsafeRun(proxy(ListSnapshotsInRecycleBin, request))
            def listSnapshotsInRecycleBinPaginated(
                request: ListSnapshotsInRecycleBinRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ListSnapshotsInRecycleBinResponse.ReadOnly
            ] = proxy(ListSnapshotsInRecycleBinPaginated, request)
            def describeAggregateIdFormat(
                request: DescribeAggregateIdFormatRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeAggregateIdFormatResponse.ReadOnly
            ] = proxy(DescribeAggregateIdFormat, request)
            def createNetworkInsightsAccessScope(
                request: CreateNetworkInsightsAccessScopeRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateNetworkInsightsAccessScopeResponse.ReadOnly
            ] = proxy(CreateNetworkInsightsAccessScope, request)
            def modifySpotFleetRequest(
                request: ModifySpotFleetRequestRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifySpotFleetRequestResponse.ReadOnly
            ] = proxy(ModifySpotFleetRequest, request)
            def modifyCapacityReservationFleet(
                request: ModifyCapacityReservationFleetRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyCapacityReservationFleetResponse.ReadOnly
            ] = proxy(ModifyCapacityReservationFleet, request)
            def describeIpv6Pools(
                request: DescribeIpv6PoolsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.Ipv6Pool.ReadOnly] =
              rts.unsafeRun(proxy(DescribeIpv6Pools, request))
            def describeIpv6PoolsPaginated(
                request: DescribeIpv6PoolsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeIpv6PoolsResponse.ReadOnly
            ] = proxy(DescribeIpv6PoolsPaginated, request)
            def stopInstances(
                request: StopInstancesRequest
            ): IO[AwsError, zio.aws.ec2.model.StopInstancesResponse.ReadOnly] =
              proxy(StopInstances, request)
            def describeExportTasks(request: DescribeExportTasksRequest): IO[
              AwsError,
              zio.aws.ec2.model.DescribeExportTasksResponse.ReadOnly
            ] = proxy(DescribeExportTasks, request)
            def restoreManagedPrefixListVersion(
                request: RestoreManagedPrefixListVersionRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RestoreManagedPrefixListVersionResponse.ReadOnly
            ] = proxy(RestoreManagedPrefixListVersion, request)
            def describeBundleTasks(request: DescribeBundleTasksRequest): IO[
              AwsError,
              zio.aws.ec2.model.DescribeBundleTasksResponse.ReadOnly
            ] = proxy(DescribeBundleTasks, request)
            def describeClientVpnRoutes(
                request: DescribeClientVpnRoutesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ClientVpnRoute.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeClientVpnRoutes, request))
            def describeClientVpnRoutesPaginated(
                request: DescribeClientVpnRoutesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeClientVpnRoutesResponse.ReadOnly
            ] = proxy(DescribeClientVpnRoutesPaginated, request)
            def describeIamInstanceProfileAssociations(
                request: DescribeIamInstanceProfileAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly
            ] = rts
              .unsafeRun(proxy(DescribeIamInstanceProfileAssociations, request))
            def describeIamInstanceProfileAssociationsPaginated(
                request: DescribeIamInstanceProfileAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse.ReadOnly
            ] = proxy(DescribeIamInstanceProfileAssociationsPaginated, request)
            def deleteIpam(
                request: DeleteIpamRequest
            ): IO[AwsError, zio.aws.ec2.model.DeleteIpamResponse.ReadOnly] =
              proxy(DeleteIpam, request)
            def attachVolume(
                request: AttachVolumeRequest
            ): IO[AwsError, zio.aws.ec2.model.AttachVolumeResponse.ReadOnly] =
              proxy(AttachVolume, request)
            def createClientVpnRoute(request: CreateClientVpnRouteRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateClientVpnRouteResponse.ReadOnly
            ] = proxy(CreateClientVpnRoute, request)
            def acceptTransitGatewayPeeringAttachment(
                request: AcceptTransitGatewayPeeringAttachmentRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse.ReadOnly
            ] = proxy(AcceptTransitGatewayPeeringAttachment, request)
            def describeNetworkInterfaces(
                request: DescribeNetworkInterfacesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.NetworkInterface.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeNetworkInterfaces, request))
            def describeNetworkInterfacesPaginated(
                request: DescribeNetworkInterfacesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeNetworkInterfacesResponse.ReadOnly
            ] = proxy(DescribeNetworkInterfacesPaginated, request)
            def describeLocalGatewayVirtualInterfaceGroups(
                request: DescribeLocalGatewayVirtualInterfaceGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup.ReadOnly
            ] = rts.unsafeRun(
              proxy(DescribeLocalGatewayVirtualInterfaceGroups, request)
            )
            def describeLocalGatewayVirtualInterfaceGroupsPaginated(
                request: DescribeLocalGatewayVirtualInterfaceGroupsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse.ReadOnly
            ] = proxy(
              DescribeLocalGatewayVirtualInterfaceGroupsPaginated,
              request
            )
            def getInstanceUefiData(request: GetInstanceUefiDataRequest): IO[
              AwsError,
              zio.aws.ec2.model.GetInstanceUefiDataResponse.ReadOnly
            ] = proxy(GetInstanceUefiData, request)
            def modifyTrafficMirrorSession(
                request: ModifyTrafficMirrorSessionRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse.ReadOnly
            ] = proxy(ModifyTrafficMirrorSession, request)
            def disassociateVpcCidrBlock(
                request: DisassociateVpcCidrBlockRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisassociateVpcCidrBlockResponse.ReadOnly
            ] = proxy(DisassociateVpcCidrBlock, request)
            def disableVpcClassicLinkDnsSupport(
                request: DisableVpcClassicLinkDnsSupportRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisableVpcClassicLinkDnsSupportResponse.ReadOnly
            ] = proxy(DisableVpcClassicLinkDnsSupport, request)
            def deleteClientVpnRoute(request: DeleteClientVpnRouteRequest): IO[
              AwsError,
              zio.aws.ec2.model.DeleteClientVpnRouteResponse.ReadOnly
            ] = proxy(DeleteClientVpnRoute, request)
            def createTransitGatewayConnect(
                request: CreateTransitGatewayConnectRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateTransitGatewayConnectResponse.ReadOnly
            ] = proxy(CreateTransitGatewayConnect, request)
            def createReplaceRootVolumeTask(
                request: CreateReplaceRootVolumeTaskRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateReplaceRootVolumeTaskResponse.ReadOnly
            ] = proxy(CreateReplaceRootVolumeTask, request)
            def cancelImportTask(request: CancelImportTaskRequest): IO[
              AwsError,
              zio.aws.ec2.model.CancelImportTaskResponse.ReadOnly
            ] = proxy(CancelImportTask, request)
            def describeVpcClassicLink(
                request: DescribeVpcClassicLinkRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVpcClassicLinkResponse.ReadOnly
            ] = proxy(DescribeVpcClassicLink, request)
            def modifyHosts(
                request: ModifyHostsRequest
            ): IO[AwsError, zio.aws.ec2.model.ModifyHostsResponse.ReadOnly] =
              proxy(ModifyHosts, request)
            def createRestoreImageTask(
                request: CreateRestoreImageTaskRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateRestoreImageTaskResponse.ReadOnly
            ] = proxy(CreateRestoreImageTask, request)
            def describeTransitGatewayAttachments(
                request: DescribeTransitGatewayAttachmentsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TransitGatewayAttachment.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeTransitGatewayAttachments, request))
            def describeTransitGatewayAttachmentsPaginated(
                request: DescribeTransitGatewayAttachmentsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeTransitGatewayAttachmentsResponse.ReadOnly
            ] = proxy(DescribeTransitGatewayAttachmentsPaginated, request)
            def deleteVpcEndpointServiceConfigurations(
                request: DeleteVpcEndpointServiceConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsResponse.ReadOnly
            ] = proxy(DeleteVpcEndpointServiceConfigurations, request)
            def startNetworkInsightsAccessScopeAnalysis(
                request: StartNetworkInsightsAccessScopeAnalysisRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse.ReadOnly
            ] = proxy(StartNetworkInsightsAccessScopeAnalysis, request)
            def describeTransitGatewayMulticastDomains(
                request: DescribeTransitGatewayMulticastDomainsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly
            ] = rts
              .unsafeRun(proxy(DescribeTransitGatewayMulticastDomains, request))
            def describeTransitGatewayMulticastDomainsPaginated(
                request: DescribeTransitGatewayMulticastDomainsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsResponse.ReadOnly
            ] = proxy(DescribeTransitGatewayMulticastDomainsPaginated, request)
            def importKeyPair(
                request: ImportKeyPairRequest
            ): IO[AwsError, zio.aws.ec2.model.ImportKeyPairResponse.ReadOnly] =
              proxy(ImportKeyPair, request)
            def revokeSecurityGroupEgress(
                request: RevokeSecurityGroupEgressRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RevokeSecurityGroupEgressResponse.ReadOnly
            ] = proxy(RevokeSecurityGroupEgress, request)
            def enableVgwRoutePropagation(
                request: EnableVgwRoutePropagationRequest
            ): IO[AwsError, Unit] = proxy(EnableVgwRoutePropagation, request)
            def createTransitGatewayRoute(
                request: CreateTransitGatewayRouteRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateTransitGatewayRouteResponse.ReadOnly
            ] = proxy(CreateTransitGatewayRoute, request)
            def acceptReservedInstancesExchangeQuote(
                request: AcceptReservedInstancesExchangeQuoteRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteResponse.ReadOnly
            ] = proxy(AcceptReservedInstancesExchangeQuote, request)
            def modifyInstanceAttribute(
                request: ModifyInstanceAttributeRequest
            ): IO[AwsError, Unit] = proxy(ModifyInstanceAttribute, request)
            def deleteTransitGatewayConnectPeer(
                request: DeleteTransitGatewayConnectPeerRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteTransitGatewayConnectPeerResponse.ReadOnly
            ] = proxy(DeleteTransitGatewayConnectPeer, request)
            def createIpam(
                request: CreateIpamRequest
            ): IO[AwsError, zio.aws.ec2.model.CreateIpamResponse.ReadOnly] =
              proxy(CreateIpam, request)
            def getConsoleScreenshot(request: GetConsoleScreenshotRequest): IO[
              AwsError,
              zio.aws.ec2.model.GetConsoleScreenshotResponse.ReadOnly
            ] = proxy(GetConsoleScreenshot, request)
            def deregisterTransitGatewayMulticastGroupMembers(
                request: DeregisterTransitGatewayMulticastGroupMembersRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse.ReadOnly
            ] = proxy(DeregisterTransitGatewayMulticastGroupMembers, request)
            def describeNetworkInterfacePermissions(
                request: DescribeNetworkInterfacePermissionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.NetworkInterfacePermission.ReadOnly
            ] =
              rts.unsafeRun(proxy(DescribeNetworkInterfacePermissions, request))
            def describeNetworkInterfacePermissionsPaginated(
                request: DescribeNetworkInterfacePermissionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeNetworkInterfacePermissionsResponse.ReadOnly
            ] = proxy(DescribeNetworkInterfacePermissionsPaginated, request)
            def createTransitGatewayPrefixListReference(
                request: CreateTransitGatewayPrefixListReferenceRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceResponse.ReadOnly
            ] = proxy(CreateTransitGatewayPrefixListReference, request)
            def cancelCapacityReservation(
                request: CancelCapacityReservationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CancelCapacityReservationResponse.ReadOnly
            ] = proxy(CancelCapacityReservation, request)
            def getIpamAddressHistory(
                request: GetIpamAddressHistoryRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.IpamAddressHistoryRecord.ReadOnly
            ] = rts.unsafeRun(proxy(GetIpamAddressHistory, request))
            def getIpamAddressHistoryPaginated(
                request: GetIpamAddressHistoryRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetIpamAddressHistoryResponse.ReadOnly
            ] = proxy(GetIpamAddressHistoryPaginated, request)
            def describePlacementGroups(
                request: DescribePlacementGroupsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribePlacementGroupsResponse.ReadOnly
            ] = proxy(DescribePlacementGroups, request)
            def detachVpnGateway(
                request: DetachVpnGatewayRequest
            ): IO[AwsError, Unit] = proxy(DetachVpnGateway, request)
            def describeInternetGateways(
                request: DescribeInternetGatewaysRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.InternetGateway.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeInternetGateways, request))
            def describeInternetGatewaysPaginated(
                request: DescribeInternetGatewaysRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeInternetGatewaysResponse.ReadOnly
            ] = proxy(DescribeInternetGatewaysPaginated, request)
            def disassociateEnclaveCertificateIamRole(
                request: DisassociateEnclaveCertificateIamRoleRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleResponse.ReadOnly
            ] = proxy(DisassociateEnclaveCertificateIamRole, request)
            def modifyTrafficMirrorFilterRule(
                request: ModifyTrafficMirrorFilterRuleRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleResponse.ReadOnly
            ] = proxy(ModifyTrafficMirrorFilterRule, request)
            def modifyVpcEndpointServicePermissions(
                request: ModifyVpcEndpointServicePermissionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsResponse.ReadOnly
            ] = proxy(ModifyVpcEndpointServicePermissions, request)
            def createKeyPair(
                request: CreateKeyPairRequest
            ): IO[AwsError, zio.aws.ec2.model.CreateKeyPairResponse.ReadOnly] =
              proxy(CreateKeyPair, request)
            def releaseAddress(
                request: ReleaseAddressRequest
            ): IO[AwsError, Unit] = proxy(ReleaseAddress, request)
            def describeVpcEndpointConnectionNotifications(
                request: DescribeVpcEndpointConnectionNotificationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ConnectionNotification.ReadOnly
            ] = rts.unsafeRun(
              proxy(DescribeVpcEndpointConnectionNotifications, request)
            )
            def describeVpcEndpointConnectionNotificationsPaginated(
                request: DescribeVpcEndpointConnectionNotificationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse.ReadOnly
            ] = proxy(
              DescribeVpcEndpointConnectionNotificationsPaginated,
              request
            )
            def associateAddress(request: AssociateAddressRequest): IO[
              AwsError,
              zio.aws.ec2.model.AssociateAddressResponse.ReadOnly
            ] = proxy(AssociateAddress, request)
            def describeTransitGateways(
                request: DescribeTransitGatewaysRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TransitGateway.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeTransitGateways, request))
            def describeTransitGatewaysPaginated(
                request: DescribeTransitGatewaysRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeTransitGatewaysResponse.ReadOnly
            ] = proxy(DescribeTransitGatewaysPaginated, request)
            def createCarrierGateway(request: CreateCarrierGatewayRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateCarrierGatewayResponse.ReadOnly
            ] = proxy(CreateCarrierGateway, request)
            def modifyVpcEndpointServiceConfiguration(
                request: ModifyVpcEndpointServiceConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationResponse.ReadOnly
            ] = proxy(ModifyVpcEndpointServiceConfiguration, request)
            def describeVolumeStatus(
                request: DescribeVolumeStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.VolumeStatusItem.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeVolumeStatus, request))
            def describeVolumeStatusPaginated(
                request: DescribeVolumeStatusRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVolumeStatusResponse.ReadOnly
            ] = proxy(DescribeVolumeStatusPaginated, request)
            def describeTransitGatewayVpcAttachments(
                request: DescribeTransitGatewayVpcAttachmentsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly
            ] = rts
              .unsafeRun(proxy(DescribeTransitGatewayVpcAttachments, request))
            def describeTransitGatewayVpcAttachmentsPaginated(
                request: DescribeTransitGatewayVpcAttachmentsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse.ReadOnly
            ] = proxy(DescribeTransitGatewayVpcAttachmentsPaginated, request)
            def createVpcPeeringConnection(
                request: CreateVpcPeeringConnectionRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateVpcPeeringConnectionResponse.ReadOnly
            ] = proxy(CreateVpcPeeringConnection, request)
            def createVpcEndpoint(request: CreateVpcEndpointRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateVpcEndpointResponse.ReadOnly
            ] = proxy(CreateVpcEndpoint, request)
            def listImagesInRecycleBin(
                request: ListImagesInRecycleBinRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ImageRecycleBinInfo.ReadOnly
            ] = rts.unsafeRun(proxy(ListImagesInRecycleBin, request))
            def listImagesInRecycleBinPaginated(
                request: ListImagesInRecycleBinRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ListImagesInRecycleBinResponse.ReadOnly
            ] = proxy(ListImagesInRecycleBinPaginated, request)
            def replaceIamInstanceProfileAssociation(
                request: ReplaceIamInstanceProfileAssociationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationResponse.ReadOnly
            ] = proxy(ReplaceIamInstanceProfileAssociation, request)
            def disableVgwRoutePropagation(
                request: DisableVgwRoutePropagationRequest
            ): IO[AwsError, Unit] = proxy(DisableVgwRoutePropagation, request)
            def describeNetworkInsightsAccessScopes(
                request: DescribeNetworkInsightsAccessScopesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly
            ] =
              rts.unsafeRun(proxy(DescribeNetworkInsightsAccessScopes, request))
            def describeNetworkInsightsAccessScopesPaginated(
                request: DescribeNetworkInsightsAccessScopesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesResponse.ReadOnly
            ] = proxy(DescribeNetworkInsightsAccessScopesPaginated, request)
            def getNetworkInsightsAccessScopeAnalysisFindings(
                request: GetNetworkInsightsAccessScopeAnalysisFindingsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.ReadOnly,
              zio.aws.ec2.model.AccessScopeAnalysisFinding.ReadOnly
            ]] = proxy(GetNetworkInsightsAccessScopeAnalysisFindings, request)
            def getNetworkInsightsAccessScopeAnalysisFindingsPaginated(
                request: GetNetworkInsightsAccessScopeAnalysisFindingsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.ReadOnly
            ] = proxy(
              GetNetworkInsightsAccessScopeAnalysisFindingsPaginated,
              request
            )
            def cancelCapacityReservationFleets(
                request: CancelCapacityReservationFleetsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CancelCapacityReservationFleetsResponse.ReadOnly
            ] = proxy(CancelCapacityReservationFleets, request)
            def deleteLocalGatewayRouteTableVpcAssociation(
                request: DeleteLocalGatewayRouteTableVpcAssociationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationResponse.ReadOnly
            ] = proxy(DeleteLocalGatewayRouteTableVpcAssociation, request)
            def associateIamInstanceProfile(
                request: AssociateIamInstanceProfileRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AssociateIamInstanceProfileResponse.ReadOnly
            ] = proxy(AssociateIamInstanceProfile, request)
            def describeTrunkInterfaceAssociations(
                request: DescribeTrunkInterfaceAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TrunkInterfaceAssociation.ReadOnly
            ] =
              rts.unsafeRun(proxy(DescribeTrunkInterfaceAssociations, request))
            def describeTrunkInterfaceAssociationsPaginated(
                request: DescribeTrunkInterfaceAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsResponse.ReadOnly
            ] = proxy(DescribeTrunkInterfaceAssociationsPaginated, request)
            def startNetworkInsightsAnalysis(
                request: StartNetworkInsightsAnalysisRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.StartNetworkInsightsAnalysisResponse.ReadOnly
            ] = proxy(StartNetworkInsightsAnalysis, request)
            def purchaseReservedInstancesOffering(
                request: PurchaseReservedInstancesOfferingRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.PurchaseReservedInstancesOfferingResponse.ReadOnly
            ] = proxy(PurchaseReservedInstancesOffering, request)
            def exportImage(
                request: ExportImageRequest
            ): IO[AwsError, zio.aws.ec2.model.ExportImageResponse.ReadOnly] =
              proxy(ExportImage, request)
            def describeClientVpnConnections(
                request: DescribeClientVpnConnectionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ClientVpnConnection.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeClientVpnConnections, request))
            def describeClientVpnConnectionsPaginated(
                request: DescribeClientVpnConnectionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeClientVpnConnectionsResponse.ReadOnly
            ] = proxy(DescribeClientVpnConnectionsPaginated, request)
            def describeInstanceStatus(
                request: DescribeInstanceStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.InstanceStatus.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeInstanceStatus, request))
            def describeInstanceStatusPaginated(
                request: DescribeInstanceStatusRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeInstanceStatusResponse.ReadOnly
            ] = proxy(DescribeInstanceStatusPaginated, request)
            def describeAddressesAttribute(
                request: DescribeAddressesAttributeRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.AddressAttribute.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeAddressesAttribute, request))
            def describeAddressesAttributePaginated(
                request: DescribeAddressesAttributeRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeAddressesAttributeResponse.ReadOnly
            ] = proxy(DescribeAddressesAttributePaginated, request)
            def associateRouteTable(request: AssociateRouteTableRequest): IO[
              AwsError,
              zio.aws.ec2.model.AssociateRouteTableResponse.ReadOnly
            ] = proxy(AssociateRouteTable, request)
            def provisionIpamPoolCidr(
                request: ProvisionIpamPoolCidrRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ProvisionIpamPoolCidrResponse.ReadOnly
            ] = proxy(ProvisionIpamPoolCidr, request)
            def withdrawByoipCidr(request: WithdrawByoipCidrRequest): IO[
              AwsError,
              zio.aws.ec2.model.WithdrawByoipCidrResponse.ReadOnly
            ] = proxy(WithdrawByoipCidr, request)
            def describeIpamPools(
                request: DescribeIpamPoolsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.IpamPool.ReadOnly] =
              rts.unsafeRun(proxy(DescribeIpamPools, request))
            def describeIpamPoolsPaginated(
                request: DescribeIpamPoolsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeIpamPoolsResponse.ReadOnly
            ] = proxy(DescribeIpamPoolsPaginated, request)
            def getAssociatedIpv6PoolCidrs(
                request: GetAssociatedIpv6PoolCidrsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.Ipv6CidrAssociation.ReadOnly
            ] = rts.unsafeRun(proxy(GetAssociatedIpv6PoolCidrs, request))
            def getAssociatedIpv6PoolCidrsPaginated(
                request: GetAssociatedIpv6PoolCidrsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsResponse.ReadOnly
            ] = proxy(GetAssociatedIpv6PoolCidrsPaginated, request)
            def describeSnapshots(
                request: DescribeSnapshotsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.Snapshot.ReadOnly] =
              rts.unsafeRun(proxy(DescribeSnapshots, request))
            def describeSnapshotsPaginated(
                request: DescribeSnapshotsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeSnapshotsResponse.ReadOnly
            ] = proxy(DescribeSnapshotsPaginated, request)
            def enableVpcClassicLinkDnsSupport(
                request: EnableVpcClassicLinkDnsSupportRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.EnableVpcClassicLinkDnsSupportResponse.ReadOnly
            ] = proxy(EnableVpcClassicLinkDnsSupport, request)
            def createTrafficMirrorSession(
                request: CreateTrafficMirrorSessionRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateTrafficMirrorSessionResponse.ReadOnly
            ] = proxy(CreateTrafficMirrorSession, request)
            def getIpamPoolAllocations(
                request: GetIpamPoolAllocationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.IpamPoolAllocation.ReadOnly
            ] = rts.unsafeRun(proxy(GetIpamPoolAllocations, request))
            def getIpamPoolAllocationsPaginated(
                request: GetIpamPoolAllocationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetIpamPoolAllocationsResponse.ReadOnly
            ] = proxy(GetIpamPoolAllocationsPaginated, request)
            def describeCustomerGateways(
                request: DescribeCustomerGatewaysRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeCustomerGatewaysResponse.ReadOnly
            ] = proxy(DescribeCustomerGateways, request)
            def describeClientVpnAuthorizationRules(
                request: DescribeClientVpnAuthorizationRulesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.AuthorizationRule.ReadOnly
            ] =
              rts.unsafeRun(proxy(DescribeClientVpnAuthorizationRules, request))
            def describeClientVpnAuthorizationRulesPaginated(
                request: DescribeClientVpnAuthorizationRulesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesResponse.ReadOnly
            ] = proxy(DescribeClientVpnAuthorizationRulesPaginated, request)
            def rejectTransitGatewayMulticastDomainAssociations(
                request: RejectTransitGatewayMulticastDomainAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
            ] = proxy(RejectTransitGatewayMulticastDomainAssociations, request)
            def deleteSubnet(request: DeleteSubnetRequest): IO[AwsError, Unit] =
              proxy(DeleteSubnet, request)
            def deleteEgressOnlyInternetGateway(
                request: DeleteEgressOnlyInternetGatewayRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayResponse.ReadOnly
            ] = proxy(DeleteEgressOnlyInternetGateway, request)
            def deleteTrafficMirrorTarget(
                request: DeleteTrafficMirrorTargetRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteTrafficMirrorTargetResponse.ReadOnly
            ] = proxy(DeleteTrafficMirrorTarget, request)
            def describeInstanceAttribute(
                request: DescribeInstanceAttributeRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeInstanceAttributeResponse.ReadOnly
            ] = proxy(DescribeInstanceAttribute, request)
            def disableImageDeprecation(
                request: DisableImageDeprecationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisableImageDeprecationResponse.ReadOnly
            ] = proxy(DisableImageDeprecation, request)
            def deleteKeyPair(
                request: DeleteKeyPairRequest
            ): IO[AwsError, Unit] = proxy(DeleteKeyPair, request)
            def enableFastLaunch(request: EnableFastLaunchRequest): IO[
              AwsError,
              zio.aws.ec2.model.EnableFastLaunchResponse.ReadOnly
            ] = proxy(EnableFastLaunch, request)
            def deleteCarrierGateway(request: DeleteCarrierGatewayRequest): IO[
              AwsError,
              zio.aws.ec2.model.DeleteCarrierGatewayResponse.ReadOnly
            ] = proxy(DeleteCarrierGateway, request)
            def deleteTransitGatewayConnect(
                request: DeleteTransitGatewayConnectRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteTransitGatewayConnectResponse.ReadOnly
            ] = proxy(DeleteTransitGatewayConnect, request)
            def createCustomerGateway(
                request: CreateCustomerGatewayRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateCustomerGatewayResponse.ReadOnly
            ] = proxy(CreateCustomerGateway, request)
            def deleteInternetGateway(
                request: DeleteInternetGatewayRequest
            ): IO[AwsError, Unit] = proxy(DeleteInternetGateway, request)
            def createVpnConnectionRoute(
                request: CreateVpnConnectionRouteRequest
            ): IO[AwsError, Unit] = proxy(CreateVpnConnectionRoute, request)
            def getCapacityReservationUsage(
                request: GetCapacityReservationUsageRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.ec2.model.GetCapacityReservationUsageResponse.ReadOnly,
              zio.aws.ec2.model.InstanceUsage.ReadOnly
            ]] = proxy(GetCapacityReservationUsage, request)
            def getCapacityReservationUsagePaginated(
                request: GetCapacityReservationUsageRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetCapacityReservationUsageResponse.ReadOnly
            ] = proxy(GetCapacityReservationUsagePaginated, request)
            def createPlacementGroup(request: CreatePlacementGroupRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreatePlacementGroupResponse.ReadOnly
            ] = proxy(CreatePlacementGroup, request)
            def modifyNetworkInterfaceAttribute(
                request: ModifyNetworkInterfaceAttributeRequest
            ): IO[AwsError, Unit] =
              proxy(ModifyNetworkInterfaceAttribute, request)
            def importSnapshot(
                request: ImportSnapshotRequest
            ): IO[AwsError, zio.aws.ec2.model.ImportSnapshotResponse.ReadOnly] =
              proxy(ImportSnapshot, request)
            def modifyFpgaImageAttribute(
                request: ModifyFpgaImageAttributeRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyFpgaImageAttributeResponse.ReadOnly
            ] = proxy(ModifyFpgaImageAttribute, request)
            def describeNetworkInsightsPaths(
                request: DescribeNetworkInsightsPathsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.NetworkInsightsPath.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeNetworkInsightsPaths, request))
            def describeNetworkInsightsPathsPaginated(
                request: DescribeNetworkInsightsPathsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeNetworkInsightsPathsResponse.ReadOnly
            ] = proxy(DescribeNetworkInsightsPathsPaginated, request)
            def createVpc(
                request: CreateVpcRequest
            ): IO[AwsError, zio.aws.ec2.model.CreateVpcResponse.ReadOnly] =
              proxy(CreateVpc, request)
            def cancelReservedInstancesListing(
                request: CancelReservedInstancesListingRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CancelReservedInstancesListingResponse.ReadOnly
            ] = proxy(CancelReservedInstancesListing, request)
            def getIpamPoolCidrs(
                request: GetIpamPoolCidrsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.IpamPoolCidr.ReadOnly] =
              rts.unsafeRun(proxy(GetIpamPoolCidrs, request))
            def getIpamPoolCidrsPaginated(request: GetIpamPoolCidrsRequest): IO[
              AwsError,
              zio.aws.ec2.model.GetIpamPoolCidrsResponse.ReadOnly
            ] = proxy(GetIpamPoolCidrsPaginated, request)
            def deleteVolume(request: DeleteVolumeRequest): IO[AwsError, Unit] =
              proxy(DeleteVolume, request)
            def revokeSecurityGroupIngress(
                request: RevokeSecurityGroupIngressRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RevokeSecurityGroupIngressResponse.ReadOnly
            ] = proxy(RevokeSecurityGroupIngress, request)
            def describeNetworkAcls(
                request: DescribeNetworkAclsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.NetworkAcl.ReadOnly] =
              rts.unsafeRun(proxy(DescribeNetworkAcls, request))
            def describeNetworkAclsPaginated(
                request: DescribeNetworkAclsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeNetworkAclsResponse.ReadOnly
            ] = proxy(DescribeNetworkAclsPaginated, request)
            def copyImage(
                request: CopyImageRequest
            ): IO[AwsError, zio.aws.ec2.model.CopyImageResponse.ReadOnly] =
              proxy(CopyImage, request)
            def advertiseByoipCidr(request: AdvertiseByoipCidrRequest): IO[
              AwsError,
              zio.aws.ec2.model.AdvertiseByoipCidrResponse.ReadOnly
            ] = proxy(AdvertiseByoipCidr, request)
            def createLocalGatewayRoute(
                request: CreateLocalGatewayRouteRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateLocalGatewayRouteResponse.ReadOnly
            ] = proxy(CreateLocalGatewayRoute, request)
            def disassociateTrunkInterface(
                request: DisassociateTrunkInterfaceRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisassociateTrunkInterfaceResponse.ReadOnly
            ] = proxy(DisassociateTrunkInterface, request)
            def describeClientVpnEndpoints(
                request: DescribeClientVpnEndpointsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ClientVpnEndpoint.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeClientVpnEndpoints, request))
            def describeClientVpnEndpointsPaginated(
                request: DescribeClientVpnEndpointsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeClientVpnEndpointsResponse.ReadOnly
            ] = proxy(DescribeClientVpnEndpointsPaginated, request)
            def disableFastSnapshotRestores(
                request: DisableFastSnapshotRestoresRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisableFastSnapshotRestoresResponse.ReadOnly
            ] = proxy(DisableFastSnapshotRestores, request)
            def createSubnetCidrReservation(
                request: CreateSubnetCidrReservationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateSubnetCidrReservationResponse.ReadOnly
            ] = proxy(CreateSubnetCidrReservation, request)
            def disassociateRouteTable(
                request: DisassociateRouteTableRequest
            ): IO[AwsError, Unit] = proxy(DisassociateRouteTable, request)
            def describeSpotInstanceRequests(
                request: DescribeSpotInstanceRequestsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.SpotInstanceRequest.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeSpotInstanceRequests, request))
            def describeSpotInstanceRequestsPaginated(
                request: DescribeSpotInstanceRequestsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeSpotInstanceRequestsResponse.ReadOnly
            ] = proxy(DescribeSpotInstanceRequestsPaginated, request)
            def deleteTrafficMirrorFilterRule(
                request: DeleteTrafficMirrorFilterRuleRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleResponse.ReadOnly
            ] = proxy(DeleteTrafficMirrorFilterRule, request)
            def describeHostReservations(
                request: DescribeHostReservationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.HostReservation.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeHostReservations, request))
            def describeHostReservationsPaginated(
                request: DescribeHostReservationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeHostReservationsResponse.ReadOnly
            ] = proxy(DescribeHostReservationsPaginated, request)
            def modifyVpnTunnelCertificate(
                request: ModifyVpnTunnelCertificateRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyVpnTunnelCertificateResponse.ReadOnly
            ] = proxy(ModifyVpnTunnelCertificate, request)
            def detachInternetGateway(
                request: DetachInternetGatewayRequest
            ): IO[AwsError, Unit] = proxy(DetachInternetGateway, request)
            def describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(
                request: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly
            ] = rts.unsafeRun(
              proxy(
                DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations,
                request
              )
            )
            def describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginated(
                request: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.ReadOnly
            ] = proxy(
              DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginated,
              request
            )
            def deregisterImage(
                request: DeregisterImageRequest
            ): IO[AwsError, Unit] = proxy(DeregisterImage, request)
            def modifySnapshotAttribute(
                request: ModifySnapshotAttributeRequest
            ): IO[AwsError, Unit] = proxy(ModifySnapshotAttribute, request)
            def describeVolumeAttribute(
                request: DescribeVolumeAttributeRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVolumeAttributeResponse.ReadOnly
            ] = proxy(DescribeVolumeAttribute, request)
            def describeVpcEndpoints(
                request: DescribeVpcEndpointsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.VpcEndpoint.ReadOnly] =
              rts.unsafeRun(proxy(DescribeVpcEndpoints, request))
            def describeVpcEndpointsPaginated(
                request: DescribeVpcEndpointsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVpcEndpointsResponse.ReadOnly
            ] = proxy(DescribeVpcEndpointsPaginated, request)
            def getLaunchTemplateData(
                request: GetLaunchTemplateDataRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetLaunchTemplateDataResponse.ReadOnly
            ] = proxy(GetLaunchTemplateData, request)
            def deleteNetworkAcl(
                request: DeleteNetworkAclRequest
            ): IO[AwsError, Unit] = proxy(DeleteNetworkAcl, request)
            def describeSecurityGroups(
                request: DescribeSecurityGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.SecurityGroup.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeSecurityGroups, request))
            def describeSecurityGroupsPaginated(
                request: DescribeSecurityGroupsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeSecurityGroupsResponse.ReadOnly
            ] = proxy(DescribeSecurityGroupsPaginated, request)
            def deleteFleets(
                request: DeleteFleetsRequest
            ): IO[AwsError, zio.aws.ec2.model.DeleteFleetsResponse.ReadOnly] =
              proxy(DeleteFleets, request)
            def replaceTransitGatewayRoute(
                request: ReplaceTransitGatewayRouteRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ReplaceTransitGatewayRouteResponse.ReadOnly
            ] = proxy(ReplaceTransitGatewayRoute, request)
            def getVpnConnectionDeviceSampleConfiguration(
                request: GetVpnConnectionDeviceSampleConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse.ReadOnly
            ] = proxy(GetVpnConnectionDeviceSampleConfiguration, request)
            def detachClassicLinkVpc(request: DetachClassicLinkVpcRequest): IO[
              AwsError,
              zio.aws.ec2.model.DetachClassicLinkVpcResponse.ReadOnly
            ] = proxy(DetachClassicLinkVpc, request)
            def allocateAddress(request: AllocateAddressRequest): IO[
              AwsError,
              zio.aws.ec2.model.AllocateAddressResponse.ReadOnly
            ] = proxy(AllocateAddress, request)
            def deleteVpnConnection(
                request: DeleteVpnConnectionRequest
            ): IO[AwsError, Unit] = proxy(DeleteVpnConnection, request)
            def describeReservedInstancesOfferings(
                request: DescribeReservedInstancesOfferingsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ReservedInstancesOffering.ReadOnly
            ] =
              rts.unsafeRun(proxy(DescribeReservedInstancesOfferings, request))
            def describeReservedInstancesOfferingsPaginated(
                request: DescribeReservedInstancesOfferingsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeReservedInstancesOfferingsResponse.ReadOnly
            ] = proxy(DescribeReservedInstancesOfferingsPaginated, request)
            def describeConversionTasks(
                request: DescribeConversionTasksRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeConversionTasksResponse.ReadOnly
            ] = proxy(DescribeConversionTasks, request)
            def describeLocalGatewayRouteTableVpcAssociations(
                request: DescribeLocalGatewayRouteTableVpcAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.ReadOnly
            ] = rts.unsafeRun(
              proxy(DescribeLocalGatewayRouteTableVpcAssociations, request)
            )
            def describeLocalGatewayRouteTableVpcAssociationsPaginated(
                request: DescribeLocalGatewayRouteTableVpcAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse.ReadOnly
            ] = proxy(
              DescribeLocalGatewayRouteTableVpcAssociationsPaginated,
              request
            )
            def associateInstanceEventWindow(
                request: AssociateInstanceEventWindowRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AssociateInstanceEventWindowResponse.ReadOnly
            ] = proxy(AssociateInstanceEventWindow, request)
            def describeInstanceEventNotificationAttributes(
                request: DescribeInstanceEventNotificationAttributesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesResponse.ReadOnly
            ] = proxy(DescribeInstanceEventNotificationAttributes, request)
            def deleteNetworkInsightsPath(
                request: DeleteNetworkInsightsPathRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteNetworkInsightsPathResponse.ReadOnly
            ] = proxy(DeleteNetworkInsightsPath, request)
            def describeElasticGpus(
                request: DescribeElasticGpusRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly,
              zio.aws.ec2.model.ElasticGpus.ReadOnly
            ]] = proxy(DescribeElasticGpus, request)
            def describeElasticGpusPaginated(
                request: DescribeElasticGpusRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly
            ] = proxy(DescribeElasticGpusPaginated, request)
            def exportTransitGatewayRoutes(
                request: ExportTransitGatewayRoutesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ExportTransitGatewayRoutesResponse.ReadOnly
            ] = proxy(ExportTransitGatewayRoutes, request)
            def describeTrafficMirrorSessions(
                request: DescribeTrafficMirrorSessionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TrafficMirrorSession.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeTrafficMirrorSessions, request))
            def describeTrafficMirrorSessionsPaginated(
                request: DescribeTrafficMirrorSessionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeTrafficMirrorSessionsResponse.ReadOnly
            ] = proxy(DescribeTrafficMirrorSessionsPaginated, request)
            def describeSpotPriceHistory(
                request: DescribeSpotPriceHistoryRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.SpotPrice.ReadOnly] =
              rts.unsafeRun(proxy(DescribeSpotPriceHistory, request))
            def describeSpotPriceHistoryPaginated(
                request: DescribeSpotPriceHistoryRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeSpotPriceHistoryResponse.ReadOnly
            ] = proxy(DescribeSpotPriceHistoryPaginated, request)
            def enableImageDeprecation(
                request: EnableImageDeprecationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.EnableImageDeprecationResponse.ReadOnly
            ] = proxy(EnableImageDeprecation, request)
            def modifyInstanceMaintenanceOptions(
                request: ModifyInstanceMaintenanceOptionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyInstanceMaintenanceOptionsResponse.ReadOnly
            ] = proxy(ModifyInstanceMaintenanceOptions, request)
            def describeRegions(request: DescribeRegionsRequest): IO[
              AwsError,
              zio.aws.ec2.model.DescribeRegionsResponse.ReadOnly
            ] = proxy(DescribeRegions, request)
            def runScheduledInstances(
                request: RunScheduledInstancesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RunScheduledInstancesResponse.ReadOnly
            ] = proxy(RunScheduledInstances, request)
            def modifyInstanceEventWindow(
                request: ModifyInstanceEventWindowRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyInstanceEventWindowResponse.ReadOnly
            ] = proxy(ModifyInstanceEventWindow, request)
            def deleteTrafficMirrorSession(
                request: DeleteTrafficMirrorSessionRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse.ReadOnly
            ] = proxy(DeleteTrafficMirrorSession, request)
            def modifyVpcPeeringConnectionOptions(
                request: ModifyVpcPeeringConnectionOptionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsResponse.ReadOnly
            ] = proxy(ModifyVpcPeeringConnectionOptions, request)
            def describeFlowLogs(
                request: DescribeFlowLogsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.FlowLog.ReadOnly] =
              rts.unsafeRun(proxy(DescribeFlowLogs, request))
            def describeFlowLogsPaginated(request: DescribeFlowLogsRequest): IO[
              AwsError,
              zio.aws.ec2.model.DescribeFlowLogsResponse.ReadOnly
            ] = proxy(DescribeFlowLogsPaginated, request)
            def describeIpams(
                request: DescribeIpamsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.Ipam.ReadOnly] =
              rts.unsafeRun(proxy(DescribeIpams, request))
            def describeIpamsPaginated(
                request: DescribeIpamsRequest
            ): IO[AwsError, zio.aws.ec2.model.DescribeIpamsResponse.ReadOnly] =
              proxy(DescribeIpamsPaginated, request)
            def modifyIpamPool(
                request: ModifyIpamPoolRequest
            ): IO[AwsError, zio.aws.ec2.model.ModifyIpamPoolResponse.ReadOnly] =
              proxy(ModifyIpamPool, request)
            def unassignIpv6Addresses(
                request: UnassignIpv6AddressesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.UnassignIpv6AddressesResponse.ReadOnly
            ] = proxy(UnassignIpv6Addresses, request)
            def describeImportImageTasks(
                request: DescribeImportImageTasksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ImportImageTask.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeImportImageTasks, request))
            def describeImportImageTasksPaginated(
                request: DescribeImportImageTasksRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeImportImageTasksResponse.ReadOnly
            ] = proxy(DescribeImportImageTasksPaginated, request)
            def deletePlacementGroup(
                request: DeletePlacementGroupRequest
            ): IO[AwsError, Unit] = proxy(DeletePlacementGroup, request)
            def cancelSpotInstanceRequests(
                request: CancelSpotInstanceRequestsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CancelSpotInstanceRequestsResponse.ReadOnly
            ] = proxy(CancelSpotInstanceRequests, request)
            def describeSnapshotAttribute(
                request: DescribeSnapshotAttributeRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeSnapshotAttributeResponse.ReadOnly
            ] = proxy(DescribeSnapshotAttribute, request)
            def describeManagedPrefixLists(
                request: DescribeManagedPrefixListsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ManagedPrefixList.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeManagedPrefixLists, request))
            def describeManagedPrefixListsPaginated(
                request: DescribeManagedPrefixListsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeManagedPrefixListsResponse.ReadOnly
            ] = proxy(DescribeManagedPrefixListsPaginated, request)
            def createNetworkAclEntry(
                request: CreateNetworkAclEntryRequest
            ): IO[AwsError, Unit] = proxy(CreateNetworkAclEntry, request)
            def associateTransitGatewayRouteTable(
                request: AssociateTransitGatewayRouteTableRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AssociateTransitGatewayRouteTableResponse.ReadOnly
            ] = proxy(AssociateTransitGatewayRouteTable, request)
            def describeScheduledInstances(
                request: DescribeScheduledInstancesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.ScheduledInstance.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeScheduledInstances, request))
            def describeScheduledInstancesPaginated(
                request: DescribeScheduledInstancesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeScheduledInstancesResponse.ReadOnly
            ] = proxy(DescribeScheduledInstancesPaginated, request)
            def authorizeClientVpnIngress(
                request: AuthorizeClientVpnIngressRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AuthorizeClientVpnIngressResponse.ReadOnly
            ] = proxy(AuthorizeClientVpnIngress, request)
            def getTransitGatewayPrefixListReferences(
                request: GetTransitGatewayPrefixListReferencesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly
            ] = rts
              .unsafeRun(proxy(GetTransitGatewayPrefixListReferences, request))
            def getTransitGatewayPrefixListReferencesPaginated(
                request: GetTransitGatewayPrefixListReferencesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse.ReadOnly
            ] = proxy(GetTransitGatewayPrefixListReferencesPaginated, request)
            def detachNetworkInterface(
                request: DetachNetworkInterfaceRequest
            ): IO[AwsError, Unit] = proxy(DetachNetworkInterface, request)
            def importImage(
                request: ImportImageRequest
            ): IO[AwsError, zio.aws.ec2.model.ImportImageResponse.ReadOnly] =
              proxy(ImportImage, request)
            def describeEgressOnlyInternetGateways(
                request: DescribeEgressOnlyInternetGatewaysRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly
            ] =
              rts.unsafeRun(proxy(DescribeEgressOnlyInternetGateways, request))
            def describeEgressOnlyInternetGatewaysPaginated(
                request: DescribeEgressOnlyInternetGatewaysRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysResponse.ReadOnly
            ] = proxy(DescribeEgressOnlyInternetGatewaysPaginated, request)
            def confirmProductInstance(
                request: ConfirmProductInstanceRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ConfirmProductInstanceResponse.ReadOnly
            ] = proxy(ConfirmProductInstance, request)
            def describePrincipalIdFormat(
                request: DescribePrincipalIdFormatRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.PrincipalIdFormat.ReadOnly
            ] = rts.unsafeRun(proxy(DescribePrincipalIdFormat, request))
            def describePrincipalIdFormatPaginated(
                request: DescribePrincipalIdFormatRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribePrincipalIdFormatResponse.ReadOnly
            ] = proxy(DescribePrincipalIdFormatPaginated, request)
            def associateSubnetCidrBlock(
                request: AssociateSubnetCidrBlockRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AssociateSubnetCidrBlockResponse.ReadOnly
            ] = proxy(AssociateSubnetCidrBlock, request)
            def describeClientVpnTargetNetworks(
                request: DescribeClientVpnTargetNetworksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TargetNetwork.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeClientVpnTargetNetworks, request))
            def describeClientVpnTargetNetworksPaginated(
                request: DescribeClientVpnTargetNetworksRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeClientVpnTargetNetworksResponse.ReadOnly
            ] = proxy(DescribeClientVpnTargetNetworksPaginated, request)
            def resetEbsDefaultKmsKeyId(
                request: ResetEbsDefaultKmsKeyIdRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ResetEbsDefaultKmsKeyIdResponse.ReadOnly
            ] = proxy(ResetEbsDefaultKmsKeyId, request)
            def disableIpamOrganizationAdminAccount(
                request: DisableIpamOrganizationAdminAccountRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DisableIpamOrganizationAdminAccountResponse.ReadOnly
            ] = proxy(DisableIpamOrganizationAdminAccount, request)
            def describeIdFormat(request: DescribeIdFormatRequest): IO[
              AwsError,
              zio.aws.ec2.model.DescribeIdFormatResponse.ReadOnly
            ] = proxy(DescribeIdFormat, request)
            def describeIpamScopes(
                request: DescribeIpamScopesRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.IpamScope.ReadOnly] =
              rts.unsafeRun(proxy(DescribeIpamScopes, request))
            def describeIpamScopesPaginated(
                request: DescribeIpamScopesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeIpamScopesResponse.ReadOnly
            ] = proxy(DescribeIpamScopesPaginated, request)
            def describeVpcEndpointServicePermissions(
                request: DescribeVpcEndpointServicePermissionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.AllowedPrincipal.ReadOnly
            ] = rts
              .unsafeRun(proxy(DescribeVpcEndpointServicePermissions, request))
            def describeVpcEndpointServicePermissionsPaginated(
                request: DescribeVpcEndpointServicePermissionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse.ReadOnly
            ] = proxy(DescribeVpcEndpointServicePermissionsPaginated, request)
            def describeFpgaImageAttribute(
                request: DescribeFpgaImageAttributeRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeFpgaImageAttributeResponse.ReadOnly
            ] = proxy(DescribeFpgaImageAttribute, request)
            def registerInstanceEventNotificationAttributes(
                request: RegisterInstanceEventNotificationAttributesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesResponse.ReadOnly
            ] = proxy(RegisterInstanceEventNotificationAttributes, request)
            def restoreImageFromRecycleBin(
                request: RestoreImageFromRecycleBinRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.RestoreImageFromRecycleBinResponse.ReadOnly
            ] = proxy(RestoreImageFromRecycleBin, request)
            def deleteNetworkInsightsAccessScopeAnalysis(
                request: DeleteNetworkInsightsAccessScopeAnalysisRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse.ReadOnly
            ] = proxy(DeleteNetworkInsightsAccessScopeAnalysis, request)
            def modifyVpcAttribute(
                request: ModifyVpcAttributeRequest
            ): IO[AwsError, Unit] = proxy(ModifyVpcAttribute, request)
            def describeTrafficMirrorFilters(
                request: DescribeTrafficMirrorFiltersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeTrafficMirrorFilters, request))
            def describeTrafficMirrorFiltersPaginated(
                request: DescribeTrafficMirrorFiltersRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeTrafficMirrorFiltersResponse.ReadOnly
            ] = proxy(DescribeTrafficMirrorFiltersPaginated, request)
            def describeImageAttribute(
                request: DescribeImageAttributeRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeImageAttributeResponse.ReadOnly
            ] = proxy(DescribeImageAttribute, request)
            def resetImageAttribute(
                request: ResetImageAttributeRequest
            ): IO[AwsError, Unit] = proxy(ResetImageAttribute, request)
            def describeCapacityReservationFleets(
                request: DescribeCapacityReservationFleetsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.CapacityReservationFleet.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeCapacityReservationFleets, request))
            def describeCapacityReservationFleetsPaginated(
                request: DescribeCapacityReservationFleetsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeCapacityReservationFleetsResponse.ReadOnly
            ] = proxy(DescribeCapacityReservationFleetsPaginated, request)
            def deleteNatGateway(request: DeleteNatGatewayRequest): IO[
              AwsError,
              zio.aws.ec2.model.DeleteNatGatewayResponse.ReadOnly
            ] = proxy(DeleteNatGateway, request)
            def deleteTags(request: DeleteTagsRequest): IO[AwsError, Unit] =
              proxy(DeleteTags, request)
            def describeReservedInstancesListings(
                request: DescribeReservedInstancesListingsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeReservedInstancesListingsResponse.ReadOnly
            ] = proxy(DescribeReservedInstancesListings, request)
            def deleteIpamPool(
                request: DeleteIpamPoolRequest
            ): IO[AwsError, zio.aws.ec2.model.DeleteIpamPoolResponse.ReadOnly] =
              proxy(DeleteIpamPool, request)
            def associateClientVpnTargetNetwork(
                request: AssociateClientVpnTargetNetworkRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AssociateClientVpnTargetNetworkResponse.ReadOnly
            ] = proxy(AssociateClientVpnTargetNetwork, request)
            def copyFpgaImage(
                request: CopyFpgaImageRequest
            ): IO[AwsError, zio.aws.ec2.model.CopyFpgaImageResponse.ReadOnly] =
              proxy(CopyFpgaImage, request)
            def getFlowLogsIntegrationTemplate(
                request: GetFlowLogsIntegrationTemplateRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetFlowLogsIntegrationTemplateResponse.ReadOnly
            ] = proxy(GetFlowLogsIntegrationTemplate, request)
            def getInstanceTypesFromInstanceRequirements(
                request: GetInstanceTypesFromInstanceRequirementsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements.ReadOnly
            ] = rts.unsafeRun(
              proxy(GetInstanceTypesFromInstanceRequirements, request)
            )
            def getInstanceTypesFromInstanceRequirementsPaginated(
                request: GetInstanceTypesFromInstanceRequirementsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse.ReadOnly
            ] =
              proxy(GetInstanceTypesFromInstanceRequirementsPaginated, request)
            def unassignPrivateIpAddresses(
                request: UnassignPrivateIpAddressesRequest
            ): IO[AwsError, Unit] = proxy(UnassignPrivateIpAddresses, request)
            def resetSnapshotAttribute(
                request: ResetSnapshotAttributeRequest
            ): IO[AwsError, Unit] = proxy(ResetSnapshotAttribute, request)
            def describeAccountAttributes(
                request: DescribeAccountAttributesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeAccountAttributesResponse.ReadOnly
            ] = proxy(DescribeAccountAttributes, request)
            def acceptTransitGatewayVpcAttachment(
                request: AcceptTransitGatewayVpcAttachmentRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentResponse.ReadOnly
            ] = proxy(AcceptTransitGatewayVpcAttachment, request)
            def createInstanceExportTask(
                request: CreateInstanceExportTaskRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateInstanceExportTaskResponse.ReadOnly
            ] = proxy(CreateInstanceExportTask, request)
            def associateEnclaveCertificateIamRole(
                request: AssociateEnclaveCertificateIamRoleRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleResponse.ReadOnly
            ] = proxy(AssociateEnclaveCertificateIamRole, request)
            def createDefaultVpc(request: CreateDefaultVpcRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateDefaultVpcResponse.ReadOnly
            ] = proxy(CreateDefaultVpc, request)
            def getTransitGatewayRouteTablePropagations(
                request: GetTransitGatewayRouteTablePropagationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TransitGatewayRouteTablePropagation.ReadOnly
            ] = rts.unsafeRun(
              proxy(GetTransitGatewayRouteTablePropagations, request)
            )
            def getTransitGatewayRouteTablePropagationsPaginated(
                request: GetTransitGatewayRouteTablePropagationsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsResponse.ReadOnly
            ] = proxy(GetTransitGatewayRouteTablePropagationsPaginated, request)
            def enableIpamOrganizationAdminAccount(
                request: EnableIpamOrganizationAdminAccountRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.EnableIpamOrganizationAdminAccountResponse.ReadOnly
            ] = proxy(EnableIpamOrganizationAdminAccount, request)
            def createTransitGateway(request: CreateTransitGatewayRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateTransitGatewayResponse.ReadOnly
            ] = proxy(CreateTransitGateway, request)
            def createTransitGatewayConnectPeer(
                request: CreateTransitGatewayConnectPeerRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateTransitGatewayConnectPeerResponse.ReadOnly
            ] = proxy(CreateTransitGatewayConnectPeer, request)
            def modifyDefaultCreditSpecification(
                request: ModifyDefaultCreditSpecificationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyDefaultCreditSpecificationResponse.ReadOnly
            ] = proxy(ModifyDefaultCreditSpecification, request)
            def modifyManagedPrefixList(
                request: ModifyManagedPrefixListRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyManagedPrefixListResponse.ReadOnly
            ] = proxy(ModifyManagedPrefixList, request)
            def modifyVpcTenancy(request: ModifyVpcTenancyRequest): IO[
              AwsError,
              zio.aws.ec2.model.ModifyVpcTenancyResponse.ReadOnly
            ] = proxy(ModifyVpcTenancy, request)
            def associateTrunkInterface(
                request: AssociateTrunkInterfaceRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AssociateTrunkInterfaceResponse.ReadOnly
            ] = proxy(AssociateTrunkInterface, request)
            def cancelConversionTask(
                request: CancelConversionTaskRequest
            ): IO[AwsError, Unit] = proxy(CancelConversionTask, request)
            def createTrafficMirrorTarget(
                request: CreateTrafficMirrorTargetRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateTrafficMirrorTargetResponse.ReadOnly
            ] = proxy(CreateTrafficMirrorTarget, request)
            def searchTransitGatewayRoutes(
                request: SearchTransitGatewayRoutesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.SearchTransitGatewayRoutesResponse.ReadOnly
            ] = proxy(SearchTransitGatewayRoutes, request)
            def describeVpcEndpointServices(
                request: DescribeVpcEndpointServicesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.ReadOnly,
              zio.aws.ec2.model.ServiceDetail.ReadOnly
            ]] = proxy(DescribeVpcEndpointServices, request)
            def describeVpcEndpointServicesPaginated(
                request: DescribeVpcEndpointServicesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.ReadOnly
            ] = proxy(DescribeVpcEndpointServicesPaginated, request)
            def deleteLaunchTemplateVersions(
                request: DeleteLaunchTemplateVersionsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponse.ReadOnly
            ] = proxy(DeleteLaunchTemplateVersions, request)
            def createInstanceEventWindow(
                request: CreateInstanceEventWindowRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateInstanceEventWindowResponse.ReadOnly
            ] = proxy(CreateInstanceEventWindow, request)
            def createNatGateway(request: CreateNatGatewayRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateNatGatewayResponse.ReadOnly
            ] = proxy(CreateNatGateway, request)
            def enableSerialConsoleAccess(
                request: EnableSerialConsoleAccessRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.EnableSerialConsoleAccessResponse.ReadOnly
            ] = proxy(EnableSerialConsoleAccess, request)
            def replaceRouteTableAssociation(
                request: ReplaceRouteTableAssociationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ReplaceRouteTableAssociationResponse.ReadOnly
            ] = proxy(ReplaceRouteTableAssociation, request)
            def modifyEbsDefaultKmsKeyId(
                request: ModifyEbsDefaultKmsKeyIdRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdResponse.ReadOnly
            ] = proxy(ModifyEbsDefaultKmsKeyId, request)
            def provisionByoipCidr(request: ProvisionByoipCidrRequest): IO[
              AwsError,
              zio.aws.ec2.model.ProvisionByoipCidrResponse.ReadOnly
            ] = proxy(ProvisionByoipCidr, request)
            def deleteLocalGatewayRoute(
                request: DeleteLocalGatewayRouteRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteLocalGatewayRouteResponse.ReadOnly
            ] = proxy(DeleteLocalGatewayRoute, request)
            def releaseHosts(
                request: ReleaseHostsRequest
            ): IO[AwsError, zio.aws.ec2.model.ReleaseHostsResponse.ReadOnly] =
              proxy(ReleaseHosts, request)
            def describeLaunchTemplates(
                request: DescribeLaunchTemplatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.LaunchTemplate.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeLaunchTemplates, request))
            def describeLaunchTemplatesPaginated(
                request: DescribeLaunchTemplatesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeLaunchTemplatesResponse.ReadOnly
            ] = proxy(DescribeLaunchTemplatesPaginated, request)
            def terminateInstances(request: TerminateInstancesRequest): IO[
              AwsError,
              zio.aws.ec2.model.TerminateInstancesResponse.ReadOnly
            ] = proxy(TerminateInstances, request)
            def getHostReservationPurchasePreview(
                request: GetHostReservationPurchasePreviewRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetHostReservationPurchasePreviewResponse.ReadOnly
            ] = proxy(GetHostReservationPurchasePreview, request)
            def modifyInstanceCreditSpecification(
                request: ModifyInstanceCreditSpecificationRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyInstanceCreditSpecificationResponse.ReadOnly
            ] = proxy(ModifyInstanceCreditSpecification, request)
            def detachVolume(
                request: DetachVolumeRequest
            ): IO[AwsError, zio.aws.ec2.model.DetachVolumeResponse.ReadOnly] =
              proxy(DetachVolume, request)
            def createSnapshot(
                request: CreateSnapshotRequest
            ): IO[AwsError, zio.aws.ec2.model.CreateSnapshotResponse.ReadOnly] =
              proxy(CreateSnapshot, request)
            def getIpamResourceCidrs(
                request: GetIpamResourceCidrsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.IpamResourceCidr.ReadOnly
            ] = rts.unsafeRun(proxy(GetIpamResourceCidrs, request))
            def getIpamResourceCidrsPaginated(
                request: GetIpamResourceCidrsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetIpamResourceCidrsResponse.ReadOnly
            ] = proxy(GetIpamResourceCidrsPaginated, request)
            def modifyReservedInstances(
                request: ModifyReservedInstancesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ModifyReservedInstancesResponse.ReadOnly
            ] = proxy(ModifyReservedInstances, request)
            def createFpgaImage(request: CreateFpgaImageRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateFpgaImageResponse.ReadOnly
            ] = proxy(CreateFpgaImage, request)
            def deprovisionPublicIpv4PoolCidr(
                request: DeprovisionPublicIpv4PoolCidrRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrResponse.ReadOnly
            ] = proxy(DeprovisionPublicIpv4PoolCidr, request)
            def acceptVpcPeeringConnection(
                request: AcceptVpcPeeringConnectionRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.AcceptVpcPeeringConnectionResponse.ReadOnly
            ] = proxy(AcceptVpcPeeringConnection, request)
            def describeTransitGatewayRouteTables(
                request: DescribeTransitGatewayRouteTablesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeTransitGatewayRouteTables, request))
            def describeTransitGatewayRouteTablesPaginated(
                request: DescribeTransitGatewayRouteTablesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribeTransitGatewayRouteTablesResponse.ReadOnly
            ] = proxy(DescribeTransitGatewayRouteTablesPaginated, request)
            def deleteClientVpnEndpoint(
                request: DeleteClientVpnEndpointRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteClientVpnEndpointResponse.ReadOnly
            ] = proxy(DeleteClientVpnEndpoint, request)
            def importInstance(
                request: ImportInstanceRequest
            ): IO[AwsError, zio.aws.ec2.model.ImportInstanceResponse.ReadOnly] =
              proxy(ImportInstance, request)
            def enableFastSnapshotRestores(
                request: EnableFastSnapshotRestoresRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.EnableFastSnapshotRestoresResponse.ReadOnly
            ] = proxy(EnableFastSnapshotRestores, request)
            def getAssociatedEnclaveCertificateIamRoles(
                request: GetAssociatedEnclaveCertificateIamRolesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse.ReadOnly
            ] = proxy(GetAssociatedEnclaveCertificateIamRoles, request)
            def deregisterInstanceEventNotificationAttributes(
                request: DeregisterInstanceEventNotificationAttributesRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesResponse.ReadOnly
            ] = proxy(DeregisterInstanceEventNotificationAttributes, request)
            def resetAddressAttribute(
                request: ResetAddressAttributeRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ResetAddressAttributeResponse.ReadOnly
            ] = proxy(ResetAddressAttribute, request)
            def moveByoipCidrToIpam(request: MoveByoipCidrToIpamRequest): IO[
              AwsError,
              zio.aws.ec2.model.MoveByoipCidrToIpamResponse.ReadOnly
            ] = proxy(MoveByoipCidrToIpam, request)
            def importClientVpnClientCertificateRevocationList(
                request: ImportClientVpnClientCertificateRevocationListRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListResponse.ReadOnly
            ] = proxy(ImportClientVpnClientCertificateRevocationList, request)
            def createSpotDatafeedSubscription(
                request: CreateSpotDatafeedSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.CreateSpotDatafeedSubscriptionResponse.ReadOnly
            ] = proxy(CreateSpotDatafeedSubscription, request)
            def modifyIdentityIdFormat(
                request: ModifyIdentityIdFormatRequest
            ): IO[AwsError, Unit] = proxy(ModifyIdentityIdFormat, request)
            def describePrefixLists(
                request: DescribePrefixListsRequest
            ): ZStream[Any, AwsError, zio.aws.ec2.model.PrefixList.ReadOnly] =
              rts.unsafeRun(proxy(DescribePrefixLists, request))
            def describePrefixListsPaginated(
                request: DescribePrefixListsRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DescribePrefixListsResponse.ReadOnly
            ] = proxy(DescribePrefixListsPaginated, request)
            def createVpnGateway(request: CreateVpnGatewayRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateVpnGatewayResponse.ReadOnly
            ] = proxy(CreateVpnGateway, request)
            def createTags(request: CreateTagsRequest): IO[AwsError, Unit] =
              proxy(CreateTags, request)
            def createSecurityGroup(request: CreateSecurityGroupRequest): IO[
              AwsError,
              zio.aws.ec2.model.CreateSecurityGroupResponse.ReadOnly
            ] = proxy(CreateSecurityGroup, request)
            def deleteInstanceEventWindow(
                request: DeleteInstanceEventWindowRequest
            ): IO[
              AwsError,
              zio.aws.ec2.model.DeleteInstanceEventWindowResponse.ReadOnly
            ] = proxy(DeleteInstanceEventWindow, request)
          }
        }
      }
    }
  }
}
