package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class WithdrawByoipCidrRequest(cidr: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest = {
    import WithdrawByoipCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest
      .builder()
      .cidr(cidr: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.WithdrawByoipCidrRequest.ReadOnly =
    zio.aws.ec2.model.WithdrawByoipCidrRequest.wrap(buildAwsValue())
}
object WithdrawByoipCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.WithdrawByoipCidrRequest =
      zio.aws.ec2.model.WithdrawByoipCidrRequest(cidr)
    def cidr: String
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest
  ) extends zio.aws.ec2.model.WithdrawByoipCidrRequest.ReadOnly {
    override val cidr: String = impl.cidr(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest
  ): zio.aws.ec2.model.WithdrawByoipCidrRequest.ReadOnly = new Wrapper(impl)
}
