package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpnStaticRoute(
    destinationCidrBlock: Optional[String] = Optional.Absent,
    source: Optional[zio.aws.ec2.model.VpnStaticRouteSource] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.VpnState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpnStaticRoute = {
    import VpnStaticRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpnStaticRoute
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(source.map(value => value.unwrap))(_.source)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpnStaticRoute.ReadOnly =
    zio.aws.ec2.model.VpnStaticRoute.wrap(buildAwsValue())
}
object VpnStaticRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpnStaticRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpnStaticRoute =
      zio.aws.ec2.model.VpnStaticRoute(
        destinationCidrBlock.map(value => value),
        source.map(value => value),
        state.map(value => value)
      )
    def destinationCidrBlock: Optional[String]
    def source: Optional[zio.aws.ec2.model.VpnStaticRouteSource]
    def state: Optional[zio.aws.ec2.model.VpnState]
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getSource: ZIO[Any, AwsError, zio.aws.ec2.model.VpnStaticRouteSource] =
      AwsError.unwrapOptionField("source", source)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.VpnState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpnStaticRoute
  ) extends zio.aws.ec2.model.VpnStaticRoute.ReadOnly {
    override val destinationCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidrBlock())
      .map(value => value: String)
    override val source: Optional[zio.aws.ec2.model.VpnStaticRouteSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.ec2.model.VpnStaticRouteSource.wrap(value))
    override val state: Optional[zio.aws.ec2.model.VpnState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.VpnState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpnStaticRoute
  ): zio.aws.ec2.model.VpnStaticRoute.ReadOnly = new Wrapper(impl)
}
