package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait UnsuccessfulInstanceCreditSpecificationErrorCode {
  def unwrap: software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode
}
object UnsuccessfulInstanceCreditSpecificationErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode
  ): zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode =
    value match {
      case software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode.INVALID_INSTANCE_ID_MALFORMED =>
        val r = `InvalidInstanceID.Malformed`
        r
      case software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode.INVALID_INSTANCE_ID_NOT_FOUND =>
        val r = `InvalidInstanceID.NotFound`
        r
      case software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode.INCORRECT_INSTANCE_STATE =>
        val r = IncorrectInstanceState
        r
      case software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode.INSTANCE_CREDIT_SPECIFICATION_NOT_SUPPORTED =>
        val r = `InstanceCreditSpecification.NotSupported`
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode =
      software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object `InvalidInstanceID.Malformed`
      extends zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode =
      software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode.INVALID_INSTANCE_ID_MALFORMED
  }
  case object `InvalidInstanceID.NotFound`
      extends zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode =
      software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode.INVALID_INSTANCE_ID_NOT_FOUND
  }
  case object IncorrectInstanceState
      extends zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode =
      software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode.INCORRECT_INSTANCE_STATE
  }
  case object `InstanceCreditSpecification.NotSupported`
      extends zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode =
      software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationErrorCode.INSTANCE_CREDIT_SPECIFICATION_NOT_SUPPORTED
  }
}
