package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartNetworkInsightsAccessScopeAnalysisRequest(
    networkInsightsAccessScopeId: NetworkInsightsAccessScopeId,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    clientToken: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest = {
    import StartNetworkInsightsAccessScopeAnalysisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest
      .builder()
      .networkInsightsAccessScopeId(
        NetworkInsightsAccessScopeId.unwrap(
          networkInsightsAccessScopeId
        ): java.lang.String
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .clientToken(clientToken: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest.ReadOnly =
    zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest
      .wrap(buildAwsValue())
}
object StartNetworkInsightsAccessScopeAnalysisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest =
      zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest(
        networkInsightsAccessScopeId,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken
      )
    def networkInsightsAccessScopeId: NetworkInsightsAccessScopeId
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: String
    def getNetworkInsightsAccessScopeId
        : ZIO[Any, Nothing, NetworkInsightsAccessScopeId] =
      ZIO.succeed(networkInsightsAccessScopeId)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, Nothing, String] = ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest
  ) extends zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest.ReadOnly {
    override val networkInsightsAccessScopeId: NetworkInsightsAccessScopeId =
      zio.aws.ec2.model.primitives
        .NetworkInsightsAccessScopeId(impl.networkInsightsAccessScopeId())
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val clientToken: String = impl.clientToken(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest
  ): zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest.ReadOnly =
    new Wrapper(impl)
}
