package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartInstancesRequest(
    instanceIds: Iterable[InstanceId],
    additionalInfo: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StartInstancesRequest = {
    import StartInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StartInstancesRequest
      .builder()
      .instanceIds(instanceIds.map { item =>
        InstanceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(additionalInfo.map(value => value: java.lang.String))(
        _.additionalInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.StartInstancesRequest.ReadOnly =
    zio.aws.ec2.model.StartInstancesRequest.wrap(buildAwsValue())
}
object StartInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StartInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.StartInstancesRequest = zio.aws.ec2.model
      .StartInstancesRequest(instanceIds, additionalInfo.map(value => value))
    def instanceIds: List[InstanceId]
    def additionalInfo: Optional[String]
    def getInstanceIds: ZIO[Any, Nothing, List[InstanceId]] =
      ZIO.succeed(instanceIds)
    def getAdditionalInfo: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StartInstancesRequest
  ) extends zio.aws.ec2.model.StartInstancesRequest.ReadOnly {
    override val instanceIds: List[InstanceId] = impl
      .instanceIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.InstanceId(item)
      }
      .toList
    override val additionalInfo: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalInfo())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StartInstancesRequest
  ): zio.aws.ec2.model.StartInstancesRequest.ReadOnly = new Wrapper(impl)
}
