package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class SpotPrice(
    availabilityZone: Optional[String] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    productDescription: Optional[zio.aws.ec2.model.RIProductDescription] =
      Optional.Absent,
    spotPrice: Optional[String] = Optional.Absent,
    timestamp: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.SpotPrice = {
    import SpotPrice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotPrice
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(productDescription.map(value => value.unwrap))(
        _.productDescription
      )
      .optionallyWith(spotPrice.map(value => value: java.lang.String))(
        _.spotPrice
      )
      .optionallyWith(timestamp.map(value => DateTime.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotPrice.ReadOnly =
    zio.aws.ec2.model.SpotPrice.wrap(buildAwsValue())
}
object SpotPrice {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.SpotPrice] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotPrice = zio.aws.ec2.model.SpotPrice(
      availabilityZone.map(value => value),
      instanceType.map(value => value),
      productDescription.map(value => value),
      spotPrice.map(value => value),
      timestamp.map(value => value)
    )
    def availabilityZone: Optional[String]
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def productDescription: Optional[zio.aws.ec2.model.RIProductDescription]
    def spotPrice: Optional[String]
    def timestamp: Optional[DateTime]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getProductDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.RIProductDescription] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getSpotPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotPrice", spotPrice)
    def getTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotPrice
  ) extends zio.aws.ec2.model.SpotPrice.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val productDescription
        : Optional[zio.aws.ec2.model.RIProductDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productDescription())
        .map(value => zio.aws.ec2.model.RIProductDescription.wrap(value))
    override val spotPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotPrice())
      .map(value => value: String)
    override val timestamp: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotPrice
  ): zio.aws.ec2.model.SpotPrice.ReadOnly = new Wrapper(impl)
}
