package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait SnapshotAttributeName {
  def unwrap: software.amazon.awssdk.services.ec2.model.SnapshotAttributeName
}
object SnapshotAttributeName {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.SnapshotAttributeName
  ): zio.aws.ec2.model.SnapshotAttributeName = value match {
    case software.amazon.awssdk.services.ec2.model.SnapshotAttributeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.SnapshotAttributeName.PRODUCT_CODES =>
      val r = productCodes
      r
    case software.amazon.awssdk.services.ec2.model.SnapshotAttributeName.CREATE_VOLUME_PERMISSION =>
      val r = createVolumePermission
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.SnapshotAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SnapshotAttributeName =
      software.amazon.awssdk.services.ec2.model.SnapshotAttributeName.UNKNOWN_TO_SDK_VERSION
  }
  case object productCodes extends zio.aws.ec2.model.SnapshotAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SnapshotAttributeName =
      software.amazon.awssdk.services.ec2.model.SnapshotAttributeName.PRODUCT_CODES
  }
  case object createVolumePermission
      extends zio.aws.ec2.model.SnapshotAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SnapshotAttributeName =
      software.amazon.awssdk.services.ec2.model.SnapshotAttributeName.CREATE_VOLUME_PERMISSION
  }
}
