package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ServiceConnectivityType {
  def unwrap: software.amazon.awssdk.services.ec2.model.ServiceConnectivityType
}
object ServiceConnectivityType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ServiceConnectivityType
  ): zio.aws.ec2.model.ServiceConnectivityType = value match {
    case software.amazon.awssdk.services.ec2.model.ServiceConnectivityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ServiceConnectivityType.IPV4 =>
      val r = ipv4
      r
    case software.amazon.awssdk.services.ec2.model.ServiceConnectivityType.IPV6 =>
      val r = ipv6
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ServiceConnectivityType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ServiceConnectivityType =
      software.amazon.awssdk.services.ec2.model.ServiceConnectivityType.UNKNOWN_TO_SDK_VERSION
  }
  case object ipv4 extends zio.aws.ec2.model.ServiceConnectivityType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ServiceConnectivityType =
      software.amazon.awssdk.services.ec2.model.ServiceConnectivityType.IPV4
  }
  case object ipv6 extends zio.aws.ec2.model.ServiceConnectivityType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ServiceConnectivityType =
      software.amazon.awssdk.services.ec2.model.ServiceConnectivityType.IPV6
  }
}
