package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkInterface(
    association: Optional[zio.aws.ec2.model.NetworkInterfaceAssociation] =
      Optional.Absent,
    attachment: Optional[zio.aws.ec2.model.NetworkInterfaceAttachment] =
      Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    groups: Optional[Iterable[zio.aws.ec2.model.GroupIdentifier]] =
      Optional.Absent,
    interfaceType: Optional[zio.aws.ec2.model.NetworkInterfaceType] =
      Optional.Absent,
    ipv6Addresses: Optional[
      Iterable[zio.aws.ec2.model.NetworkInterfaceIpv6Address]
    ] = Optional.Absent,
    macAddress: Optional[String] = Optional.Absent,
    networkInterfaceId: Optional[String] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    privateDnsName: Optional[String] = Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent,
    privateIpAddresses: Optional[
      Iterable[zio.aws.ec2.model.NetworkInterfacePrivateIpAddress]
    ] = Optional.Absent,
    ipv4Prefixes: Optional[
      Iterable[zio.aws.ec2.model.Ipv4PrefixSpecification]
    ] = Optional.Absent,
    ipv6Prefixes: Optional[
      Iterable[zio.aws.ec2.model.Ipv6PrefixSpecification]
    ] = Optional.Absent,
    requesterId: Optional[String] = Optional.Absent,
    requesterManaged: Optional[Boolean] = Optional.Absent,
    sourceDestCheck: Optional[Boolean] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.NetworkInterfaceStatus] =
      Optional.Absent,
    subnetId: Optional[String] = Optional.Absent,
    tagSet: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    denyAllIgwTraffic: Optional[Boolean] = Optional.Absent,
    ipv6Native: Optional[Boolean] = Optional.Absent,
    ipv6Address: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInterface = {
    import NetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInterface
      .builder()
      .optionallyWith(association.map(value => value.buildAwsValue()))(
        _.association
      )
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(interfaceType.map(value => value.unwrap))(_.interfaceType)
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(macAddress.map(value => value: java.lang.String))(
        _.macAddress
      )
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv4Prefixes)
      .optionallyWith(
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Prefixes)
      .optionallyWith(requesterId.map(value => value: java.lang.String))(
        _.requesterId
      )
      .optionallyWith(requesterManaged.map(value => value: java.lang.Boolean))(
        _.requesterManaged
      )
      .optionallyWith(sourceDestCheck.map(value => value: java.lang.Boolean))(
        _.sourceDestCheck
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(
        tagSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSet)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(denyAllIgwTraffic.map(value => value: java.lang.Boolean))(
        _.denyAllIgwTraffic
      )
      .optionallyWith(ipv6Native.map(value => value: java.lang.Boolean))(
        _.ipv6Native
      )
      .optionallyWith(ipv6Address.map(value => value: java.lang.String))(
        _.ipv6Address
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInterface.ReadOnly =
    zio.aws.ec2.model.NetworkInterface.wrap(buildAwsValue())
}
object NetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInterface =
      zio.aws.ec2.model.NetworkInterface(
        association.map(value => value.asEditable),
        attachment.map(value => value.asEditable),
        availabilityZone.map(value => value),
        description.map(value => value),
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        interfaceType.map(value => value),
        ipv6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        macAddress.map(value => value),
        networkInterfaceId.map(value => value),
        outpostArn.map(value => value),
        ownerId.map(value => value),
        privateDnsName.map(value => value),
        privateIpAddress.map(value => value),
        privateIpAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requesterId.map(value => value),
        requesterManaged.map(value => value),
        sourceDestCheck.map(value => value),
        status.map(value => value),
        subnetId.map(value => value),
        tagSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value),
        denyAllIgwTraffic.map(value => value),
        ipv6Native.map(value => value),
        ipv6Address.map(value => value)
      )
    def association
        : Optional[zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly]
    def attachment
        : Optional[zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly]
    def availabilityZone: Optional[String]
    def description: Optional[String]
    def groups: Optional[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def interfaceType: Optional[zio.aws.ec2.model.NetworkInterfaceType]
    def ipv6Addresses
        : Optional[List[zio.aws.ec2.model.NetworkInterfaceIpv6Address.ReadOnly]]
    def macAddress: Optional[String]
    def networkInterfaceId: Optional[String]
    def outpostArn: Optional[String]
    def ownerId: Optional[String]
    def privateDnsName: Optional[String]
    def privateIpAddress: Optional[String]
    def privateIpAddresses: Optional[
      List[zio.aws.ec2.model.NetworkInterfacePrivateIpAddress.ReadOnly]
    ]
    def ipv4Prefixes
        : Optional[List[zio.aws.ec2.model.Ipv4PrefixSpecification.ReadOnly]]
    def ipv6Prefixes
        : Optional[List[zio.aws.ec2.model.Ipv6PrefixSpecification.ReadOnly]]
    def requesterId: Optional[String]
    def requesterManaged: Optional[Boolean]
    def sourceDestCheck: Optional[Boolean]
    def status: Optional[zio.aws.ec2.model.NetworkInterfaceStatus]
    def subnetId: Optional[String]
    def tagSet: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def vpcId: Optional[String]
    def denyAllIgwTraffic: Optional[Boolean]
    def ipv6Native: Optional[Boolean]
    def ipv6Address: Optional[String]
    def getAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("association", association)
    def getAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly
    ] = AwsError.unwrapOptionField("attachment", attachment)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("groups", groups)
    def getInterfaceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInterfaceType] =
      AwsError.unwrapOptionField("interfaceType", interfaceType)
    def getIpv6Addresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NetworkInterfaceIpv6Address.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getMacAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("macAddress", macAddress)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NetworkInterfacePrivateIpAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getIpv4Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ipv4PrefixSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv4Prefixes", ipv4Prefixes)
    def getIpv6Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ipv6PrefixSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Prefixes", ipv6Prefixes)
    def getRequesterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requesterId", requesterId)
    def getRequesterManaged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requesterManaged", requesterManaged)
    def getSourceDestCheck: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInterfaceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getTagSet: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagSet", tagSet)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getDenyAllIgwTraffic: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("denyAllIgwTraffic", denyAllIgwTraffic)
    def getIpv6Native: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ipv6Native", ipv6Native)
    def getIpv6Address: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6Address", ipv6Address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterface
  ) extends zio.aws.ec2.model.NetworkInterface.ReadOnly {
    override val association
        : Optional[zio.aws.ec2.model.NetworkInterfaceAssociation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.association())
        .map(value => zio.aws.ec2.model.NetworkInterfaceAssociation.wrap(value))
    override val attachment
        : Optional[zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachment())
        .map(value => zio.aws.ec2.model.NetworkInterfaceAttachment.wrap(value))
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val groups
        : Optional[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.GroupIdentifier.wrap(item)
          }.toList
        )
    override val interfaceType
        : Optional[zio.aws.ec2.model.NetworkInterfaceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interfaceType())
        .map(value => zio.aws.ec2.model.NetworkInterfaceType.wrap(value))
    override val ipv6Addresses: Optional[
      List[zio.aws.ec2.model.NetworkInterfaceIpv6Address.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.NetworkInterfaceIpv6Address.wrap(item)
        }.toList
      )
    override val macAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.macAddress())
      .map(value => value: String)
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val privateDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsName())
      .map(value => value: String)
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
    override val privateIpAddresses: Optional[
      List[zio.aws.ec2.model.NetworkInterfacePrivateIpAddress.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.NetworkInterfacePrivateIpAddress.wrap(item)
        }.toList
      )
    override val ipv4Prefixes
        : Optional[List[zio.aws.ec2.model.Ipv4PrefixSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv4Prefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Ipv4PrefixSpecification.wrap(item)
          }.toList
        )
    override val ipv6Prefixes
        : Optional[List[zio.aws.ec2.model.Ipv6PrefixSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6Prefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Ipv6PrefixSpecification.wrap(item)
          }.toList
        )
    override val requesterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requesterId())
      .map(value => value: String)
    override val requesterManaged: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.requesterManaged())
      .map(value => value: Boolean)
    override val sourceDestCheck: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDestCheck())
      .map(value => value: Boolean)
    override val status: Optional[zio.aws.ec2.model.NetworkInterfaceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.NetworkInterfaceStatus.wrap(value))
    override val subnetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => value: String)
    override val tagSet: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val denyAllIgwTraffic: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.denyAllIgwTraffic())
      .map(value => value: Boolean)
    override val ipv6Native: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Native())
      .map(value => value: Boolean)
    override val ipv6Address: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Address())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterface
  ): zio.aws.ec2.model.NetworkInterface.ReadOnly = new Wrapper(impl)
}
