package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.AllocationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyAddressAttributeRequest(
    allocationId: AllocationId,
    domainName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeRequest = {
    import ModifyAddressAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeRequest
      .builder()
      .allocationId(AllocationId.unwrap(allocationId): java.lang.String)
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyAddressAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyAddressAttributeRequest.wrap(buildAwsValue())
}
object ModifyAddressAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyAddressAttributeRequest =
      zio.aws.ec2.model.ModifyAddressAttributeRequest(
        allocationId,
        domainName.map(value => value)
      )
    def allocationId: AllocationId
    def domainName: Optional[String]
    def getAllocationId: ZIO[Any, Nothing, AllocationId] =
      ZIO.succeed(allocationId)
    def getDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainName", domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeRequest
  ) extends zio.aws.ec2.model.ModifyAddressAttributeRequest.ReadOnly {
    override val allocationId: AllocationId =
      zio.aws.ec2.model.primitives.AllocationId(impl.allocationId())
    override val domainName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeRequest
  ): zio.aws.ec2.model.ModifyAddressAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
