package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{Integer, MillisecondDateTime}
import scala.jdk.CollectionConverters._
final case class FlowLog(
    creationTime: Optional[MillisecondDateTime] = Optional.Absent,
    deliverLogsErrorMessage: Optional[String] = Optional.Absent,
    deliverLogsPermissionArn: Optional[String] = Optional.Absent,
    deliverLogsStatus: Optional[String] = Optional.Absent,
    flowLogId: Optional[String] = Optional.Absent,
    flowLogStatus: Optional[String] = Optional.Absent,
    logGroupName: Optional[String] = Optional.Absent,
    resourceId: Optional[String] = Optional.Absent,
    trafficType: Optional[zio.aws.ec2.model.TrafficType] = Optional.Absent,
    logDestinationType: Optional[zio.aws.ec2.model.LogDestinationType] =
      Optional.Absent,
    logDestination: Optional[String] = Optional.Absent,
    logFormat: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    maxAggregationInterval: Optional[Integer] = Optional.Absent,
    destinationOptions: Optional[zio.aws.ec2.model.DestinationOptionsResponse] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.FlowLog = {
    import FlowLog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FlowLog
      .builder()
      .optionallyWith(
        creationTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        deliverLogsErrorMessage.map(value => value: java.lang.String)
      )(_.deliverLogsErrorMessage)
      .optionallyWith(
        deliverLogsPermissionArn.map(value => value: java.lang.String)
      )(_.deliverLogsPermissionArn)
      .optionallyWith(deliverLogsStatus.map(value => value: java.lang.String))(
        _.deliverLogsStatus
      )
      .optionallyWith(flowLogId.map(value => value: java.lang.String))(
        _.flowLogId
      )
      .optionallyWith(flowLogStatus.map(value => value: java.lang.String))(
        _.flowLogStatus
      )
      .optionallyWith(logGroupName.map(value => value: java.lang.String))(
        _.logGroupName
      )
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(trafficType.map(value => value.unwrap))(_.trafficType)
      .optionallyWith(logDestinationType.map(value => value.unwrap))(
        _.logDestinationType
      )
      .optionallyWith(logDestination.map(value => value: java.lang.String))(
        _.logDestination
      )
      .optionallyWith(logFormat.map(value => value: java.lang.String))(
        _.logFormat
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        maxAggregationInterval.map(value => value: java.lang.Integer)
      )(_.maxAggregationInterval)
      .optionallyWith(destinationOptions.map(value => value.buildAwsValue()))(
        _.destinationOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FlowLog.ReadOnly =
    zio.aws.ec2.model.FlowLog.wrap(buildAwsValue())
}
object FlowLog {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.FlowLog] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FlowLog = zio.aws.ec2.model.FlowLog(
      creationTime.map(value => value),
      deliverLogsErrorMessage.map(value => value),
      deliverLogsPermissionArn.map(value => value),
      deliverLogsStatus.map(value => value),
      flowLogId.map(value => value),
      flowLogStatus.map(value => value),
      logGroupName.map(value => value),
      resourceId.map(value => value),
      trafficType.map(value => value),
      logDestinationType.map(value => value),
      logDestination.map(value => value),
      logFormat.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      maxAggregationInterval.map(value => value),
      destinationOptions.map(value => value.asEditable)
    )
    def creationTime: Optional[MillisecondDateTime]
    def deliverLogsErrorMessage: Optional[String]
    def deliverLogsPermissionArn: Optional[String]
    def deliverLogsStatus: Optional[String]
    def flowLogId: Optional[String]
    def flowLogStatus: Optional[String]
    def logGroupName: Optional[String]
    def resourceId: Optional[String]
    def trafficType: Optional[zio.aws.ec2.model.TrafficType]
    def logDestinationType: Optional[zio.aws.ec2.model.LogDestinationType]
    def logDestination: Optional[String]
    def logFormat: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def maxAggregationInterval: Optional[Integer]
    def destinationOptions
        : Optional[zio.aws.ec2.model.DestinationOptionsResponse.ReadOnly]
    def getCreationTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDeliverLogsErrorMessage: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("deliverLogsErrorMessage", deliverLogsErrorMessage)
    def getDeliverLogsPermissionArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("deliverLogsPermissionArn", deliverLogsPermissionArn)
    def getDeliverLogsStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deliverLogsStatus", deliverLogsStatus)
    def getFlowLogId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("flowLogId", flowLogId)
    def getFlowLogStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("flowLogStatus", flowLogStatus)
    def getLogGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getTrafficType: ZIO[Any, AwsError, zio.aws.ec2.model.TrafficType] =
      AwsError.unwrapOptionField("trafficType", trafficType)
    def getLogDestinationType
        : ZIO[Any, AwsError, zio.aws.ec2.model.LogDestinationType] =
      AwsError.unwrapOptionField("logDestinationType", logDestinationType)
    def getLogDestination: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logDestination", logDestination)
    def getLogFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logFormat", logFormat)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getMaxAggregationInterval: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxAggregationInterval", maxAggregationInterval)
    def getDestinationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DestinationOptionsResponse.ReadOnly
    ] = AwsError.unwrapOptionField("destinationOptions", destinationOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FlowLog
  ) extends zio.aws.ec2.model.FlowLog.ReadOnly {
    override val creationTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val deliverLogsErrorMessage: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliverLogsErrorMessage())
        .map(value => value: String)
    override val deliverLogsPermissionArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliverLogsPermissionArn())
        .map(value => value: String)
    override val deliverLogsStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deliverLogsStatus())
      .map(value => value: String)
    override val flowLogId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.flowLogId())
      .map(value => value: String)
    override val flowLogStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.flowLogStatus())
      .map(value => value: String)
    override val logGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroupName())
      .map(value => value: String)
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val trafficType: Optional[zio.aws.ec2.model.TrafficType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficType())
        .map(value => zio.aws.ec2.model.TrafficType.wrap(value))
    override val logDestinationType
        : Optional[zio.aws.ec2.model.LogDestinationType] = zio.aws.core.internal
      .optionalFromNullable(impl.logDestinationType())
      .map(value => zio.aws.ec2.model.LogDestinationType.wrap(value))
    override val logDestination: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logDestination())
      .map(value => value: String)
    override val logFormat: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logFormat())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val maxAggregationInterval: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxAggregationInterval())
        .map(value => value: Integer)
    override val destinationOptions
        : Optional[zio.aws.ec2.model.DestinationOptionsResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationOptions())
        .map(value => zio.aws.ec2.model.DestinationOptionsResponse.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FlowLog
  ): zio.aws.ec2.model.FlowLog.ReadOnly = new Wrapper(impl)
}
