package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{DiskCount, DiskSize}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DiskInfo(
    sizeInGB: Optional[DiskSize] = Optional.Absent,
    count: Optional[DiskCount] = Optional.Absent,
    `type`: Optional[zio.aws.ec2.model.DiskType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.DiskInfo = {
    import DiskInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DiskInfo
      .builder()
      .optionallyWith(
        sizeInGB.map(value => DiskSize.unwrap(value): java.lang.Long)
      )(_.sizeInGB)
      .optionallyWith(count.map(value => DiskCount.unwrap(value): Integer))(
        _.count
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DiskInfo.ReadOnly =
    zio.aws.ec2.model.DiskInfo.wrap(buildAwsValue())
}
object DiskInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.DiskInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DiskInfo = zio.aws.ec2.model.DiskInfo(
      sizeInGB.map(value => value),
      count.map(value => value),
      `type`.map(value => value)
    )
    def sizeInGB: Optional[DiskSize]
    def count: Optional[DiskCount]
    def `type`: Optional[zio.aws.ec2.model.DiskType]
    def getSizeInGB: ZIO[Any, AwsError, DiskSize] =
      AwsError.unwrapOptionField("sizeInGB", sizeInGB)
    def getCount: ZIO[Any, AwsError, DiskCount] =
      AwsError.unwrapOptionField("count", count)
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.DiskType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DiskInfo
  ) extends zio.aws.ec2.model.DiskInfo.ReadOnly {
    override val sizeInGB: Optional[DiskSize] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeInGB())
      .map(value => zio.aws.ec2.model.primitives.DiskSize(value))
    override val count: Optional[DiskCount] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => zio.aws.ec2.model.primitives.DiskCount(value))
    override val `type`: Optional[zio.aws.ec2.model.DiskType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ec2.model.DiskType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DiskInfo
  ): zio.aws.ec2.model.DiskInfo.ReadOnly = new Wrapper(impl)
}
