package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeprovisionByoipCidrRequest(cidr: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest = {
    import DeprovisionByoipCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest
      .builder()
      .cidr(cidr: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeprovisionByoipCidrRequest.ReadOnly =
    zio.aws.ec2.model.DeprovisionByoipCidrRequest.wrap(buildAwsValue())
}
object DeprovisionByoipCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeprovisionByoipCidrRequest =
      zio.aws.ec2.model.DeprovisionByoipCidrRequest(cidr)
    def cidr: String
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest
  ) extends zio.aws.ec2.model.DeprovisionByoipCidrRequest.ReadOnly {
    override val cidr: String = impl.cidr(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest
  ): zio.aws.ec2.model.DeprovisionByoipCidrRequest.ReadOnly = new Wrapper(impl)
}
