package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SnapshotId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSnapshotRequest(snapshotId: SnapshotId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest = {
    import DeleteSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest
      .builder()
      .snapshotId(SnapshotId.unwrap(snapshotId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteSnapshotRequest.ReadOnly =
    zio.aws.ec2.model.DeleteSnapshotRequest.wrap(buildAwsValue())
}
object DeleteSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteSnapshotRequest =
      zio.aws.ec2.model.DeleteSnapshotRequest(snapshotId)
    def snapshotId: SnapshotId
    def getSnapshotId: ZIO[Any, Nothing, SnapshotId] = ZIO.succeed(snapshotId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest
  ) extends zio.aws.ec2.model.DeleteSnapshotRequest.ReadOnly {
    override val snapshotId: SnapshotId =
      zio.aws.ec2.model.primitives.SnapshotId(impl.snapshotId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest
  ): zio.aws.ec2.model.DeleteSnapshotRequest.ReadOnly = new Wrapper(impl)
}
